<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Lib\RequiredConfig;
use App\Models\Car;
use App\Models\CarsOrder;
use App\Rules\FileTypeValidate;
use Illuminate\Http\Request;
use App\Constants\Status;


class InventoryController extends Controller
{

    public function index()
    {
        $pageTitle = "Manage Inventories";
        $inventories     = Car::orderBy('id')->get();
        return view('admin.inventories.index', compact('pageTitle', 'inventories'));
    }


    public function report()
    {
        $pageTitle = "Manage Order";
        $orders     = CarsOrder::orderBy('id')->get();
        return view('admin.inventories.orders', compact('pageTitle', 'orders'));
    }



    public function store(Request $request)
    {
        $this->validation($request);
        $car = new Car();
        $this->submitData($car, $request);
        RequiredConfig::configured('cars');
        $notify[] = ['success', 'Inventory added successfully'];
        return back()->withNotify($notify);
    }

    public function update(Request $request, $id)
    {
        $this->validation($request);
        $car = Car::findOrFail($id);
        $this->submitData($car, $request);

        $notify[] = ['success', 'Car updated successfully'];
        return back()->withNotify($notify);
    }

    public function submitData($car, $request)
    {
        $car->name = $request->name;
        $car->details = $request->details;
        $car->purchase = $request->purchase;
        $car->lease = $request->lease;
        $car->finance = $request->finance;
        $car->range = $request->range;
        $car->color = $request->color;
        $car->year = $request->year;
        $car->topspeed = $request->topspeed;
        $car->mph = $request->mph;
        $car->soldout = $request->soldout;
        $car->details = $request->details;
        if ($request->hasFile('image')) {
            try {
                $filename = fileUploader($request->image,getFilePath('inventory'));
                $car->image          = $filename;
            } catch (\Exception $exp) {
                $notify[] = ['error', 'Image could not be uploaded: ' . $exp->getMessage()];
                return $exp->getMessage();
            } 
        }
        $car->save(); 
    }

    public function validation($request)
    {
        $request->validate([
            'name' => 'required',
            'color' => 'required',
            'details' => 'required',
            'purchase' => 'required',
            'lease' => 'required',
            'finance' => 'required',
            'range' => 'required',
            'topspeed' => 'required',
            'mph' => 'required',
            'image' => ['nullable', 'image', new FileTypeValidate(['jpg', 'jpeg', 'png'])],
        ]);
    }

    public function status($id)
    {
        return Car::changeStatus($id);
    }

    public function Orderstatus($id)
    {
          $query     = CarsOrder::findOrFail($id);
          $column = 'status';
        if ($query->$column == Status::ENABLE) {
            $query->$column = Status::DISABLE;
        } else {
            $query->$column = Status::ENABLE;
        }
        $message       = keyToTitle($column). ' changed successfully';

        $query->save();
        $notify[] = ['success', $message];
        return back()->withNotify($notify); 
    }

    public function soldout($id)
    {
        return Car::changeSold($id);
    }
}
