@extends('admin.layouts.app')
@section('panel') 
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Color')</th>
                                    <th>@lang('Year')</th>
                                    <th>@lang('Purchase')</th>
                                    <th>@lang('Lease')</th>
                                    <th>@lang('Finance')</th>
                                    <th>@lang('Range')</th>
                                    <th>@lang('Top Speed')</th>
                                    <th>@lang('Mph')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Sold Out')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($inventories as $inventory)
                                    <tr>
                                        <td>{{ $inventory->name }}</td>
                                        <td>{{ $inventory->color }}</td>
                                        <td>{{ $inventory->year }}</td>
                                        <td>{{ $inventory->purchase }}</td>
                                        <td>{{ $inventory->lease }}</td>
                                        <td>{{ $inventory->finance }}</td>
                                        <td>{{ $inventory->range }}</td>
                                        <td>{{ $inventory->topspeed }}</td>
                                        <td>{{ $inventory->mph }}</td>
                                        <td>
                                            @if ($inventory->status == 1)
                                                <span class="badge badge--success">@lang('Active')</span>
                                            @else
                                                <span class="badge badge--warning">@lang('Inactive')</span>
                                            @endif
                                        </td>
                                         <td>
                                            @if ($inventory->soldout == 1)
                                                <span class="badge badge--danger">@lang('Sold Out')</span>
                                            @else
                                                <span class="badge badge--success">@lang('Available')</span>
                                            @endif
                                        </td>
                                        <td>
<a href="javascript:void(0)" 
    data-route="{{ route('admin.inventory.update', $inventory->id) }}" 
    data-name="{{ $inventory->name }}" 
    data-purchase="{{ $inventory->purchase }}" 
    data-lease="{{ $inventory->lease }}" 
    data-color="{{ $inventory->color }}" 
    data-finance="{{ $inventory->finance }}" 
    data-range="{{ $inventory->range }}" 
    data-mph="{{ $inventory->mph }}" 
    data-year="{{ $inventory->year }}" 
    data-topspeed="{{ $inventory->topspeed }}" 
    data-details="{{ $inventory->details }}" 
    data-bs-toggle="modal" 
    data-bs-target="#editModal" 
    class="btn btn-outline--primary editBtn btn-sm me-2">
    <i class="las la-pen"></i>@lang('Edit')
</a>                                            @if ($inventory->status)
                                                <button class="btn btn-sm btn-outline--danger confirmationBtn" data-question="@lang('Are you sure to disable this inventory?')" data-action="{{ route('admin.inventory.status', $inventory->id) }}"><i class="las la-eye-slash"></i>@lang('Disable')</button>
                                            @else
                                                <button class="btn btn-sm btn-outline--success confirmationBtn" data-question="@lang('Are you sure to enable this inventory?')" data-action="{{ route('admin.inventory.status', $inventory->id) }}"><i class="las la-eye"></i>@lang('Enable')</button>
                                            @endif

                                            @if ($inventory->soldout)
                                                <button class="btn btn-sm btn-outline--success confirmationBtn" data-question="@lang('Are you sure to mark this inventory as sold out?')" data-action="{{ route('admin.inventory.soldout', $inventory->id) }}"><i class="las la-eye-slash"></i>@lang('Mark as Sold Out')</button>
                                            @else
                                                <button class="btn btn-sm btn-outline--danger confirmationBtn" data-question="@lang('Are you sure to mark this inventory as not sold out ?')" data-action="{{ route('admin.inventory.soldout', $inventory->id) }}"><i class="las la-eye"></i>@lang('Mark Not Sold Out')</button>
                                            @endif
                                        </td>

                                        <td>

                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="editModal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title"> @lang('Edit Inventory')</h4>
                    <button type="button" class="close" data-bs-dismiss="modal"><span><i class="las la-times"></i></span></button>
                </div>
                <form method="post"  enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label>@lang('Name') </label>
                            <input type="text" class="form-control" placeholder="@lang('Tesla X')" name="name" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Color') </label>
                            <input type="text" class="form-control" placeholder="@lang('Red')" name="color" required>
                        </div>

                        <div class="form-group">
                            <label>@lang('Year') </label>
                            <input type="number" class="form-control" placeholder="@lang('2023')" name="year" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Purchase Price') </label>
                            <input type="number" class="form-control" placeholder="@lang('0.00')" name="purchase" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Lease Price') </label>
                            <input type="number" class="form-control" placeholder="@lang('0.00')" name="lease" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Finance') </label>
                            <input type="number" class="form-control" placeholder="@lang('0.00')" name="finance" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Range') </label>
                            <input type="text" class="form-control" placeholder="@lang('Tesla X')" name="range" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('mph') </label>
                            <input type="text" class="form-control" placeholder="@lang('100mph')" name="mph" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Top Speed') </label>
                            <input type="text" class="form-control" placeholder="@lang('130 mph')" name="topspeed" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Image') </label>
                            <input type="file" class="form-control" placeholder="@lang('130 mph')" name="image">
                        </div>
                        <div class="form-group">
                            <label>@lang('Description') </label>
                            <textarea type="text" class="form-control" placeholder="@lang('Enter inventory Details')" name="details" required></textarea>
                        </div>
 
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45"><i class="fa fa-send"></i> @lang('Update')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <div class="modal fade" id="carModal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">@lang('Add New Car Inventory')</h4>
                    <button type="button" class="close" data-bs-dismiss="modal"><span><i class="las la-times"></i></span></button>
                </div>
                <form method="post" action="{{ route('admin.inventory.store') }}"  enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">

                        <div class="form-group">
                            <label>@lang('Name') </label>
                            <input type="text" class="form-control" placeholder="@lang('Tesla X')" name="name" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Color') </label>
                            <input type="text" class="form-control" placeholder="@lang('Red')" name="color" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Year') </label>
                            <input type="number" class="form-control" placeholder="@lang('2023')" name="year" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Purchase Price') </label>
                            <input type="number" class="form-control" placeholder="@lang('0.00')" name="purchase" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Lease Price') </label>
                            <input type="number" class="form-control" placeholder="@lang('0.00')" name="lease" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Finance') </label>
                            <input type="number" class="form-control" placeholder="@lang('0.00')" name="finance" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Range') </label>
                            <input type="text" class="form-control" placeholder="@lang('Tesla X')" name="range" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('mph') </label>
                            <input type="text" class="form-control" placeholder="@lang('100mph')" name="mph" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Top Speed') </label>
                            <input type="text" class="form-control" placeholder="@lang('130 mph')" name="topspeed" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Image') </label>
                            <input type="file" class="form-control" placeholder="@lang('130 mph')" name="image" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Description') </label>
                            <textarea type="text" class="form-control" placeholder="@lang('Enter inventory Details')" name="details" required></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45"><i class="fa fa-send"></i> @lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <button type="button" data-bs-target="#carModal" data-bs-toggle="modal" class="btn btn-sm btn-outline--primary"><i class="las la-plus"></i>@lang('Add New')
    </button>
@endpush
@push('script')
    <script>
        (function($) {
            "use strict";

            $('.editBtn').on('click', function() {
                var modal = $('#editModal');
                var data  = $(this).data(); // This gets all data- attributes at once

                // Set the form action URL
                modal.find('form').attr('action', data.route);

                // Populate text and number inputs
                modal.find('input[name=name]').val(data.name);
                modal.find('input[name=color]').val(data.color);
                modal.find('input[name=year]').val(data.year);
                modal.find('input[name=purchase]').val(data.purchase);
                modal.find('input[name=lease]').val(data.lease);
                modal.find('input[name=finance]').val(data.finance);
                modal.find('input[name=range]').val(data.range);
                modal.find('input[name=mph]').val(data.mph);
                modal.find('input[name=topspeed]').val(data.topspeed);

                // Populate textarea
                modal.find('textarea[name=details]').val(data.details);

                // Note: We don't populate the 'image' input because 
                // browser security prevents setting values on file inputs.
            });
        })(jQuery);
    </script>
@endpush