@extends('admin.layouts.app')
@section('panel') 
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('User')</th>
                                    <th>@lang('Car')</th>
                                    <th>@lang('Year')</th>
                                    <th>@lang('Amount')</th> 
                                    <th>@lang('Payment Method')</th> 
                                    <th>@lang('TRX Hash')</th> 
                                    <th>@lang('Status')</th> 
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($orders as $order)
                                    <tr>
                                        <td>{{ @$order->user->fullname }}</td>
                                        <td>{{ @$order->car->name }}</td>
                                        <td>{{ @$order->car->year }}</td>
                                        <td>{{ showAmount($order->amount) }}</td> 
                                        <td>{{ @$order->method }}</td>
                                        <td>{{ @$order->trx_hash }}</td>
                                        <td>
                                            @if ($order->status == 1)
                                                <span class="badge badge--success">@lang('Successful')</span>
                                            @else
                                                <span class="badge badge--warning">@lang('Pending')</span>
                                            @endif
                                        </td> 
                                        <td>                                     
                                            @if ($order->status)
                                                <button class="btn btn-sm btn-outline--danger confirmationBtn" data-question="@lang('Are you sure to reject this order?')" data-action="{{ route('admin.inventory.order.status', $order->id) }}"><i class="las la-eye-slash"></i>@lang('Reject')</button>
                                            @else
                                                <button class="btn btn-sm btn-outline--success confirmationBtn" data-question="@lang('Are you sure to approve this order?')" data-action="{{ route('admin.inventory.order.status', $order->id) }}"><i class="las la-eye"></i>@lang('Approve')</button>
                                            @endif 
                                        </td>

                                        <td>

                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
 

    <x-confirmation-modal />
@endsection

@push('script')
     
@endpush