<div style="display: flex; flex-wrap: wrap; margin-right: -0.75rem; margin-left: -0.75rem; gap: 1.5rem 0;">
    @foreach($formData as $data)
        <div style="flex: 0 0 auto; width: 100%; @media (min-width: 768px) { width: {{ ($data->width / 12) * 100 }}%; }; padding-right: 0.75rem; padding-left: 0.75rem;">
            <div style="margin-bottom: 1.25rem;">
                
                <label style="display: block; font-size: 11px; font-weight: 800; color: #64748b; text-transform: uppercase; letter-spacing: 0.1em; margin-bottom: 0.5rem; display: flex; align-items: center; gap: 0.5rem;">
                    {{ __($data->name) }} 
                    @if(@$data->instruction) 
                        <span data-bs-toggle="tooltip" data-bs-title="{{ __($data->instruction) }}" style="cursor: help; color: #94a3b8;">
                            <i class="fas fa-info-circle" style="font-size: 10px;"></i>
                        </span> 
                    @endif 
                    @if($data->is_required == 'required' && ($data->type == 'checkbox' || $data->type == 'radio')) 
                        <span style="color: #ef4444;">*</span> 
                    @endif 
                </label>

                @php
                    $commonStyle = "width: 100%; padding: 0.75rem 1rem; background-color: #ffffff; border: 1px solid #e5e7eb; border-radius: 0.75rem; font-size: 14px; color: #111827; transition: all 0.2s ease; outline: none;";
                    $focusStyle = "onfocus=\"this.style.borderColor='#000000'; this.style.boxShadow='0 0 0 4px rgba(0,0,0,0.05)'\" onblur=\"this.style.borderColor='#e5e7eb'; this.style.boxShadow='none'\"";
                @endphp

                @if(in_array($data->type, ['text', 'url', 'email', 'datetime', 'date', 'time', 'number']))
                    <input type="{{ $data->type == 'datetime' ? 'datetime-local' : $data->type }}"
                        style="{{ $commonStyle }}"
                        {!! $focusStyle !!}
                        name="{{ $data->label }}"
                        value="{{ old($data->label) }}"
                        @if($data->is_required == 'required') required @endif
                        @if($data->type == 'number') step="any" @endif
                    >

                @elseif($data->type == 'textarea')
                    <textarea
                        style="{{ $commonStyle }} min-height: 120px; resize: vertical;"
                        {!! $focusStyle !!}
                        name="{{ $data->label }}"
                        @if($data->is_required == 'required') required @endif
                    >{{ old($data->label) }}</textarea>

                @elseif($data->type == 'select')
                    <select
                        class="select2"
                        style="{{ $commonStyle }} appearance: none; background-image: url('data:image/svg+xml;charset=utf-8,%3Csvg xmlns=%27http://www.w3.org/2000/svg%27 fill=%27none%27 viewBox=%270 0 20 20%27%3E%3Cpath stroke=%27%236b7280%27 stroke-linecap=%27round%27 stroke-linejoin=%27round%27 stroke-width=%271.5%27 d=%27m6 8 4 4 4-4%27/%3E%3C/svg%3E'); background-repeat: no-repeat; background-position: right 0.75rem center; background-size: 1.25rem;"
                        name="{{ $data->label }}"
                        data-minimum-results-for-search="-1"
                        @if($data->is_required == 'required') required @endif
                    >
                        <option value="">@lang('Select One')</option>
                        @foreach ($data->options as $item)
                            <option value="{{ $item }}" @selected($item == old($data->label))>{{ __($item) }}</option>
                        @endforeach
                    </select>

                @elseif($data->type == 'checkbox' || $data->type == 'radio')
                    <div style="display: flex; gap: 1rem; flex-wrap: wrap; padding: 0.25rem 0;">
                        @foreach($data->options as $option)
                            <div style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                                <input
                                    style="width: 1.15rem; height: 1.15rem; cursor: pointer; accent-color: #000000;"
                                    name="{{ $data->label }}{{ $data->type == 'checkbox' ? '[]' : '' }}"
                                    type="{{ $data->type }}"
                                    value="{{ $option }}"
                                    id="{{ $data->label }}_{{ titleToKey($option) }}"
                                    @checked($data->type == 'radio' ? $option == old($data->label) : false)
                                >
                                <label for="{{ $data->label }}_{{ titleToKey($option) }}" style="font-size: 13px; color: #4b5563; cursor: pointer; font-weight: 500;">{{ $option }}</label>
                            </div>
                        @endforeach
                    </div>
                    @if($data->type == 'checkbox')
                        <div class="checkbox-required-error" style="font-size: 11px; color: #ef4444; margin-top: 0.25rem;"></div>
                    @endif

                @elseif($data->type == 'file')
                    <div style="position: relative;">
                        <input
                            type="file"
                            style="{{ $commonStyle }} padding: 0.6rem; font-size: 12px;"
                            {!! $focusStyle !!}
                            name="{{ $data->label }}"
                            @if($data->is_required == 'required') required @endif
                            accept="@foreach(explode(',',$data->extensions) as $ext) .{{ $ext }}, @endforeach"
                        >
                        <div style="margin-top: 0.5rem; font-size: 10px; color: #94a3b8; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em;">
                            @lang('Accepted'): <span style="color: #64748b;">{{ $data->extensions }}</span>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    @endforeach
</div>

@push('script')
    <script>
        (function($){
            "use strict";
            const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
            const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))
        })(jQuery);
    </script>
@endpush