@extends('Template::layouts.frontend')
@section('content')
    <div class="bg-white">
        <header class="relative overflow-hidden bg-gradient-to-br from-black via-gray-900 to-black text-white">
            <svg class="absolute inset-0 opacity-[0.06] z-0 pointer-events-none" xmlns="http://www.w3.org/2000/svg"
                preserveAspectRatio="none" aria-hidden="true" focusable="false">
                <defs>
                    <pattern id="grid" width="40" height="40" patternUnits="userSpaceOnUse">
                        <path d="M 40 0 L 0 0 0 40" fill="none" stroke="white" stroke-width="1" />
                    </pattern>
                </defs>
                <rect width="100%" height="100%" fill="url(#grid)" />
            </svg>

            <div class="absolute inset-0 z-0 pointer-events-none" aria-hidden="true">
                <img src="{{ asset('assets/frontend/images/tesla-hero.jpg')}}" alt="" class="h-full w-full object-cover opacity-20"
                    loading="eager" decoding="async" />
                <div class="absolute inset-0 bg-gradient-to-b from-black/80 via-black/70 to-black/90"></div>
            </div>

            <div class="relative z-10">
                <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8 py-16 lg:py-24">
                    <div class="grid grid-cols-1 items-center gap-10 lg:grid-cols-2 lg:gap-16">
                        <div>
                            <h1 class="text-4xl font-semibold tracking-tight sm:text-5xl">
                                Invest. Trade. Drive.
                            </h1>
                            <p class="mt-4 max-w-xl text-base text-gray-300 sm:text-lg">
                                All-in-one platform for crypto wallet funding, automated investments, live stocks, and
                                premium EV inventory.
                            </p>

                            <div class="mt-8 flex flex-col gap-3 sm:flex-row">
                                <a href="{{route('user.login')}}"
                                    class="inline-flex items-center rounded-md bg-white px-5 py-3 text-sm font-medium text-black shadow-sm transition hover:bg-gray-100 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60 focus-visible:ring-offset-2 focus-visible:ring-offset-black">
                                    <i data-lucide="trending-up" class="mr-2 h-4 w-4" aria-hidden="true"></i>
                                    Start Investing
                                </a>
                                <a href="{{route('user.login')}}"
                                    class="inline-flex items-center rounded-md border border-white/20 px-5 py-3 text-sm font-medium text-white transition hover:bg-white/10 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60 focus-visible:ring-offset-2 focus-visible:ring-offset-black">
                                    <i data-lucide="bar-chart-3" class="mr-2 h-4 w-4" aria-hidden="true"></i>
                                    Explore Stocks
                                </a>
                                <a href="cars.html"
                                    class="inline-flex items-center rounded-md border border-white/20 px-5 py-3 text-sm font-medium text-white transition hover:bg-white/10 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60 focus-visible:ring-offset-2 focus-visible:ring-offset-black">
                                    <i data-lucide="car" class="mr-2 h-4 w-4" aria-hidden="true"></i>
                                    View Inventory
                                </a>
                            </div>

                            <div class="mt-8 grid grid-cols-1 gap-3 sm:grid-cols-3">
                                <div class="rounded-lg border border-white/10 bg-white/5 p-4">
                                    <p class="text-xs text-gray-300">Live Stocks</p>
                                    <p class="mt-1 text-lg font-semibold text-white">Realtime</p>
                                </div>
                                <div class="rounded-lg border border-white/10 bg-white/5 p-4">
                                    <p class="text-xs text-gray-300">Wallet</p>
                                    <p class="mt-1 text-lg font-semibold text-white">Crypto</p>
                                </div>
                                <div class="rounded-lg border border-white/10 bg-white/5 p-4">
                                    <p class="text-xs text-gray-300">EV Inventory</p>
                                    <p class="mt-1 text-lg font-semibold text-white">Premium</p>
                                </div>
                            </div>
                        </div>

                        <div class="grid grid-cols-2 gap-4">
                            <article
                                class="rounded-2xl border border-white/10 from-white/10 to-white/0 bg-gradient-to-br p-4 shadow backdrop-blur-sm">
                                <h3 class="text-xs text-gray-300">Investments</h3>
                                <p class="mt-2 text-2xl font-semibold text-white">Automated</p>
                                <p class="mt-1 text-sm text-gray-300">Flexible plans, recurring contributions.</p>
                            </article>
                            <article
                                class="rounded-2xl border border-white/10 from-white/10 to-white/0 bg-gradient-to-br p-4 shadow backdrop-blur-sm">
                                <h3 class="text-xs text-gray-300">Stocks</h3>
                                <p class="mt-2 text-2xl font-semibold text-white">Realtime</p>
                                <p class="mt-1 text-sm text-gray-300">Quotes, news, and watchlists.</p>
                            </article>
                            <article
                                class="rounded-2xl border border-white/10 from-white/10 to-white/0 bg-gradient-to-br p-4 shadow backdrop-blur-sm">
                                <h3 class="text-xs text-gray-300">Wallet</h3>
                                <p class="mt-2 text-2xl font-semibold text-white">Crypto</p>
                                <p class="mt-1 text-sm text-gray-300">Deposit and withdraw easily.</p>
                            </article>
                            <article
                                class="rounded-2xl border border-white/10 from-white/10 to-white/0 bg-gradient-to-br p-4 shadow backdrop-blur-sm">
                                <h3 class="text-xs text-gray-300">Marketplace</h3>
                                <p class="mt-2 text-2xl font-semibold text-white">Tesla</p>
                                <p class="mt-1 text-sm text-gray-300">Curated EV selection.</p>
                            </article>
                        </div>
                    </div>
                </div>
            </div>

            <div class="absolute bottom-0 left-0 right-0 translate-y-[1px]" aria-hidden="true">
                <svg viewBox="0 0 1440 80" xmlns="http://www.w3.org/2000/svg">
                    <path fill="#0b0b0b" fill-opacity="1"
                        d="M0,64L48,69.3C96,75,192,85,288,85.3C384,85,480,75,576,53.3C672,32,768,0,864,0C960,0,1056,32,1152,53.3C1248,75,1344,85,1392,90.7L1440,96L1440,160L1392,160C1344,160,1248,160,1152,160C1050,160,960,160,864,160C768,160,672,160,576,160C480,160,384,160,288,160C192,160,96,160,48,160L0,160Z">
                    </path>
                </svg>
            </div>
        </header>

        <section class="bg-[#0b0b0b] text-white" aria-labelledby="quick-actions-heading">
            <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8 py-12">
                <h2 id="quick-actions-heading" class="sr-only">Quick actions</h2>
                <nav class="grid grid-cols-1 gap-4 md:grid-cols-2 lg:grid-cols-4" aria-label="Quick actions">
                    <a href="{{route('user.login')}}"
                        class="group rounded-xl border border-white/10 p-5 text-white shadow-sm transition hover:bg-white/5 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60 focus-visible:ring-offset-2 focus-visible:ring-offset-[#0b0b0b]">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-xs text-gray-300">Wallet</p>
                                <p class="mt-1 text-sm font-medium">Fund or withdraw</p>
                            </div>
                            <span
                                class="inline-flex h-8 w-8 items-center justify-center rounded-full bg-white/10 text-white transition group-hover:bg-white group-hover:text-black">
                                <i data-lucide="wallet" class="h-4 w-4" aria-hidden="true"></i>
                            </span>
                        </div>
                    </a>

                    <a href="{{route('user.login')}}"
                        class="group rounded-xl border border-white/10 p-5 text-white shadow-sm transition hover:bg-white/5 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60 focus-visible:ring-offset-2 focus-visible:ring-offset-[#0b0b0b]">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-xs text-gray-300">Investments</p>
                                <p class="mt-1 text-sm font-medium">Create a plan</p>
                            </div>
                            <span
                                class="inline-flex h-8 w-8 items-center justify-center rounded-full bg-white/10 text-white transition group-hover:bg-white group-hover:text-black">
                                <i data-lucide="trending-up" class="h-4 w-4" aria-hidden="true"></i>
                            </span>
                        </div>
                    </a>

                    <a href="{{route('user.login')}}"
                        class="group rounded-xl border border-white/10 p-5 text-white shadow-sm transition hover:bg-white/5 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60 focus-visible:ring-offset-2 focus-visible:ring-offset-[#0b0b0b]">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-xs text-gray-300">Stocks</p>
                                <p class="mt-1 text-sm font-medium">Market overview</p>
                            </div>
                            <span
                                class="inline-flex h-8 w-8 items-center justify-center rounded-full bg-white/10 text-white transition group-hover:bg-white group-hover:text-black">
                                <i data-lucide="bar-chart-3" class="h-4 w-4" aria-hidden="true"></i>
                            </span>
                        </div>
                    </a>

                    <a href="{{route('user.login')}}"
                        class="group rounded-xl border border-white/10 p-5 text-white shadow-sm transition hover:bg-white/5 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60 focus-visible:ring-offset-2 focus-visible:ring-offset-[#0b0b0b]">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-xs text-gray-300">Portfolio</p>
                                <p class="mt-1 text-sm font-medium">Track performance</p>
                            </div>
                            <span
                                class="inline-flex h-8 w-8 items-center justify-center rounded-full bg-white/10 text-white transition group-hover:bg-white group-hover:text-black">
                                <i data-lucide="pie-chart" class="h-4 w-4" aria-hidden="true"></i>
                            </span>
                        </div>
                    </a>
                </nav>
            </div>
        </section>

        <section id="featured-cars" class="bg-white py-16" aria-labelledby="inventory-heading">
            <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
                <div class="mb-8 flex items-center justify-between">
                    <div>
                        <h2 id="inventory-heading" class="text-xl font-semibold text-black sm:text-2xl">Available
                            Inventory</h2>
                        <p class="mt-1 text-sm text-gray-600">Explore a curated selection ready for delivery.</p>
                    </div>
                    <a href="cars.html" class="text-sm font-medium text-black underline-offset-4 hover:underline">View
                        all</a>
                </div>

                <div class="grid grid-cols-1 gap-6 lg:grid-cols-2 xl:grid-cols-3 lg:gap-8">
                    <article
                        class="group cursor-pointer rounded-xl border border-gray-200 bg-white shadow-sm transition hover:shadow-md focus-within:ring-2 focus-within:ring-black/40">
                        <a href="cars/14.html" class="block overflow-hidden rounded-t-xl">
                            <div class="relative aspect-[16/9]">
                                <img src="storage/cars/s0zol5xRnGN8d8QSYOzfsr4yTtV8lEHuTtgRvBJo.jpg" alt="Tesla Model 3"
                                    class="h-full w-full object-cover transition-transform duration-500 group-hover:scale-105"
                                    loading="lazy" decoding="async"
                                    sizes="(min-width: 1280px) 384px, (min-width: 1024px) 50vw, 100vw" />

                            </div>
                        </a>

                        <div class="p-4">
                            <h3 class="mb-1 text-base font-medium text-black group-hover:text-black/80 sm:text-lg">
                                <a href="cars/14.html"
                                    class="focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-black/40">
                                    Tesla Model 3
                                </a>
                            </h3>

                            <div class="mb-3 flex items-center gap-6 text-xs text-gray-600">
                                <div>
                                    <span class="font-medium">410mi</span>
                                    <span class="block text-[10px]">Range</span>
                                </div>
                                <div>
                                    <span class="font-medium">3.1s</span>
                                    <span class="block text-[10px]">0-60 mph</span>
                                </div>
                                <div>
                                    <span class="font-medium">130mph</span>
                                    <span class="block text-[10px]">Top Speed</span>
                                </div>
                            </div>

                            <div class="flex items-center justify-between">
                                <div>
                                    <p class="text-sm font-medium text-black">Starting at $46,990.00*</p>
                                    <p class="text-xs text-gray-500">After Est. Gas Savings</p>
                                </div>
                                <div class="flex items-center gap-2">
                                    <a href="cars/14.html"
                                        class="rounded border border-gray-300 px-3 py-1.5 text-xs font-medium text-black transition hover:bg-gray-50 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-black/40">Learn</a>
                                    <a href="cars/14.html"
                                        class="rounded bg-black px-3 py-1.5 text-xs font-medium text-white transition hover:bg-gray-800 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-black/40">Order</a>
                                </div>
                            </div>
                        </div>
                    </article>
                    <article
                        class="group cursor-pointer rounded-xl border border-gray-200 bg-white shadow-sm transition hover:shadow-md focus-within:ring-2 focus-within:ring-black/40">
                        <a href="cars/9.html" class="block overflow-hidden rounded-t-xl">
                            <div class="relative aspect-[16/9]">
                                <img src="{{ asset('assets/frontend/storage/cars/EUQThikjzOXRp484fkQmQxLyQkHLce7PEZiMTEO9.jpg')}}" alt="Tesla Model X"
                                    class="h-full w-full object-cover transition-transform duration-500 group-hover:scale-105"
                                    loading="lazy" decoding="async"
                                    sizes="(min-width: 1280px) 384px, (min-width: 1024px) 50vw, 100vw" />

                            </div>
                        </a>

                        <div class="p-4">
                            <h3 class="mb-1 text-base font-medium text-black group-hover:text-black/80 sm:text-lg">
                                <a href="cars/9.html"
                                    class="focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-black/40">
                                    Tesla Model X
                                </a>
                            </h3>

                            <div class="mb-3 flex items-center gap-6 text-xs text-gray-600">
                                <div>
                                    <span class="font-medium">410mi</span>
                                    <span class="block text-[10px]">Range</span>
                                </div>
                                <div>
                                    <span class="font-medium">3.1s</span>
                                    <span class="block text-[10px]">0-60 mph</span>
                                </div>
                                <div>
                                    <span class="font-medium">130mph</span>
                                    <span class="block text-[10px]">Top Speed</span>
                                </div>
                            </div>

                            <div class="flex items-center justify-between">
                                <div>
                                    <p class="text-sm font-medium text-black">Starting at $36,000.00*</p>
                                    <p class="text-xs text-gray-500">After Est. Gas Savings</p>
                                </div>
                                <div class="flex items-center gap-2">
                                    <a href="cars/9.html"
                                        class="rounded border border-gray-300 px-3 py-1.5 text-xs font-medium text-black transition hover:bg-gray-50 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-black/40">Learn</a>
                                    <a href="cars/9.html"
                                        class="rounded bg-black px-3 py-1.5 text-xs font-medium text-white transition hover:bg-gray-800 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-black/40">Order</a>
                                </div>
                            </div>
                        </div>
                    </article>
                    <article
                        class="group cursor-pointer rounded-xl border border-gray-200 bg-white shadow-sm transition hover:shadow-md focus-within:ring-2 focus-within:ring-black/40">
                        <a href="cars/2.html" class="block overflow-hidden rounded-t-xl">
                            <div class="relative aspect-[16/9]">
                                <img src="https://images.unsplash.com/photo-1560958089-b8a1929cea89?w=800&h=600&fit=crop"
                                    alt="Tesla Model 3 Long Range"
                                    class="h-full w-full object-cover transition-transform duration-500 group-hover:scale-105"
                                    loading="lazy" decoding="async"
                                    sizes="(min-width: 1280px) 384px, (min-width: 1024px) 50vw, 100vw" />

                            </div>
                        </a>

                        <div class="p-4">
                            <h3 class="mb-1 text-base font-medium text-black group-hover:text-black/80 sm:text-lg">
                                <a href="cars/2.html"
                                    class="focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-black/40">
                                    Tesla Model 3 Long Range
                                </a>
                            </h3>

                            <div class="mb-3 flex items-center gap-6 text-xs text-gray-600">
                                <div>
                                    <span class="font-medium">410mi</span>
                                    <span class="block text-[10px]">Range</span>
                                </div>
                                <div>
                                    <span class="font-medium">3.1s</span>
                                    <span class="block text-[10px]">0-60 mph</span>
                                </div>
                                <div>
                                    <span class="font-medium">130mph</span>
                                    <span class="block text-[10px]">Top Speed</span>
                                </div>
                            </div>

                            <div class="flex items-center justify-between">
                                <div>
                                    <p class="text-sm font-medium text-black">Starting at $47,240.00*</p>
                                    <p class="text-xs text-gray-500">After Est. Gas Savings</p>
                                </div>
                                <div class="flex items-center gap-2">
                                    <a href="cars/2.html"
                                        class="rounded border border-gray-300 px-3 py-1.5 text-xs font-medium text-black transition hover:bg-gray-50 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-black/40">Learn</a>
                                    <a href="cars/2.html"
                                        class="rounded bg-black px-3 py-1.5 text-xs font-medium text-white transition hover:bg-gray-800 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-black/40">Order</a>
                                </div>
                            </div>
                        </div>
                    </article>
                </div>
            </div>
        </section>


        <section class="bg-[#0b0b0b] py-16 text-white" aria-labelledby="markets-heading">
            <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
                <div class="mb-8 flex items-center justify-between">
                    <div>
                        <h2 id="markets-heading" class="text-xl font-semibold sm:text-2xl">Stock Markets</h2>
                        <p class="mt-1 text-sm text-gray-400">Featured picks, top gainers, losers, and most active.</p>
                    </div>
                    <a href="{{route('user.login')}}" class="text-sm font-medium text-white underline-offset-4 hover:underline">Open
                        markets</a>
                </div>

                <div class="grid grid-cols-1 gap-6 lg:grid-cols-3">
                    <div class="lg:col-span-1">
                        <div class="rounded-xl border border-white/10 from-white/5 to-white/0 bg-gradient-to-br p-4">
                            <div class="mb-3 flex items-center justify-between">
                                <h3 class="text-sm font-semibold">Featured</h3>
                                <a href="{{route('user.login')}}" class="text-xs text-gray-300 hover:text-white">See all</a>
                            </div>
                            <div class="space-y-3">
                                <a href="{{route('user.login')}}"
                                    class="flex items-center justify-between rounded-lg p-3 transition hover:bg-white/5 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                                    <div class="min-w-0 flex items-center gap-3">
                                        <img src="https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/AAPL.png"
                                            alt="AAPL logo" class="h-6 w-6 rounded bg-white" loading="lazy"
                                            decoding="async" />
                                        <div class="min-w-0">
                                            <p class="truncate text-sm font-medium">AAPL <span
                                                    class="font-normal text-gray-400">• Apple Inc.</span></p>
                                            <p class="text-xs text-gray-400">Technology</p>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <p class="text-sm font-semibold">$229.35</p>
                                        <p class="text-xs text-green-600">+2.91 (+1.27%)</p>
                                    </div>
                                </a>
                                <a href="{{route('user.login')}}"
                                    class="flex items-center justify-between rounded-lg p-3 transition hover:bg-white/5 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                                    <div class="min-w-0 flex items-center gap-3">
                                        <img src="https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/MSFT.png"
                                            alt="MSFT logo" class="h-6 w-6 rounded bg-white" loading="lazy"
                                            decoding="async" />
                                        <div class="min-w-0">
                                            <p class="truncate text-sm font-medium">MSFT <span
                                                    class="font-normal text-gray-400">• Microsoft Corporation</span></p>
                                            <p class="text-xs text-gray-400">Technology</p>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <p class="text-sm font-semibold">$522.04</p>
                                        <p class="text-xs text-red-600">-10.91 (-2.09%)</p>
                                    </div>
                                </a>
                                <a href="{{route('user.login')}}"
                                    class="flex items-center justify-between rounded-lg p-3 transition hover:bg-white/5 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                                    <div class="min-w-0 flex items-center gap-3">
                                        <img src="https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/GOOGL.png"
                                            alt="GOOGL logo" class="h-6 w-6 rounded bg-white" loading="lazy"
                                            decoding="async" />
                                        <div class="min-w-0">
                                            <p class="truncate text-sm font-medium">GOOGL <span
                                                    class="font-normal text-gray-400">• Alphabet Inc.</span></p>
                                            <p class="text-xs text-gray-400">Technology</p>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <p class="text-sm font-semibold">$201.42</p>
                                        <p class="text-xs text-red-600">-3.54 (-1.76%)</p>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="lg:col-span-2 grid grid-cols-1 gap-6 md:grid-cols-3">
                        <div class="rounded-xl border border-white/10 from-white/5 to-white/0 bg-gradient-to-br p-4">
                            <h3 class="mb-3 text-sm font-semibold">Top Gainers</h3>
                            <div class="space-y-3">
                                <a href="{{route('user.login')}}"
                                    class="flex items-center justify-between rounded-lg p-3 transition hover:bg-white/10 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                                    <div class="min-w-0 flex items-center gap-3">
                                        <img src="https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/TMO.png"
                                            alt="TMO logo" class="h-5 w-5 rounded bg-white" loading="lazy"
                                            decoding="async" />
                                        <span class="truncate text-sm font-medium">TMO</span>
                                    </div>
                                    <span class="text-xs font-semibold text-green-400">+5.00%</span>
                                </a>
                                <a href="{{route('user.login')}}"
                                    class="flex items-center justify-between rounded-lg p-3 transition hover:bg-white/10 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                                    <div class="min-w-0 flex items-center gap-3">
                                        <img src="https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/NVDA.png"
                                            alt="NVDA logo" class="h-5 w-5 rounded bg-white" loading="lazy"
                                            decoding="async" />
                                        <span class="truncate text-sm font-medium">NVDA</span>
                                    </div>
                                    <span class="text-xs font-semibold text-green-400">+4.94%</span>
                                </a>
                                <a href="{{route('user.login')}}"
                                    class="flex items-center justify-between rounded-lg p-3 transition hover:bg-white/10 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                                    <div class="min-w-0 flex items-center gap-3">
                                        <img src="https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/PYPL.png"
                                            alt="PYPL logo" class="h-5 w-5 rounded bg-white" loading="lazy"
                                            decoding="async" />
                                        <span class="truncate text-sm font-medium">PYPL</span>
                                    </div>
                                    <span class="text-xs font-semibold text-green-400">+4.86%</span>
                                </a>
                                <a href="{{route('user.login')}}"
                                    class="flex items-center justify-between rounded-lg p-3 transition hover:bg-white/10 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                                    <div class="min-w-0 flex items-center gap-3">
                                        <img src="https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/CVS.png"
                                            alt="CVS logo" class="h-5 w-5 rounded bg-white" loading="lazy"
                                            decoding="async" />
                                        <span class="truncate text-sm font-medium">CVS</span>
                                    </div>
                                    <span class="text-xs font-semibold text-green-400">+4.83%</span>
                                </a>
                                <a href="{{route('user.login')}}"
                                    class="flex items-center justify-between rounded-lg p-3 transition hover:bg-white/10 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                                    <div class="min-w-0 flex items-center gap-3">
                                        <img src="https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/VZ.png"
                                            alt="VZ logo" class="h-5 w-5 rounded bg-white" loading="lazy"
                                            decoding="async" />
                                        <span class="truncate text-sm font-medium">VZ</span>
                                    </div>
                                    <span class="text-xs font-semibold text-green-400">+4.78%</span>
                                </a>
                            </div>
                        </div>

                        <div class="rounded-xl border border-white/10 from-white/5 to-white/0 bg-gradient-to-br p-4">
                            <h3 class="mb-3 text-sm font-semibold">Top Losers</h3>
                            <div class="space-y-3">
                                <a href="{{route('user.login')}}"
                                    class="flex items-center justify-between rounded-lg p-3 transition hover:bg-white/10 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                                    <div class="min-w-0 flex items-center gap-3">
                                        <img src="https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/HON.png"
                                            alt="HON logo" class="h-5 w-5 rounded bg-white" loading="lazy"
                                            decoding="async" />
                                        <span class="truncate text-sm font-medium">HON</span>
                                    </div>
                                    <span class="text-xs font-semibold text-red-400">-4.93%</span>
                                </a>
                                <a href="{{route('user.login')}}"
                                    class="flex items-center justify-between rounded-lg p-3 transition hover:bg-white/10 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                                    <div class="min-w-0 flex items-center gap-3">
                                        <img src="https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/NEE.png"
                                            alt="NEE logo" class="h-5 w-5 rounded bg-white" loading="lazy"
                                            decoding="async" />
                                        <span class="truncate text-sm font-medium">NEE</span>
                                    </div>
                                    <span class="text-xs font-semibold text-red-400">-4.91%</span>
                                </a>
                                <a href="{{route('user.login')}}"
                                    class="flex items-center justify-between rounded-lg p-3 transition hover:bg-white/10 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                                    <div class="min-w-0 flex items-center gap-3">
                                        <img src="https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/GS.png"
                                            alt="GS logo" class="h-5 w-5 rounded bg-white" loading="lazy"
                                            decoding="async" />
                                        <span class="truncate text-sm font-medium">GS</span>
                                    </div>
                                    <span class="text-xs font-semibold text-red-400">-4.90%</span>
                                </a>
                                <a href="{{route('user.login')}}"
                                    class="flex items-center justify-between rounded-lg p-3 transition hover:bg-white/10 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                                    <div class="min-w-0 flex items-center gap-3">
                                        <img src="https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/HD.png"
                                            alt="HD logo" class="h-5 w-5 rounded bg-white" loading="lazy"
                                            decoding="async" />
                                        <span class="truncate text-sm font-medium">HD</span>
                                    </div>
                                    <span class="text-xs font-semibold text-red-400">-4.88%</span>
                                </a>
                                <a href="{{route('user.login')}}"
                                    class="flex items-center justify-between rounded-lg p-3 transition hover:bg-white/10 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                                    <div class="min-w-0 flex items-center gap-3">
                                        <img src="https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/DIS.png"
                                            alt="DIS logo" class="h-5 w-5 rounded bg-white" loading="lazy"
                                            decoding="async" />
                                        <span class="truncate text-sm font-medium">DIS</span>
                                    </div>
                                    <span class="text-xs font-semibold text-red-400">-4.66%</span>
                                </a>
                            </div>
                        </div>

                        <div class="rounded-xl border border-white/10 from-white/5 to-white/0 bg-gradient-to-br p-4">
                            <h3 class="mb-3 text-sm font-semibold">Most Active</h3>
                            <div class="space-y-3">
                                <a href="{{route('user.login')}}"
                                    class="flex items-center justify-between rounded-lg p-3 transition hover:bg-white/10 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                                    <div class="min-w-0 flex items-center gap-3">
                                        <img src="https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/PYPL.png"
                                            alt="PYPL logo" class="h-5 w-5 rounded bg-white" loading="lazy"
                                            decoding="async" />
                                        <span class="truncate text-sm font-medium">PYPL</span>
                                    </div>
                                    <span class="text-xs text-gray-300">Vol 98.3M</span>
                                </a>
                                <a href="{{route('user.login')}}"
                                    class="flex items-center justify-between rounded-lg p-3 transition hover:bg-white/10 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                                    <div class="min-w-0 flex items-center gap-3">
                                        <img src="https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/FTNT.png"
                                            alt="FTNT logo" class="h-5 w-5 rounded bg-white" loading="lazy"
                                            decoding="async" />
                                        <span class="truncate text-sm font-medium">FTNT</span>
                                    </div>
                                    <span class="text-xs text-gray-300">Vol 97.2M</span>
                                </a>
                                <a href="{{route('user.login')}}"
                                    class="flex items-center justify-between rounded-lg p-3 transition hover:bg-white/10 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                                    <div class="min-w-0 flex items-center gap-3">
                                        <img src="https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/WFC.png"
                                            alt="WFC logo" class="h-5 w-5 rounded bg-white" loading="lazy"
                                            decoding="async" />
                                        <span class="truncate text-sm font-medium">WFC</span>
                                    </div>
                                    <span class="text-xs text-gray-300">Vol 95.3M</span>
                                </a>
                                <a href="{{route('user.login')}}"
                                    class="flex items-center justify-between rounded-lg p-3 transition hover:bg-white/10 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                                    <div class="min-w-0 flex items-center gap-3">
                                        <img src="https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/ABNB.png"
                                            alt="ABNB logo" class="h-5 w-5 rounded bg-white" loading="lazy"
                                            decoding="async" />
                                        <span class="truncate text-sm font-medium">ABNB</span>
                                    </div>
                                    <span class="text-xs text-gray-300">Vol 93.8M</span>
                                </a>
                                <a href="{{route('user.login')}}"
                                    class="flex items-center justify-between rounded-lg p-3 transition hover:bg-white/10 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60">
                                    <div class="min-w-0 flex items-center gap-3">
                                        <img src="https://static2.finnhub.io/file/publicdatany/finnhubimage/stock_logo/JPM.png"
                                            alt="JPM logo" class="h-5 w-5 rounded bg-white" loading="lazy"
                                            decoding="async" />
                                        <span class="truncate text-sm font-medium">JPM</span>
                                    </div>
                                    <span class="text-xs text-gray-300">Vol 93.7M</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="mt-12 bg-[#0B1220] py-16" aria-labelledby="news-heading">
            <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
                <div class="mb-8 flex items-center justify-between">
                    <div>
                        <h2 id="news-heading" class="text-xl font-semibold text-white sm:text-2xl">Market News</h2>
                        <p class="mt-1 text-sm text-gray-400">Latest headlines impacting your watchlist.</p>
                    </div>
                    <a href="{{route('user.login')}}" class="text-sm font-medium text-white underline-offset-4 hover:underline">View
                        stocks</a>
                </div>

                <div class="grid grid-cols-1 gap-6 md:grid-cols-2 lg:grid-cols-3">
                    <p class="text-sm text-gray-300">No news available yet.</p>
                </div>
            </div>
        </section>
        <section class="mt-12 bg-gradient-to-br from-black via-gray-900 to-black py-16 text-white"
            aria-labelledby="cta-heading">
            <div class="mx-auto max-w-7xl px-4 text-center sm:px-6 lg:px-8">
                <h2 id="cta-heading" class="text-2xl font-semibold">Ready to build your portfolio?</h2>
                <p class="mt-2 text-gray-300">Create an investment plan, follow stocks, and shop inventory in one place.
                </p>
                <div class="mt-6 flex flex-col justify-center gap-3 sm:flex-row">
                    <a href="{{route('user.register')}}"
                        class="rounded-md bg-white px-6 py-3 text-sm font-medium text-black transition hover:bg-gray-100 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60 focus-visible:ring-offset-2 focus-visible:ring-offset-black">Get
                        Started</a>
                    <a href="{{route('user.login')}}"
                        class="rounded-md border border-white/20 px-6 py-3 text-sm font-medium text-white transition hover:bg-white/10 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-white/60 focus-visible:ring-offset-2 focus-visible:ring-offset-black">Sign
                        In</a>
                </div>
            </div>
        </section>
    </div>
@endsection
