@php
    $preloader = getContent('preloader.content', true);
@endphp
<!doctype html>
<html lang="{{ config('app.locale') }}" itemscope itemtype="http://schema.org/WebPage">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> {{ gs()->siteName(__($pageTitle)) }}</title>
    @include('partials.seo')
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:300,400,500,600,700&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    <link rel="preload" as="style" href="{{ asset('assets/frontend/build/assets/app-Cf1VUFo0.css') }}" />
    <link rel="modulepreload" as="script" href="{{ asset('assets/frontend/build/assets/app-C7QjXGVt.js') }}" />
    <link rel="stylesheet" href="{{ asset('assets/frontend/build/assets/app-Cf1VUFo0.css') }}" />
    <script type="module" src="{{ asset('assets/frontend/build/assets/app-C7QjXGVt.js') }}"></script>

    @stack('style-lib')

    @stack('style')

</head>

@php echo loadExtension('google-analytics') @endphp

<body class="font-sans antialiased bg-gray-50 text-black">

    @stack('fbComment')
    <div class="min-h-screen flex flex-col">
        @yield('panel')
    </div>

    @stack('script-lib')
    @php echo loadExtension('tawk-chat') @endphp
    @include('partials.notify')

    @if (gs('pn'))
        @include('partials.push_script')
    @endif
    @stack('script')
</body>

</html>
