<!-- header-section start  -->
@php
    $pages = App\Models\Page::where('tempname', activeTemplate())->where('is_default', 0)->get();
@endphp
<!-- Enhanced Navigation -->
<nav class="bg-white border-b border-gray-100 shadow-sm">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center h-14">
            <!-- Logo -->
            <div class="flex items-center">
                <a href="{{url('/')}}" class="flex items-center group">
                    <img src="{{ siteLogo() }}"
                        alt="Tesla Investments Platform"
                        class="h-6 w-auto group-hover:opacity-70 transition-opacity duration-200">
                </a>
            </div>

            <!-- Right Side Links -->
            <div class="hidden md:flex items-center space-x-6">
                <a href="{{ url('/') }}"
                    class="text-xs font-medium text-black hover:text-gray-600 transition-colors duration-200">Home</a>
                <a href="{{ route('cars') }}"
                    class="text-xs font-medium text-black hover:text-gray-600 transition-colors duration-200">Inventory</a>
                @guest    
                <a href="{{route('user.login')}}"
                    class="text-xs font-medium text-black hover:text-gray-600 transition-colors duration-200">Sign
                    In</a>
                <a href="{{route('user.register')}}"
                    class="text-xs font-medium text-black hover:text-gray-600 transition-colors duration-200">Register</a>
                @else
                <a href="{{route('user.login')}}"
                    class="text-xs font-medium text-black hover:text-gray-600 transition-colors duration-200">Account</a>
                @endguest
            </div>
        </div>
    </div>
</nav>
