<div class="glass-vault border border-slate-200 dark:border-white/10 bg-white/50 dark:bg-slate-900/50 backdrop-blur-xl rounded-xl overflow-hidden shadow-sm">
        <div class="overflow-x-auto">
            <table class="w-full text-left border-collapse">
                    <thead>
                        <tr class="bg-slate-50 dark:bg-white/[0.02] border-b border-slate-100 dark:border-white/5">
                            <th class="px-8 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest">
                                @lang('Reference')</th>
                            <th class="px-6 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest">
                                @lang('Timestamp')</th>
                            <th
                                class="px-6 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest text-center">
                                @lang('Amount')</th>
                            <th
                                class="px-6 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest text-center">
                                @lang('Post Balance')</th>
                            <th
                                class="px-6 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest text-center">
                                @lang('Wallet Type')</th>
                            <th
                                class="px-8 py-6 text-[10px] font-black text-slate-400 uppercase tracking-widest text-right">
                                @lang('Description')</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-100 dark:divide-white/5">
                        @forelse($investroi as $trx)
                            <tr class="group hover:bg-slate-50/50 dark:hover:bg-white/[0.01] transition-all duration-300">
                                <td class="px-8 py-6">
                                    <span
                                        class="text-xs font-black text-slate-900 dark:text-white tracking-tighter uppercase">{{ $trx->trx }}</span>
                                </td>
                                <td class="px-6 py-6 text-nowrap">
                                    <p
                                        class="text-[11px] font-black text-slate-900 dark:text-white leading-none tracking-tight">
                                        {{ showDateTime($trx->created_at, 'd M, Y') }}</p>
                                    <p class="text-[9px] font-bold text-slate-400 uppercase tracking-widest mt-1">
                                        {{ diffForHumans($trx->created_at) }}</p>
                                </td>
                                <td class="px-6 py-6 text-center">
                                    <span
                                        class="text-xs font-black @if ($trx->trx_type == '+') text-emerald-500 @else text-rose-500 @endif">
                                        {{ $trx->trx_type }} {{ showAmount($trx->amount) }}
                                    </span>
                                </td>
                                <td class="px-6 py-6 text-center">
                                    <span
                                        class="text-xs font-black text-slate-900 dark:text-white tracking-tighter">{{ showAmount($trx->post_balance) }}</span>
                                </td>
                                <td class="px-6 py-6 text-center">
                                    @if ($trx->wallet_type == 'deposit_wallet')
                                        <span
                                            class="text-[9px] font-black px-3 py-1 bg-blue-500/10 text-blue-500 rounded-full border border-blue-500/20 uppercase tracking-widest">@lang('Deposit')</span>
                                    @else
                                        <span
                                            class="text-[9px] font-black px-3 py-1 bg-emerald-500/10 text-emerald-500 rounded-full border border-emerald-500/20 uppercase tracking-widest">@lang('Interest')</span>
                                    @endif
                                </td>
                                <td class="px-8 py-6 text-right">
                                    <span
                                        class="text-[10px] font-bold text-slate-500 dark:text-slate-400 italic">"{{ __($trx->details) }}"</span>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td class="px-8 py-24 text-center" colspan="100%">
                                    <div class="flex flex-col items-center opacity-30">
                                        <i data-lucide="database-zap" class="w-12 h-12 mb-4"></i>
                                        <p class="text-[10px] font-black uppercase tracking-[0.3em]">
                                            {{ __($emptyMessage) }}</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
        </div>
    </div>
    
    @if ($invests->hasPages())
        <div class="mt-8">
            {{ paginateLinks($invests) }}
        </div>
    @endif
     


<div id="capitalModal" class="hidden fixed inset-0 z-[9999] flex items-center justify-center p-4">
    <div class="absolute inset-0 bg-slate-900/60 backdrop-blur-sm opacity-0 transition-opacity duration-300" id="capitalBackdrop"></div>
    <div class="relative w-full max-w-md bg-white dark:bg-slate-900 rounded-xl border border-slate-200 dark:border-white/10 shadow-2xl overflow-hidden transform scale-95 opacity-0 transition-all duration-300" id="capitalContent">
        <div class="p-6 border-b border-slate-100 dark:border-white/5 flex justify-between items-center bg-slate-50/50 dark:bg-slate-800/30">
            <h2 class="text-[11px] font-black text-slate-900 dark:text-white uppercase tracking-widest">@lang('Capital Terminal')</h2>
            <button type="button" class="closeCapital text-slate-400 hover:text-slate-900 dark:hover:text-white transition-colors">
                <i data-lucide="x" class="w-5 h-5"></i>
            </button>
        </div>
        <form action="{{ route('user.invest.capital.manage') }}" method="post" class="m-0">
            @csrf
            <div class="p-8">
                <input type="hidden" name="invest_id">
                <div class="space-y-2">
                    <label class="text-[10px] font-black text-slate-400 uppercase ml-1">@lang('Withdrawal / Reinvest Strategy')</label>
                    <select name="capital" class="w-full bg-slate-50 dark:bg-slate-800 border border-slate-200 dark:border-white/5 rounded-lg p-3 text-sm font-bold focus:ring-2 focus:ring-emerald-500 transition-all outline-none text-slate-900 dark:text-white">
                        <option value="reinvest">@lang('Reinvest Principal')</option>
                        <option value="capital_back">@lang('Capital Back to Wallet')</option>
                    </select>
                </div>
            </div>
            <div class="p-6 bg-slate-50/50 dark:bg-slate-800/30 flex gap-3">
                <button type="button" class="closeCapital flex-1 py-3 text-[10px] font-black uppercase text-slate-500">@lang('Cancel')</button>
                <button type="submit" class="flex-[2] py-3 bg-slate-900 dark:bg-white text-white dark:text-slate-900 rounded-lg text-[10px] font-black uppercase tracking-widest shadow-lg hover:bg-emerald-600 dark:hover:bg-emerald-500 transition-colors">@lang('Process Strategy')</button>
            </div>
        </form>
    </div>
</div> 

@push('script')
<script src="https://unpkg.com/lucide@latest"></script>
<script>
    "use strict";

    // Global store for countdowns
    const countdowns = [];

    function createCountDown(elementId, sec) {
        let tms = sec;
        let x = setInterval(function() {
            let distance = tms * 1000;
            
            let days = Math.floor(distance / (1000 * 60 * 60 * 24));
            let hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            let minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            let seconds = Math.floor((distance % (1000 * 60)) / 1000);
            
            let element = document.getElementById(elementId);
            if(element) {
                element.innerHTML = days + "D " + hours + "H " + minutes + "M " + seconds + "S";
                
                if (distance < 0) {
                    clearInterval(x);
                    element.innerHTML = "SETTLING...";
                    element.classList.add('text-emerald-500');
                }
            } else {
                // If element is not found, stop the interval to save memory
                clearInterval(x);
            }
            tms--;
        }, 1000);
    }

    // Capture all active investments from Blade
    @foreach($invests as $invest)
        @if ($invest->status == 1 && \Carbon\Carbon::parse($invest->next_time) > now())
            countdowns.push({
                id: 'counter{{ $invest->id }}',
                seconds: {{ abs(\Carbon\Carbon::parse($invest->next_time)->diffInSeconds()) }}
            });
        @endif
    @endforeach

    $(document).ready(function() {
        lucide.createIcons();

        // Start all countdowns ONLY after document is ready
        countdowns.forEach(item => {
            createCountDown(item.id, item.seconds);
        });
    });
</script>
<script>
    "use strict";

     

    (function($) {
        // Init Lucide Icons
        lucide.createIcons();

        const modal = $('#capitalModal');
        const backdrop = $('#capitalBackdrop');
        const content = $('#capitalContent');

        // Modal Logic
        $('.manageCapital').on('click', function() {
            modal.find('[name=invest_id]').val($(this).data('id'));
            modal.removeClass('hidden').addClass('flex');
            setTimeout(() => {
                backdrop.removeClass('opacity-0').addClass('opacity-100');
                content.removeClass('opacity-0 scale-95').addClass('opacity-100 scale-100');
            }, 10);
        });

        function closeCapitalModal() {
            backdrop.removeClass('opacity-100').addClass('opacity-0');
            content.removeClass('opacity-100 scale-100').addClass('opacity-0 scale-95');
            setTimeout(() => modal.addClass('hidden').removeClass('flex'), 300);
        }

        $('.closeCapital, #capitalBackdrop').on('click', closeCapitalModal);

    })(jQuery);
</script>
@endpush