
        @php
            $plans = \App\Models\Plan::with('timeSetting')->whereHas('timeSetting')->get();
        @endphp
<!--==========================  Pricing Section Start  ==========================-->
            <section class="pricing-section bg--black-two py-120">
                <div class="container position-relative">
                    <div class="pricing-shape d-none d-lg-block">
                        <img src="{{ asset('assets/frontend/svg/analysis-1.svg')}}" alt="star">
                        <img src="{{ asset('assets/frontend/svg/analysis-2.svg')}}" alt="star">
                    </div>
                    <div class="row row-gap-3 ">
                        <div class="col-lg-6 align-self-end">
                            <div class="section-content">
                                <h6 class="right-reveal">Pricing Plan</h6>
                                <h2 class="mb-0 right-reveal">Our Pricing Plan</h2>
                            </div>
                        </div>
                        <div class="col-lg-6 align-self-end">
                            <div class="section-content">
                                <p class="right-reveal">Trade Mastery, we believe great traders aren't born they’re
                                    built through
                                    the right tools,
                                    education, and support. Our mission is simple: to empower every client with the
                                    resources they
                                    need to grow, succeed, and master.</p>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-60 row-gap-4 justify-content-center">
                        <div class="col-12 bottom-reveal">
                            <div class="pricing-slide swiper">
                                <div class="swiper-wrapper">
                                    @foreach ($plans as $plan)
                                    <div class="swiper-slide">
                                        <div class="pricing-content">
                                            <div class="pricing-header">
                                                <h6 class="mb-2">{{ __($plan->name) }}</h6>
                                                <h2 class="mb-2">{{ showAmount($plan->interest) }}{{ $plan->interest_type == 1 ? '%' : ' ' . $general->cur_text }}<sub class="fs-16 fw-normal">/{{ __($plan->timeSetting->name) }} </sub></h2>
                                                <p>Free Advertisement</p>
                                            </div>
                                            <div class="pricing-body">
                                                <ul>
                                                    <li>{{ $plan->lifetime == 0 ? $plan->repeat_time : 'Unlimited' }}</li>
                                                    <li>{{ $plan->featured ? 'Priority Protocol' : 'Standard' }}</li>
                                                     @if ($plan->fixed_amount > 0)
                                                    <li>{{ showAmount($plan->fixed_amount) }}</li>
                                                    @else
                                                    <li>{{ showAmount($plan->minimum) }} - {{ showAmount($plan->maximum) }}</li>
                                                    @endif
                                                    <li>Swap Free Option Available</li>
                                                    <li>Email Support Only</li>
                                                </ul>
                                            </div>
                                            <div class="pricing-footer">
                                                <a href="{{route('user.login')}}" class="btn btn--black-two">Choose Plan</a>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                     
                                </div>
                                <div class="swiper-pagination"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--==========================  Pricing Section End  ==========================-->
             