@php
  $teamCaption = getContent('team.content',true);
  $teamElements = getContent('team.element',false,null,true);
@endphp
 <!--==========================  Team Section Start  ==========================-->
    <section class="team-section bg--black py-120">
        <div class="container position-relative">
            <div class="services-two-shape d-none d-lg-block">
                <img src="{{ asset('assets/frontend/svg/bank.svg') }}" alt="balance">
                <img src="{{ asset('assets/frontend/svg/balance-5.svg') }}" alt="balance">
            </div>
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-8">
                    <div class="section-content text-center">
                        <h6 class="top-reveal">Our Team</h6>
                        <h2 class="top-reveal">{{ __(@$teamCaption->data_values->heading_w) }}</h2>
                        <p class="top-reveal"> {{ __(@$teamCaption->data_values->sub_heading) }}.</p>
                    </div>
                </div>
            </div>
            <div class="row mt-60 row-gap-4 justify-content-center">
                <div class="col-12">
                    <div class="team-slide swiper">
                        <div class="swiper-wrapper">
                             @foreach($teamElements as $teamElement)
                            <div class="swiper-slide">
                                <div class="team-item">
                                    <a href="{{route('user.login')}}" class="team-img">
                                        <img src="{{ frontendImage('team', @$teamElement->data_values->image,'280x296') }}" alt="team"
                                            class="img-fluid w-100">
                                    </a>
                                    <div class="team-content">
                                        <h4 class="mb-1"><a href="{{route('user.login')}}">{{ __(@$teamElement->data_values->name) }}</a></h4>
                                        <p>{{ __(@$teamElement->data_values->designation) }}</p>
                                        <ul class="social-icon">
                                            <li><a href="https://www.facebook.com/" target="_blank"><i
                                                        class="fa-brands fa-facebook-f"></i></a></li>
                                            <li><a href="https://www.instagram.com/" target="_blank"><i
                                                        class="fa-brands fa-instagram"></i></a></li>
                                            <li><a href="https://www.linkedin.com/" target="_blank"><i
                                                        class="fa-brands fa-linkedin-in"></i></a></li>
                                            <li><a href="https://www.twitter.com/" target="_blank"><i
                                                        class="fa-brands fa-x-twitter"></i></a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                             @endforeach
                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
            </div>
            <div class="row mt-60">
                <div class="col-lg-12">
                    <div class="text-center">
                        <a href="{{route('user.login')}}" class="btn btn--base-two bottom-reveal">
                            See More <i class="flaticon-arrow-upper-right"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--==========================  Team Section End  ==========================-->
     