@extends('Template::layouts.auth')
@section('content')
    <div class="w-full max-w-sm">
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <!-- Enhanced Header -->
            <div class="px-6 py-6 text-center">
                <h1 class="text-xl font-light text-black mb-1">Verify your phone</h1>
                <p class="text-xs text-gray-500">Enter the code sent to your phone</p>
            </div>

            <!-- Session Status -->

            <!-- Reset Form -->
            <div class="px-6 pb-6">
                <div class="mb-4 text-xs text-gray-500 text-center">
                    <p class="mt-3 text-sm text-slate-500 leading-relaxed">
                        We've sent a 6-digit verification code to <br>
                        <span class="font-semibold text-slate-900">{{ showMobileNumber(auth()->user()->mobileNumber) }}</span>
                    </p>
                </div>

                <form action="{{ route('user.verify.mobile') }}" method="POST" class="verify-gcaptcha space-y-4">
                    @csrf


                    <!-- Email Code -->
                    <div>
                        <label for="code" class="block text-xs font-medium text-black mb-1">Code</label>
                        <input type="number" id="code" name="code" type="text" value="{{ old('code') }}"
                            required autofocus
                            class="w-full px-3 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200 ">
                    </div>

                    <!-- Submit Button -->
                    <div class="pt-2">
                        <button type="submit"
                            class="w-full bg-black hover:bg-gray-800 text-white py-2.5 px-4 rounded-lg text-sm font-medium transition-all duration-200">
                            Verify Code
                        </button>
                    </div>
                </form>
            </div>

            <div class="mt-6">
                <div class="relative">
                    <div class="absolute inset-0 flex items-center">
                        <div class="w-full border-t border-gray-200"></div>
                    </div>
                    <div class="relative flex justify-center text-xs">
                        <span class="px-3 bg-gray-50 text-gray-500">Didnt get the code ?</span>
                    </div>
                    <span class="countdownWrapper">
                        Resend code in <span id="countdown" class="font-bold text-slate-900">--</span> seconds
                    </span>
                </div>

                <div class="mt-4 flex justify-center">
                    <a href="{{ route('user.send.verify.code', 'mobile') }}"
                        class="inline-flex items-center justify-center px-3 py-2 border border-gray-300 rounded-lg shadow-sm bg-white text-xs font-medium text-gray-700 hover:bg-gray-50 transition-colors duration-200">
                        Resend Code
                    </a>
                </div>
            </div>

            <!-- Back to Login Link -->
            <div class="px-6 py-4 bg-gray-50 border-t border-gray-100 text-center">
                <p class="text-xs text-gray-500">
                    Not ready
                    <a href="{{ route('user.logout') }}"
                        class="text-black hover:text-gray-600 font-medium transition-colors duration-200">
                        Logout
                    </a>
                </p>
            </div>
        </div>
    </div>
@endsection
@push('script')
   
<script>
    // Integration of your provided JS logic
    var distance = Number("{{ @$user->ver_code_send_at->addMinutes(2)->timestamp - time() }}");
    var x = setInterval(function() {
        if (distance <= 0) {
            clearInterval(x);
            document.querySelector('.countdownWrapper').classList.add('d-none');
        } else {
            document.getElementById("countdown").innerHTML = distance;
            distance--;
        }
    }, 1000);

    // UX: Auto-focus and numeric filter
    const input = document.getElementById('verification-code');
    input.focus();
    input.addEventListener('input', function() {
        this.value = this.value.replace(/[^0-9]/g, '');
    });
</script>
@endpush


                