@extends('Template::layouts.auth')
@section('content')
    <div class="w-full max-w-sm">
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <!-- Enhanced Header -->
            <div class="px-6 py-6 text-center">
                <h1 class="text-xl font-light text-black mb-1">Verify your email</h1>
                <p class="text-xs text-gray-500">Enter the code sent to your email</p>
            </div>

            <!-- Session Status -->

            <!-- Reset Form -->
            <div class="px-6 pb-6">
                <div class="mb-4 text-xs text-gray-500 text-center">
                    <p class="mt-3 text-sm text-slate-500 leading-relaxed">
                        We've sent a 6-digit verification code to <br>
                        <span class="font-semibold text-slate-900">{{ showEmailAddress($email) }}</span>
                    </p>
                </div>

                <form action="{{ route('user.password.verify.code') }}" method="POST" class="verify-gcaptcha space-y-4">
                    @csrf

                    <input type="hidden" name="email" value="{{ $email }}">

                    <!-- Email Code -->
                    <div>
                        <label for="code" class="block text-xs font-medium text-black mb-1">Code</label>
                        <input type="number" id="code" name="code" type="text" value="{{ old('code') }}"
                            required autofocus
                            class="w-full px-3 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200 ">
                    </div>

                    <!-- Submit Button -->
                    <div class="pt-2">
                        <button type="submit"
                            class="w-full bg-black hover:bg-gray-800 text-white py-2.5 px-4 rounded-lg text-sm font-medium transition-all duration-200">
                            Verify Code
                        </button>
                    </div>
                </form>
            </div>

            <!-- Back to Login Link -->
            <div class="px-6 py-4 bg-gray-50 border-t border-gray-100 text-center">
                <p class="text-xs text-gray-500">
                    Didnt get code
                    <a href="{{ route('user.password.request') }}"
                        class="text-black hover:text-gray-600 font-medium transition-colors duration-200">
                        Try again
                    </a>
                </p>
            </div>
        </div>
    </div>
@endsection
