@extends('Template::layouts.master')

@section('content')
    <div class="max-w-7xl mx-auto">
        <!-- Enhanced Header -->
        <div
            class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
                <div class="absolute bottom-0 left-0 w-24 h-24 bg-white rounded-full translate-y-12 -translate-x-12"></div>
            </div>

            <div class="relative z-10">
                <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                    <div class="mb-4 lg:mb-0 lg:flex-1">
                        <h1 class="text-xl font-light mb-1">Purchase History</h1>
                        <p class="text-gray-300 text-sm">Track all your vehicle purchases and transactions</p>
                    </div>

                    <!-- Stats Card -->
                    <div
                        class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-64">
                        <div class="flex items-center justify-between mb-3">
                            <div>
                                <p class="text-xs text-gray-300 mb-1">Total Purchases</p>
                                <p class="text-lg font-light">{{ $total }}</p>
                            </div>
                            <div class="w-10 h-10 flex items-center justify-center">
                                <i data-lucide="receipt" class="w-5 h-5 text-white"></i>
                            </div>
                        </div>
                        <div class="flex space-x-4 text-xs">
                            <div class="flex-1 text-center">
                                <p class="text-gray-300">Completed</p>
                                <p class="text-white font-medium">{{ $completed }}</p>
                            </div>
                            <div class="flex-1 text-center">
                                <p class="text-gray-300">Pending</p>
                                <p class="text-white font-medium">{{ $pending }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Purchase History Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-100">
            <div class="p-6 border-b border-gray-100">
                <h2 class="text-lg font-semibold text-gray-900">All Purchases</h2>
                <p class="text-sm text-gray-600 mt-1">Complete history of your vehicle purchases</p>
            </div>

            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Purchase</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Vehicle</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Amount</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach ($orders as $order)
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center">
                                        <div
                                            class="w-10 h-10 bg-gradient-to-br from-blue-400 to-blue-600 rounded-lg flex items-center justify-center mr-3">
                                            <i data-lucide="car" class="w-5 h-5 text-white"></i>
                                        </div>
                                        <div>
                                            <div class="text-sm font-medium text-gray-900">#{{ $order->id }}</div>
                                            <div class="text-sm text-gray-500">{{ $order->nethod }}</div>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center">
                                        <div class="w-10 h-10 bg-gray-200 rounded-lg flex items-center justify-center mr-3">
                                            <i data-lucide="car" class="w-4 h-4 text-gray-500"></i>
                                        </div>
                                        <div>
                                            <div class="text-sm font-medium text-gray-900"></div>
                                            <div class="text-sm text-gray-500">{{ @$order->car->year }} •
                                                {{ @$order->car->color }}</div>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900">{{ showAmount($order->amount) }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">

                                    @if ($order->status == 1)
                                        <span
                                            class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                                   
                                                   bg-green-100 text-green-800">@lang('Successful')</span>
                                    @else
                                        <span
                                            class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                                   
                                                   bg-yellow-100 text-yellow-800">@lang('Pending')</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    {{ showDateTime($order->created_at, 'd M, Y') }}
                                    <div class="text-xs text-gray-500">{{ $order->created_at }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                    <div class="flex space-x-2">
                                        <button
                                            onclick="viewPurchaseDetails({&quot;id&quot;:{{ $order->id }},&quot;user_id&quot;:75,&quot;car_id&quot;:9,&quot;payment_method_id&quot;:5,&quot;amount&quot;:&quot;{{$order->amount}}&quot;,&quot;billing_name&quot;:&quot;{{$order->user->name}}&quot;,&quot;billing_email&quot;:&quot;{{@$order->user->email}}&quot;,&quot;billing_phone&quot;:&quot;(035) 326-23623632&quot;,&quot;billing_address&quot;:&quot;assagsagsa&quot;,&quot;billing_city&quot;:&quot;asgsagsag&quot;,&quot;billing_state&quot;:&quot;sagasgasg&quot;,&quot;billing_postal_code&quot;:&quot;32626236&quot;,&quot;billing_country&quot;:&quot;CA&quot;,&quot;company_name&quot;:null,&quot;tax_id&quot;:null,&quot;transaction_hash&quot;:null,&quot;crypto_amount&quot;:&quot;0.80000000&quot;,&quot;crypto_currency&quot;:&quot;BTC&quot;,&quot;exchange_rate&quot;:&quot;45000.00000000&quot;,&quot;status&quot;:&quot;pending&quot;,&quot;purchased_at&quot;:&quot;2026-02-22T10:00:32.000000Z&quot;,&quot;created_at&quot;:&quot;2026-02-22T10:00:32.000000Z&quot;,&quot;updated_at&quot;:&quot;2026-02-22T10:00:32.000000Z&quot;,&quot;car&quot;:{&quot;id&quot;:9,&quot;title&quot;:&quot;{{@$order->car->name}}&quot;,&quot;description&quot;:&quot;null.&quot;,&quot;make&quot;:&quot;{{@$order->car->name}}&quot;,&quot;model&quot;:&quot;Model X&quot;,&quot;year&quot;:{{@$order->car->year}},&quot;engine&quot;:&quot;Electric Motor&quot;,&quot;transmission&quot;:&quot;Automatic&quot;,&quot;color&quot;:&quot;{{@$order->car->color}}&quot;,&quot;price&quot;:&quot;{{@$order->amount}}&quot;,&quot;images&quot;:[&quot;cars\/EUQThikjzOXRp484fkQmQxLyQkHLce7PEZiMTEO9.jpg&quot;],&quot;is_available&quot;:false,&quot;created_at&quot;:&quot;2025-08-01T09:10:26.000000Z&quot;,&quot;updated_at&quot;:&quot;2026-02-22T10:00:32.000000Z&quot;},&quot;payment_method&quot;:{&quot;id&quot;:5,&quot;name&quot;:&quot;{{@$order->method}}&quot;,&quot;type&quot;:&quot;cryptocurrency&quot;,&quot;details&quot;:&quot;Pay with Bitcoin (BTC). Secure blockchain transactions with global acceptance.&quot;,&quot;logo&quot;:&quot;payment-methods\/logos\/ORlsQwv0PZBkspRvbK9uU5RRxhcyGuj2yC1MtOrQ.png&quot;,&quot;barcode&quot;:&quot;payment-methods\/qrcodes\/dR8fAQrwj25mFc7mrhoKyW20vKG8YdxMmgVbkXTF.jpg&quot;,&quot;wallet_address&quot;:&quot;bc1q4855qyg2nkpxxay8jj5pjkh09jxxwcnzl725nt&quot;,&quot;crypto_symbol&quot;:&quot;BTC&quot;,&quot;network_fee&quot;:&quot;0.00005000&quot;,&quot;is_active&quot;:true,&quot;allow_deposit&quot;:true,&quot;allow_withdraw&quot;:true,&quot;created_at&quot;:&quot;2025-06-16T10:19:48.000000Z&quot;,&quot;updated_at&quot;:&quot;2026-02-17T21:40:40.000000Z&quot;}})"
                                            class="w-8 h-8 flex items-center justify-center text-gray-600 hover:text-gray-800 hover:bg-gray-100 rounded-lg transition-colors duration-200"
                                            title="View Details">
                                            <i data-lucide="eye" class="w-4 h-4"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
        </div>
    </div>
    @push('script')
        <script>
            function viewPurchaseDetails(purchase) {
                const car = purchase.car || {};
                const method = purchase.payment_method || purchase.paymentMethod || {};
                const purchasedAt = purchase.purchased_at ? new Date(purchase.purchased_at) : null;
                const createdAt = purchase.created_at ? new Date(purchase.created_at) : null;

                const formatMoney = (v) =>
                    `$${Number(v || 0).toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 })}`;
                const formatDate = (d) => d ? d.toLocaleString(undefined, {
                    year: 'numeric',
                    month: 'short',
                    day: '2-digit',
                    hour: 'numeric',
                    minute: '2-digit'
                }) : '';

                const statusBadge = (status) => {
                    const map = {
                        completed: 'bg-green-100 text-green-800',
                        pending: 'bg-yellow-100 text-yellow-800',
                        cancelled: 'bg-red-100 text-red-800',
                        failed: 'bg-gray-100 text-gray-800',
                    };
                    return map[String(status || '').toLowerCase()] || 'bg-gray-100 text-gray-800';
                };

                const modal = document.createElement('div');
                modal.className = 'fixed inset-0 bg-black bg-opacity-40 overflow-y-auto h-full w-full z-[1000]';
                modal.innerHTML = `
                <div class="relative mx-auto my-10 w-full max-w-2xl">
                    <div class="rounded-2xl bg-white shadow-2xl border border-gray-200 overflow-hidden">
                        <div class="bg-gradient-to-br from-black via-gray-900 to-black text-white px-6 py-5">
                            <div class="flex items-start justify-between">
                                <div>
                                    <div class="text-xs uppercase tracking-wider text-white/70">Purchase</div>
                                    <div class="text-xl font-light">#${purchase.id}</div>
                                </div>
                            </div>
                        </div>
                        <div class="p-6">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <h4 class="text-sm font-medium text-black mb-2">Details</h4>
                                    <div class="space-y-2 text-sm">
                                        <div class="flex justify-between"><span class="text-gray-600">Amount</span><span class="font-medium">${formatMoney(purchase.amount)}</span></div>
                                        <div class="flex justify-between"><span class="text-gray-600">Payment Method</span><span class="font-medium">${method.name || 'N/A'}</span></div>
                                        <div class="flex justify-between"><span class="text-gray-600">Date</span><span class="font-medium">${formatDate(purchasedAt || createdAt)}</span></div>
                                    </div>
                                </div>
                                <div>
                                    <h4 class="text-sm font-medium text-black mb-2">Vehicle</h4>
                                    <div class="flex items-center">
                                        ${car.image_url ? `<img src="${car.image_url}" alt="${car.name || ''}" class="w-14 h-14 rounded-lg mr-3 object-cover">` : `<div class=\"w-14 h-14 bg-gray-100 rounded-lg mr-3 flex items-center justify-center\"><svg xmlns=\"http://www.w3.org/2000/svg\" class=\"h-6 w-6 text-gray-400\" fill=\"none\" viewBox=\"0 0 24 24\" stroke=\"currentColor\"><path stroke-linecap=\"round\" stroke-linejoin=\"round\" stroke-width=\"2\" d=\"M3 13l2-2m0 0l7-7 7 7M13 5v6m0 0l-2 2m2-2h6\" /></svg></div>`}
                                        <div>
                                            <div class="text-sm font-medium text-black">${car.name || car.title || '—'}</div>
                                            <div class="text-xs text-gray-600">${[car.year, car.color].filter(Boolean).join(' • ')}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            ${purchase.transaction_hash ? `
                                    <div class="mt-6">
                                        <h4 class="text-sm font-medium text-black mb-2">Transaction</h4>
                                        <div class="bg-gray-50 border border-gray-200 rounded-lg p-3 text-xs font-mono break-all">${purchase.transaction_hash}</div>
                                    </div>` : ''}

                            <div class="mt-6 flex justify-end gap-2">
                                ${(purchase.status || '').toLowerCase() === 'completed' ? `<a href="${window.APP_ROUTES?.invoice?.replace(':id', purchase.id) || '#'}" class="inline-flex items-center px-4 py-2 bg-black text-white rounded-lg text-xs hover:bg-gray-800"><svg xmlns=\"http://www.w3.org/2000/svg\" class=\"h-4 w-4 mr-2\" fill=\"none\" viewBox=\"0 0 24 24\" stroke=\"currentColor\"><path stroke-linecap=\"round\" stroke-linejoin=\"round\" stroke-width=\"2\" d=\"M12 4v16m8-8H4\" /></svg>Invoice</a>`: ''}
                                <button onclick="this.closest('.fixed').remove()" class="inline-flex items-center px-4 py-2 bg-white text-black border border-gray-200 rounded-lg text-xs hover:bg-gray-50">Close</button>
                            </div>
                        </div>
                    </div>
                </div>
            `;
                document.body.appendChild(modal);

                modal.addEventListener('click', function(e) {
                    if (e.target === this) this.remove();
                });
            }

            // Provide route helper for modal invoice link
            window.APP_ROUTES = window.APP_ROUTES || {};
            window.APP_ROUTES.invoice = ":id";
        </script>
    @endpush
@endsection
