@extends('Template::layouts.dashboard')

@section('content')
<div class="min-h-[80vh] flex items-center justify-center px-4 py-12">
    <div class="relative w-full max-w-lg">
        
        <div class="absolute -inset-1 bg-gradient-to-r from-orange-500 via-yellow-500 to-orange-400 rounded-[2.5rem] blur opacity-20 transition duration-1000"></div>
        
        <div class="relative bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2.5rem] shadow-2xl overflow-hidden">
            
            <div class="p-10 pb-6 text-center">
                <div class="w-20 h-20 bg-slate-50 dark:bg-white/5 rounded-3xl flex items-center justify-center mx-auto mb-6 border border-slate-100 dark:border-white/5 shadow-inner">
                    <i data-lucide="zap" class="w-10 h-10 text-orange-500"></i>
                </div>
                <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase">@lang('Secure Checkout')</h2>
                <div class="inline-flex items-center gap-2 px-4 py-1.5 bg-orange-500/10 rounded-full mt-4 border border-orange-500/20">
                    <span class="w-1.5 h-1.5 rounded-full bg-orange-500 animate-pulse"></span>
                    <span class="text-[9px] font-black text-orange-500 uppercase tracking-[0.2em]">@lang('Flutterwave Protocol Active')</span>
                </div>
            </div>

            <div class="px-10 pb-10">
                <div class="relative group">
                    <div class="absolute inset-0 bg-gradient-to-b from-slate-50 to-white dark:from-white/5 dark:to-transparent rounded-3xl"></div>
                    <div class="relative p-8 space-y-6 border border-slate-100 dark:border-white/5 rounded-3xl">
                        
                        <div class="flex justify-between items-end">
                            <div class="flex flex-col">
                                <span class="text-[10px] font-black text-slate-400 uppercase tracking-[0.2em]">@lang('Required Settlement')</span>
                                <span class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter mt-1">
                                    {{ showAmount($deposit->final_amount, currencyFormat: false) }} <span class="text-sm text-slate-400">{{ __($deposit->method_currency) }}</span>
                                </span>
                            </div>
                        </div>

                        <div class="h-px w-full border-t border-dashed border-slate-200 dark:border-white/10"></div>

                        <div class="flex justify-between items-center">
                            <span class="text-[10px] font-black text-slate-400 uppercase tracking-[0.2em]">@lang('Node Allocation')</span>
                            <span class="text-sm font-black text-emerald-500">
                                {{ showAmount($deposit->amount) }}
                            </span>
                        </div>

                        <div class="flex justify-between items-center opacity-60">
                            <span class="text-[10px] font-black text-slate-400 uppercase tracking-[0.2em]">@lang('Internal Ref')</span>
                            <span class="text-[10px] font-mono font-bold text-slate-500 uppercase">{{ $deposit->trx }}</span>
                        </div>
                    </div>
                </div>

                <div class="mt-10">
                    <button type="button" class="group relative w-full h-18 py-5 bg-slate-900 dark:bg-white rounded-2xl overflow-hidden transition-all active:scale-95 shadow-[0_20px_40px_rgba(0,0,0,0.1)]" id="btn-confirm" onClick="payWithRave()">
                        <div class="absolute inset-0 bg-gradient-to-r from-orange-500 to-orange-400 opacity-0 group-hover:opacity-100 transition-opacity duration-500"></div>
                        
                        <div class="relative flex items-center justify-center gap-4">
                            <span class="text-[12px] font-black text-white dark:text-slate-900 uppercase tracking-[0.3em] group-hover:text-white">
                                @lang('Authorize Node Deposit')
                            </span>
                            <i data-lucide="shield-check" class="w-5 h-5 text-orange-400 dark:text-orange-600 group-hover:text-white transition-colors"></i>
                        </div>
                    </button>
                    
                    <div class="mt-6 flex items-center justify-center gap-3 opacity-40">
                        <i data-lucide="lock" class="w-3.5 h-3.5 text-slate-400"></i>
                        <p class="text-[9px] font-black text-slate-400 uppercase tracking-[0.2em]">@lang('PBF-Inline Encryption Active')</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
    <script src="https://unpkg.com/lucide@latest"></script>
    <script src="https://api.ravepay.co/flwv3-pug/getpaidx/api/flwpbf-inline.js"></script>
    <script>
        "use strict"
        
        // Init Icons
        lucide.createIcons();

        const API_publicKey = "{{ $data->API_publicKey }}";

        function payWithRave() {
            var x = getpaidSetup({
                PBFPubKey: API_publicKey,
                customer_email: "{{ $data->customer_email }}",
                amount: "{{ $data->amount }}",
                customer_phone: "{{ $data->customer_phone }}",
                currency: "{{ $data->currency }}",
                txref: "{{ $data->txref }}",
                onclose: function() {},
                callback: function(response) {
                    var txref = response.tx.txRef;
                    var status = response.tx.status;
                    var chargeResponse = response.tx.chargeResponseCode;
                    if (chargeResponse == "00" || chargeResponse == "0") {
                        window.location = '{{ url('ipn/flutterwave') }}/' + txref + '/' + status;
                    } else {
                        window.location = '{{ url('ipn/flutterwave') }}/' + txref + '/' + status;
                    }
                }
            });
        }
    </script>
@endpush