@extends('Template::layouts.dashboard')
@section('content')
<div class="min-h-screen flex items-center justify-center py-2 px-4">
    <div class="relative w-full max-w-lg">
        
        <div class="absolute -inset-1 bg-gradient-to-r from-emerald-500 via-cyan-500 to-blue-500 rounded-[2.5rem] blur opacity-20"></div>
        
        <div class="relative bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2.5rem] shadow-2xl overflow-hidden">
            
            <div class="p-8 pb-4 text-center">
                <div class="w-16 h-16 bg-slate-100 dark:bg-white/5 rounded-2xl flex items-center justify-center mx-auto mb-6 border border-slate-200 dark:border-white/10">
                    <i data-lucide="credit-card" class="w-8 h-8 text-emerald-500"></i>
                </div>
                <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase">@lang('Secure Checkout')</h2>
                <div class="inline-flex items-center gap-2 px-3 py-1 bg-emerald-500/10 rounded-full mt-3">
                    <span class="w-1.5 h-1.5 rounded-full bg-emerald-500 animate-pulse"></span>
                    <span class="text-[9px] font-black text-emerald-500 uppercase tracking-widest">@lang('Paystack Gateway Active')</span>
                </div>
            </div>

            <div class="p-8">
                <div class="space-y-4 bg-slate-50 dark:bg-white/5 rounded-3xl p-6 border border-slate-100 dark:border-white/5">
                    
                    <div class="flex justify-between items-center">
                        <span class="text-[10px] font-black text-slate-400 uppercase tracking-[0.2em]">@lang('Settlement Amount')</span>
                        <span class="text-lg font-black text-slate-900 dark:text-white tracking-tighter">
                            {{showAmount($deposit->final_amount, currencyFormat:false)}} {{__($deposit->method_currency)}}
                        </span>
                    </div>

                    <div class="h-px bg-dashed bg-slate-200 dark:bg-white/10 my-2"></div>

                    <div class="flex justify-between items-center">
                        <span class="text-[10px] font-black text-slate-400 uppercase tracking-[0.2em]">@lang('Asset Credit')</span>
                        <span class="text-md font-bold text-emerald-500">
                            {{showAmount($deposit->amount)}}
                        </span>
                    </div>

                    <div class="flex justify-between items-center pt-2">
                        <span class="text-[10px] font-black text-slate-400 uppercase tracking-[0.2em]">@lang('TX Reference')</span>
                        <span class="text-[10px] font-mono font-bold text-slate-500 uppercase tracking-tighter">
                            {{ $deposit->trx }}
                        </span>
                    </div>
                </div>

                <form action="{{ route('ipn.'.$deposit->gateway->alias) }}" method="POST" class="mt-8">
                    @csrf
                    
                    <button type="button" class="group relative w-full h-16 bg-slate-900 dark:bg-white rounded-2xl overflow-hidden transition-all active:scale-95 shadow-xl shadow-emerald-500/10" id="btn-confirm">
                        <div class="absolute inset-0 bg-gradient-to-r from-emerald-500 to-cyan-500 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                        
                        <div class="relative flex items-center justify-center gap-3">
                            <span class="text-[11px] font-black text-white dark:text-slate-900 uppercase tracking-[0.3em] group-hover:text-white">
                                @lang('Authorize Payment')
                            </span>
                            <i data-lucide="arrow-right" class="w-4 h-4 text-emerald-400 dark:text-emerald-600 group-hover:text-white group-hover:translate-x-1 transition-all"></i>
                        </div>
                    </button>

                    <script
                        src="//js.paystack.co/v1/inline.js"
                        data-key="{{ $data->key }}"
                        data-email="{{ $data->email }}"
                        data-amount="{{ round($data->amount) }}"
                        data-currency="{{$data->currency}}"
                        data-ref="{{ $data->ref }}"
                        data-custom-button="btn-confirm"
                    ></script>
                </form>

                <div class="mt-8 flex items-center justify-center gap-4 opacity-50">
                    <i data-lucide="lock" class="w-3 h-3 text-slate-400"></i>
                    <p class="text-[9px] font-black text-slate-400 uppercase tracking-[0.2em]">@lang('End-to-End Encrypted Settlement')</p>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://unpkg.com/lucide@latest"></script>
<script>
    lucide.createIcons();
</script>
@endsection