@extends('Template::layouts.master')

@section('content')
    <div class="max-w-7xl mx-auto">
        <!-- Enhanced Header -->
        <div
            class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
                <div class="absolute bottom-0 left-0 w-24 h-24 bg-white rounded-full translate-y-12 -translate-x-12"></div>
            </div>

            <div class="relative z-10">
                <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                    <div class="mb-4 lg:mb-0 lg:flex-1">
                        <div class="flex items-center mb-1">
                            <h1 class="text-xl font-light">Stock Marketplace</h1>
                            <div class="ml-3 real-time-indicator">
                                <span
                                    class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-green-900 text-green-300">
                                    <i data-lucide="radio" class="w-3 h-3 mr-1"></i>
                                    Live
                                </span>
                            </div>
                        </div>
                        <p class="text-gray-300 text-sm">Discover and trade stocks from leading companies</p>
                        <p class="text-xs text-gray-400 mt-1">Last updated: <span data-last-updated>{{now()}}</span></p>
                    </div>

                    <!-- Enhanced Stats Card -->
                    <div
                        class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-80">
                        <div class="flex items-center justify-between mb-3">
                            <div>
                                <p class="text-xs text-gray-300 mb-1">Active Stocks</p>
                                <p class="text-lg font-light">{{count($stocks)}}</p>
                            </div>
                            <div class="w-10 h-10 flex items-center justify-center">
                                <i data-lucide="bar-chart-3" class="w-5 h-5 text-white"></i>
                            </div>
                        </div>
                        <div class="flex space-x-4 text-xs">
                            <div class="flex-1 text-center">
                                <p class="text-gray-300">Gainers</p>
                                <p class="text-white font-medium">56</p>
                            </div>
                            <div class="flex-1 text-center">
                                <p class="text-gray-300">Losers</p>
                                <p class="text-white font-medium">55</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Market Overview -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6" data-market-section="overview">
            <!-- Top Gainers -->
            <a href="?top=gainer"
                class="block bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-md hover:border-green-200 transition-all duration-200 group cursor-pointer"
                data-market-section="gainers">
                <div class="flex items-center justify-between mb-3">
                    <div>
                        <p class="text-xs text-gray-500 mb-1">Top Gainers <span class="text-gray-400">(56 total)</span></p>
                        <p class="text-lg font-light text-green-600 stock-price" data-stock-symbol="TMO">+5.00%</p>
                        <p class="text-xs text-gray-400 mt-1">Click to view all 56 gainers</p>
                    </div>
                    <div class="w-8 h-8 flex items-center justify-center">
                        <i data-lucide="trending-up"
                            class="w-4 h-4 text-green-600 group-hover:scale-110 transition-transform duration-200"></i>
                    </div>
                </div>
            </a>

            <!-- Top Losers -->
            <a href="?top=losers"
                class="block bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-md hover:border-red-200 transition-all duration-200 group cursor-pointer"
                data-market-section="losers">
                <div class="flex items-center justify-between mb-3">
                    <div>
                        <p class="text-xs text-gray-500 mb-1">Top Losers <span class="text-gray-400">(55 total)</span></p>
                        <p class="text-lg font-light text-red-600 stock-price" data-stock-symbol="HON">-4.93%</p>
                        <p class="text-xs text-gray-400 mt-1">Click to view all 55 losers</p>
                    </div>
                    <div class="w-8 h-8 flex items-center justify-center">
                        <i data-lucide="trending-down"
                            class="w-4 h-4 text-red-600 group-hover:scale-110 transition-transform duration-200"></i>
                    </div>
                </div>
            </a>

            <!-- Most Active -->
            <a href="??top=active"
                class="block bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-md hover:border-blue-200 transition-all duration-200 group cursor-pointer"
                data-market-section="most-active">
                <div class="flex items-center justify-between mb-3">
                    <div>
                        <p class="text-xs text-gray-500 mb-1">Most Active</p>
                        <p class="text-lg font-light text-black stock-volume" data-stock-symbol="PYPL">98.3M</p>
                        <p class="text-xs text-gray-400 mt-1">Click to view all</p>
                    </div>
                    <div class="w-8 h-8 flex items-center justify-center">
                        <i data-lucide="activity"
                            class="w-4 h-4 text-blue-600 group-hover:scale-110 transition-transform duration-200"></i>
                    </div>
                </div>
            </a>
        </div>

        <!-- Search and Filters -->
        <div class="bg-white rounded-xl p-4 shadow-sm border border-gray-100 mb-6">
            <form method="GET" class="grid grid-cols-1 md:grid-cols-5 gap-4">
                <!-- Search -->
                <div>
                    <label for="search" class="block text-xs font-medium text-gray-700 mb-1">Search</label>
                    <input type="text" id="search" name="search" value="" placeholder="Symbol or company name"
                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200">
                </div>

                <!-- Sector Filter -->
                <div>
                    <label for="sector" class="block text-xs font-medium text-gray-700 mb-1">Sector</label>
                    <select id="sector" name="sector"
                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200">
                        <option value="">All Sectors</option>
                        <option value="Automobiles">Automobiles</option> 
                    </select>
                </div>

                <!-- Industry Filter -->
                <div>
                    <label for="industry" class="block text-xs font-medium text-gray-700 mb-1">Industry</label>
                    <select id="industry" name="industry"
                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200">
                        <option value="">All Industries</option> 
                        <option value="Music Streaming">Music Streaming</option>
                    </select>
                </div>

                <!-- Sort -->
                <div>
                    <label for="sort" class="block text-xs font-medium text-gray-700 mb-1">Sort By</label>
                    <select id="sort" name="sort"
                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200">
                        <option value="symbol">Symbol</option>
                        <option value="price">Price</option>
                        <option value="change">Change</option>
                        <option value="volume">Volume</option>
                        <option value="market_cap">Market Cap</option>
                    </select>
                </div>

                <!-- Actions -->
                <div class="flex items-end space-x-2">
                    <button type="submit"
                        class="px-4 py-2 bg-black text-white text-xs font-medium rounded-lg hover:bg-gray-800 transition-colors duration-200">
                        <i data-lucide="search" class="w-3 h-3 mr-1"></i>
                        Search
                    </button>
                    <a href="{{route('user.stock.index')}}"
                        class="px-4 py-2 border border-gray-300 text-black text-xs font-medium rounded-lg hover:bg-gray-50 transition-colors duration-200">
                        <i data-lucide="refresh-cw" class="w-3 h-3 mr-1"></i>
                        Clear
                    </a>
                </div>
            </form>
        </div>

        <!-- Featured Stocks -->
         

        <!-- Stock List -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-100">
                <div class="flex items-center justify-between">
                    <div>
                        <h3 class="text-lg font-light text-black mb-1">All Stocks</h3>
                        <p class="text-xs text-gray-500">{{count($stocks)}} stocks available</p>
                    </div>
                </div>
            </div>

            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Stock</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Price</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Change</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Volume</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Market Cap</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-100">
                        @foreach($stocks as $stock)
                        <tr class="hover:bg-gray-50 transition-colors duration-200 stock-row" data-stock-symbol="AAPL">
                            <td class="px-6 py-4">
                                <div class="flex items-center">
                                    <div class="flex-shrink-0 w-8 h-8 rounded-lg overflow-hidden">
                                        <img src="{{ getImage(getFilePath('stock').'/'.$stock->logo) }}"
                                            alt="Apple Inc." class="w-8 h-8 object-cover"
                                            onerror="this.src='data:image/svg+xml;base64,PHN2ZyB3aWR0aD0nMzInIGhlaWdodD0nMzInIHhtbG5zPSdodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2Zyc+PGNpcmNsZSBjeD0nMTYnIGN5PScxNicgcj0nMTYnIGZpbGw9J2dyYXknLz48dGV4dCB4PScxNicgeT0nMjAnIHRleHQtYW5jaG9yPSdtaWRkbGUnIGZpbGw9J3doaXRlJyBmb250LWZhbWlseT0nQXJpYWwnIGZvbnQtc2l6ZT0nMTInIGZvbnQtd2VpZ2h0PSdib2xkJz5BPC90ZXh0Pjwvc3ZnPg=='"
                                            loading="lazy">
                                    </div>
                                    <div class="ml-3">
                                        <div class="text-sm font-medium text-black stock-symbol">{{$stock->symbol}}</div>
                                        <div class="text-xs text-gray-500 stock-name">{{$stock->symbol}} Inc.</div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-sm text-black stock-price" data-stock-symbol="AAPL"
                                    data-previous-price="229.35">${{number_format($stock->price,2)}}</div>
                            </td>
                            <td class="px-6 py-4">
                                {{-- Percentage Change Logic --}}
                                @php
                                    $changeColor = 'text-gray-600'; // Default
                                    if (str_starts_with($stock->pct_change, '+')) {
                                        $changeColor = 'text-green-600';
                                    } elseif (str_starts_with($stock->pct_change, '-')) {
                                        $changeColor = 'text-red-600';
                                    }
                                @endphp
                                
                                <div class="text-sm {{ $changeColor }} font-bold stock-change" data-stock-change="{{$stock->symbol}}">
                                    {{ $stock->pct_change }}
                                </div>

                                {{-- P/E Ratio (Usually neutral, but following your structure) --}}
                                <div class="text-xs text-gray-500">
                                    @lang('P/E'): {{ $stock->pe_ratio }}
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-sm text-black stock-volume" data-stock-volume="{{$stock->symbol}}">8.0M</div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-sm text-black">${{$stock->market_cap}}</div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex space-x-2">
                                    <a href="{{route('user.stock.details',$stock->id)}}"
                                        class="w-8 h-8 flex items-center justify-center text-blue-600 hover:text-blue-800 hover:bg-blue-50 rounded-lg transition-colors duration-200"
                                        title="View Details">
                                        <i data-lucide="eye" class="w-4 h-4"></i>
                                    </a>
                                     
                                </div>
                            </td>
                        </tr>
                        @endforeach
                       
                         
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="px-6 py-4 border-t border-gray-100">
                 

            </div>
        </div>
    </div>
@endsection
