@extends('Template::layouts.master')

@section('content')
<div class="mx-auto max-w-4xl py-6 px-4 flex flex-col h-[85vh]">

    {{-- 1. Header: The Control Bar --}}
    <div class="flex items-center justify-between bg-white dark:bg-[#111b21] p-4 rounded-t-3xl border border-slate-200 dark:border-white/5 shadow-sm z-30">
        <div class="flex items-center gap-3">
            <div class="w-10 h-10 bg-emerald-500 rounded-full flex items-center justify-center text-white shadow-lg shadow-emerald-500/20">
                <i data-lucide="headphones" class="w-5 h-5"></i>
            </div>
            <div>
                <h2 class="text-sm font-black dark:text-white uppercase tracking-tight">Support #{{ $myTicket->ticket }}</h2>
                <div class="flex items-center gap-2">
                    <span class="w-2 h-2 bg-emerald-500 rounded-full animate-pulse"></span>
                    <span class="text-[10px] font-bold text-slate-500 uppercase">Active Session</span>
                </div>
            </div>
        </div>
        
        <div class="flex items-center gap-4">
            <div class="status-badge-wrapper scale-90">@php echo $myTicket->statusBadge; @endphp</div>
            @if ($myTicket->status != 3)
                <button class="confirmationBtn text-slate-400 hover:text-rose-500 transition-colors" 
                        data-question="@lang('Terminate this thread?')" 
                        data-action="{{ route('ticket.close', $myTicket->id) }}">
                    <i data-lucide="power" class="w-5 h-5"></i>
                </button>
            @endif
        </div>
    </div>

    {{-- 2. Chat Canvas: Classic Pattern with Modern Bubbles --}}
    <div class="flex-1 overflow-y-auto p-4 md:p-6 bg-[#efe7de] dark:bg-[#0b141a] relative border-x border-slate-200 dark:border-white/5" 
         id="chatContainer"
         style="background-image: url('https://user-images.githubusercontent.com/15075759/28719144-86dc0f70-73b1-11e7-911d-60d70fcded21.png'); background-blend-mode: soft-light; background-opacity: 0.05;">
        
        <div class="flex flex-col gap-4">
            @foreach ($messages as $message)
                @php $isAdmin = $message->admin_id != 0; @endphp
                
                <div class="flex {{ $isAdmin ? 'justify-start' : 'justify-end' }} animate-in fade-in slide-in-from-bottom-2 duration-300">
                    <div class="relative max-w-[85%] md:max-w-[75%]">
                        
                        {{-- Bubble --}}
                        <div class="p-3 shadow-sm relative {{ $isAdmin 
                            ? 'bg-white dark:bg-[#202c33] text-slate-800 dark:text-slate-200 rounded-2xl rounded-tl-none' 
                            : 'bg-[#dcf8c6] dark:bg-[#005c4b] text-slate-900 dark:text-white rounded-2xl rounded-tr-none' }}">
                            
                            @if($isAdmin)
                                <div class="flex items-center gap-1 mb-1">
                                    <span class="text-[10px] font-black text-blue-500 uppercase tracking-widest">@lang('Official Support')</span>
                                    <i data-lucide="badge-check" class="w-3 h-3 text-blue-500"></i>
                                </div>
                            @endif

                            <p class="text-[13px] leading-relaxed whitespace-pre-wrap font-medium">{{ $message->message }}</p>

                            @if ($message->attachments->count() > 0)
                                <div class="mt-3 grid grid-cols-1 gap-2">
                                    @foreach ($message->attachments as $file)
                                        <a href="{{ route('ticket.download', encrypt($file->id)) }}" 
                                           class="flex items-center justify-between p-2 rounded-lg bg-black/5 dark:bg-white/5 hover:bg-black/10 transition-all border border-black/5">
                                            <div class="flex items-center gap-2">
                                                <i data-lucide="file-text" class="w-4 h-4 {{ $isAdmin ? 'text-slate-400' : 'text-emerald-200' }}"></i>
                                                <span class="text-[10px] font-bold uppercase tracking-tighter">Document_{{ $loop->iteration }}</span>
                                            </div>
                                            <i data-lucide="download-cloud" class="w-3.5 h-3.5 opacity-50"></i>
                                        </a>
                                    @endforeach
                                </div>
                            @endif

                            {{-- Time & Status --}}
                            <div class="flex justify-end items-center gap-1 mt-1 opacity-60">
                                <span class="text-[9px] font-bold">{{ $message->created_at->format('H:i') }}</span>
                                @if(!$isAdmin)
                                    <i data-lucide="check-check" class="w-3 h-3 text-blue-500"></i>
                                @endif
                            </div>
                        </div>

                        {{-- Bubble Tail --}}
                        <div class="absolute top-0 {{ $isAdmin ? '-left-2' : '-right-2' }} w-3 h-3 {{ $isAdmin ? 'bg-white dark:bg-[#202c33]' : 'bg-[#dcf8c6] dark:bg-[#005c4b]' }}" 
                             style="clip-path: {{ $isAdmin ? 'polygon(100% 0, 0 0, 100% 100%)' : 'polygon(0 0, 100% 0, 0 100%)' }};">
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>

    {{-- 3. Footer: The Input Dock --}}
    @if ($myTicket->status != 4)
    <div class="bg-white dark:bg-[#111b21] p-3 rounded-b-3xl border border-slate-200 dark:border-white/5 shadow-xl">
        <form method="post" action="{{ route('ticket.reply', $myTicket->id) }}" enctype="multipart/form-data">
            @csrf
            <div id="filePreview" class="flex flex-wrap gap-2 px-2 pb-2"></div>
            
            <div class="flex items-center gap-2 bg-[#f0f2f5] dark:bg-[#2a3942] p-2 rounded-2xl">
                <button type="button" class="addAttachment p-2 text-slate-500 hover:text-emerald-500 transition-colors">
                    <i data-lucide="paperclip" class="w-6 h-6"></i>
                </button>
                
                <textarea name="message" id="chatInput" rows="1" 
                          class="flex-1 bg-transparent border-none py-2 px-2 text-sm dark:text-white focus:ring-0 outline-none resize-none max-h-32 scrollbar-hide" 
                          placeholder="Type your message..." required>{{ old('message') }}</textarea>

                <button type="submit" class="bg-emerald-500 hover:bg-emerald-600 text-white p-3 rounded-xl shadow-lg shadow-emerald-500/20 active:scale-90 transition-all">
                    <i data-lucide="send" class="w-5 h-5"></i>
                </button>
            </div>
        </form>
    </div>
    @else
    <div class="bg-slate-50 dark:bg-[#111b21] p-4 text-center rounded-b-3xl">
        <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest flex items-center justify-center gap-2">
            <i data-lucide="archive" class="w-3 h-3"></i>
            Session archived by protocol
        </p>
    </div>
    @endif
</div>

<x-confirmation-modal2 closeBtn="btn-danger btn-md" submitBtn="btn--base btn-md"></x-confirmation-modal2>

<style>
    /* Status Badge Refinement */
    .status-badge-wrapper .badge {
        padding: 4px 10px !important;
        font-size: 8px !important;
        font-weight: 900 !important;
        text-transform: uppercase !important;
        border-radius: 6px !important;
        border: none !important;
    }
    .badge.bg--success { background: #10b981 !important; color: white !important; }
    .badge.bg--warning { background: #f59e0b !important; color: white !important; }
    
    .scrollbar-hide::-webkit-scrollbar { display: none; }
    #chatContainer::-webkit-scrollbar { width: 4px; }
    #chatContainer::-webkit-scrollbar-thumb { background: rgba(0,0,0,0.1); border-radius: 10px; }
</style>
@endsection

@push('script')
<script src="https://unpkg.com/lucide@latest"></script>
<script>
    (function($) {
        "use strict";
        
        // Initialize Icons
        const initIcons = () => lucide.createIcons();
        initIcons();

        // Scroll to Bottom
        const container = document.getElementById('chatContainer');
        container.scrollTop = container.scrollHeight;

        // Auto-resize Textarea
        const tx = document.getElementById('chatInput');
        tx.addEventListener("input", function() {
            this.style.height = "auto";
            this.style.height = (this.scrollHeight) + "px";
        });

        // Attachment Logic
        var fileAdded = 0;
        $('.addAttachment').on('click', function() {
            if (fileAdded >= 5) return;
            fileAdded++;
            
            const fileId = `file_${Date.now()}`;
            $("#filePreview").append(`
                <div class="relative group animate-in zoom-in duration-200" id="${fileId}">
                    <div class="w-12 h-12 bg-emerald-500/10 border border-emerald-500/20 rounded-xl flex items-center justify-center">
                        <i data-lucide="file-plus" class="w-5 h-5 text-emerald-500"></i>
                    </div>
                    <input type="file" name="attachments[]" class="hidden" id="input_${fileId}" onchange="initIcons()">
                    <button type="button" class="absolute -top-1 -right-1 bg-rose-500 text-white rounded-full p-0.5 shadow-sm" onclick="removeFile('${fileId}')">
                        <i data-lucide="x" class="w-3 h-3"></i>
                    </button>
                </div>
            `);
            document.getElementById(`input_${fileId}`).click();
            initIcons();
        });

        window.removeFile = function(id) {
            $(`#${id}`).remove();
            fileAdded--;
        };
    })(jQuery);
</script>
@endpush