@extends('Template::layouts.master')

@section('content')
                    <div class="max-w-7xl mx-auto">
        <!-- Enhanced Header -->
        <div class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
                <div class="absolute bottom-0 left-0 w-24 h-24 bg-white rounded-full translate-y-12 -translate-x-12"></div>
            </div>
            
            <div class="relative z-10">
                <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                    <div class="mb-4 lg:mb-0 lg:flex-1">
                        <h1 class="text-xl font-light mb-1">Transaction History</h1>
                        <p class="text-gray-300 text-sm">View all your wallet transactions and activity</p>
                    </div>
                    
                    <!-- Enhanced Stats Card -->
                    <div class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-80">
                        <div class="flex items-center justify-between mb-3">
                            <div>
                                <p class="text-xs text-gray-300 mb-1">Total Transactions</p>
                                <p class="text-lg font-light">{{$trxcount}}</p>
                            </div>
                            <div class="w-10 h-10 flex items-center justify-center">
                                <i data-lucide="list" class="w-5 h-5 text-white"></i>
                            </div>
                        </div>
                        <div class="flex space-x-4 text-xs">
                            <div class="flex-1 text-center">
                                <p class="text-gray-300">Deposits</p>
                                <p class="text-white font-medium">{{ showAmount($totalCredit) }}</p>
                            </div>
                            <div class="flex-1 text-center">
                                <p class="text-gray-300">Withdrawals</p>
                                <p class="text-white font-medium">{{ showAmount($totalDebit) }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Enhanced Filters -->
        {{-- Filter Section --}}
            <div style="margin-bottom: 2rem;">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem; padding: 0 0.5rem;">
                    <h4 style="font-size: 11px; font-weight: 900; text-transform: uppercase; letter-spacing: 0.3em; color: #475569;">@lang('Transaction Filtering')</h4>
                    <button type="button" class="filter-toggle-btn" style="width: 40px; height: 40px; border-radius: 12px; background: #f1f5f9; border: 1px solid #e2e8f0; color: #64748b; cursor: pointer; display: flex; align-items: center; justify-content: center; transition: all 0.2s;">
                        <i data-lucide="sliders-horizontal" style="width: 18px; height: 18px;"></i>
                    </button>
                </div>

                <div id="filterCard" style="display: snone; transition: all 0.3s ease-in-out;">
                    <div style="background: #ffffff; border: 1px solid #e2e8f0; border-radius: 2rem; padding: 2rem; box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);">
                        <form action="" method="GET" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1.5rem;">
                            <div>
                                <label style="font-size: 9px; font-weight: 900; color: #94a3b8; text-transform: uppercase; display: block; margin-bottom: 0.5rem;">@lang('Reference Number')</label>
                                <input type="text" name="search" value="{{ request()->search }}" style="width: 100%; padding: 0.75rem 1rem; border-radius: 12px; border: 1px solid #e2e8f0; background: #f8fafc; font-size: 13px; font-weight: 600; outline: none; box-sizing: border-box;">
                            </div>
                            <div>
                                <label style="font-size: 9px; font-weight: 900; color: #94a3b8; text-transform: uppercase; display: block; margin-bottom: 0.5rem;">@lang('Wallet Type')</label>
                                <select name="wallet_type" style="width: 100%; padding: 0.75rem 1rem; border-radius: 12px; border: 1px solid #e2e8f0; background: #f8fafc; font-size: 13px; font-weight: 600; outline: none; appearance: none; box-sizing: border-box;">
                                    <option value="">@lang('All Wallets')</option>
                                    <option value="deposit_wallet" @selected(request()->wallet_type == 'deposit_wallet')>@lang('Deposit')</option>
                                    <option value="interest_wallet" @selected(request()->wallet_type == 'interest_wallet')>@lang('Interest')</option>
                                </select>
                            </div>
                            <div>
                                <label style="font-size: 9px; font-weight: 900; color: #94a3b8; text-transform: uppercase; display: block; margin-bottom: 0.5rem;">@lang('Flow')</label>
                                <select name="trx_type" style="width: 100%; padding: 0.75rem 1rem; border-radius: 12px; border: 1px solid #e2e8f0; background: #f8fafc; font-size: 13px; font-weight: 600; outline: none; appearance: none; box-sizing: border-box;">
                                    <option value="">@lang('All Flows')</option>
                                    <option value="+" @selected(request()->trx_type == '+')>@lang('Plus (+)')</option>
                                    <option value="-" @selected(request()->trx_type == '-')>@lang('Minus (-)')</option>
                                </select>
                            </div>
                            <div style="display: flex; align-items: flex-end;">
                                <button type="submit" style="width: 100%; padding: 0.85rem; background: #0f172a; color: white; border: none; border-radius: 12px; font-size: 10px; font-weight: 900; text-transform: uppercase; letter-spacing: 0.1em; cursor: pointer; transition: background 0.2s;">
                                    @lang('Apply Filters')
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        <!-- Enhanced Transaction Statistics -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
            <!-- Total Deposits -->
            <div class="bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 group">
                <div class="flex items-center justify-between">
                    <div class="flex-1">
                        <p class="text-xs font-medium text-gray-500 mb-1">Total Deposits</p>
                        <p class="text-lg font-light text-black mb-1">{{ showAmount($totalCredit) }}</p>
                        <p class="text-xs text-green-600">This period</p>
                    </div>
                    <div class="flex flex-col items-end space-y-1">
                        <div class="w-10 h-10 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                            <i data-lucide="trending-up" class="w-5 h-5 text-green-500"></i>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Total Withdrawals -->
            <div class="bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 group">
                <div class="flex items-center justify-between">
                    <div class="flex-1">
                        <p class="text-xs font-medium text-gray-500 mb-1">Total Withdrawals</p>
                        <p class="text-lg font-light text-black mb-1">{{ showAmount($totalDebit) }}</p>
                        <p class="text-xs text-red-600">This period</p>
                    </div>
                    <div class="flex flex-col items-end space-y-1">
                        <div class="w-10 h-10 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                            <i data-lucide="trending-down" class="w-5 h-5 text-red-500"></i>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Total Fees -->
            <div class="bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 group">
                <div class="flex items-center justify-between">
                    <div class="flex-1">
                        <p class="text-xs font-medium text-gray-500 mb-1">Total Fees</p>
                        <p class="text-lg font-light text-black mb-1">{{ showAmount($totalFee) }}</p>
                        <p class="text-xs text-orange-600">Processing costs</p>
                    </div>
                    <div class="flex flex-col items-end space-y-1">
                        <div class="w-10 h-10 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                            <i data-lucide="calculator" class="w-5 h-5 text-orange-500"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Table Ledger --}}
    <div style="background: #ffffff; border: 1px solid #e2e8f0; border-radius: 2rem; overflow: hidden; box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.05);">
        <div style="overflow-x: auto;">
            <table style="width: 100%; border-collapse: collapse; text-align: left; min-width: 800px;">
                <thead>
                    <tr style="background: #f8fafc; border-bottom: 1px solid #e2e8f0;">
                        <th style="padding: 1.5rem; font-size: 10px; font-weight: 900; text-transform: uppercase; color: #64748b; letter-spacing: 0.1em;">@lang('Transaction Hash')</th>
                        <th style="padding: 1.5rem; font-size: 10px; font-weight: 900; text-transform: uppercase; color: #64748b; letter-spacing: 0.1em;">@lang('Timestamp')</th>
                        <th style="padding: 1.5rem; font-size: 10px; font-weight: 900; text-transform: uppercase; color: #64748b; letter-spacing: 0.1em; text-align: center;">@lang('Amount')</th>
                        <th style="padding: 1.5rem; font-size: 10px; font-weight: 900; text-transform: uppercase; color: #64748b; letter-spacing: 0.1em; text-align: center;">@lang('Wallet')</th>
                        <th style="padding: 1.5rem; font-size: 10px; font-weight: 900; text-transform: uppercase; color: #64748b; letter-spacing: 0.1em; text-align: right;">@lang('Details')</th>
                    </tr>
                </thead>
                <tbody style="font-size: 13px;">
                    @forelse($transactions as $trx)
                    <tr style="border-bottom: 1px solid #f1f5f9; transition: background 0.2s;">
                        <td style="padding: 1.5rem;">
                            <span style="font-weight: 800; color: #1e293b; font-family: monospace;">{{ $trx->trx }}</span>
                        </td>
                        <td style="padding: 1.5rem;">
                            <div style="font-weight: 700; color: #1e293b;">{{ showDateTime($trx->created_at, 'd M, Y') }}</div>
                            <div style="font-size: 10px; color: #94a3b8; font-weight: 600; margin-top: 2px;">{{ diffForHumans($trx->created_at) }}</div>
                        </td>
                        <td style="padding: 1.5rem; text-align: center;">
                            <span style="font-weight: 900; color: {{ $trx->trx_type == '+' ? '#10b981' : '#f43f5e' }};">
                                {{ $trx->trx_type }} {{ showAmount($trx->amount) }}
                            </span>
                        </td>
                        <td style="padding: 1.5rem; text-align: center;">
                            <span style="font-size: 9px; font-weight: 900; text-transform: uppercase; padding: 4px 12px; border-radius: 8px; border: 1px solid {{ $trx->wallet_type == 'deposit_wallet' ? '#3b82f6' : '#10b981' }}; color: {{ $trx->wallet_type == 'deposit_wallet' ? '#3b82f6' : '#10b981' }}; background: {{ $trx->wallet_type == 'deposit_wallet' ? 'rgba(59, 130, 246, 0.05)' : 'rgba(16, 185, 129, 0.05)' }};">
                                {{ $trx->wallet_type == 'deposit_wallet' ? 'Deposit' : 'Interest' }}
                            </span>
                        </td>
                        <td style="padding: 1.5rem; text-align: right; color: #64748b; font-style: italic; font-weight: 500;">
                            "{{ __($trx->details) }}"
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" style="padding: 5rem; text-align: center;">
                            <div style="opacity: 0.3;">
                                <i data-lucide="database-zap" style="width: 48px; height: 48px; margin-bottom: 1rem;"></i>
                                <p style="font-size: 10px; font-weight: 900; text-transform: uppercase; letter-spacing: 0.2em;">@lang('No transaction data found')</p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    @if ($transactions->hasPages())
        <div style="margin-top: 2.5rem; display: flex; justify-content: flex-end;">
            {{ paginateLinks($transactions) }}
        </div>
    @endif
    </div>



 
@endsection

@push('script')
<script src="https://unpkg.com/lucide@latest"></script>
<script>
    (function($) {
        "use strict";
        
        // Initialize Lucide Icons
        lucide.createIcons();

        // Fixed Toggle Logic
        const filterBtn = document.querySelector('.filter-toggle-btn');
        const filterCard = document.querySelector('#filterCard');

        if (filterBtn && filterCard) {
            filterBtn.addEventListener('click', function() {
                const isHidden = filterCard.style.display === 'none';
                
                if (isHidden) {
                    filterCard.style.display = 'block';
                    // Optional: Animate opacity or slide
                    filterBtn.style.background = '#10b981';
                    filterBtn.style.color = '#ffffff';
                } else {
                    filterCard.style.display = 'none';
                    filterBtn.style.background = '#f1f5f9';
                    filterBtn.style.color = '#64748b';
                }
            });
        }
    })(jQuery);
</script>
@endpush