<!DOCTYPE html>
<html lang="en" class="h-full bg-[#f8fafc]">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> {{ gs()->siteName(__($pageTitle)) }}</title>
    @include('partials.seo')
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; letter-spacing: -0.01em; }
        .glass-card { background: rgba(255, 255, 255, 0.8); backdrop-filter: blur(12px); }
        .input-focus-effect:focus { border-color: #10b981; box-shadow: 0 0 0 4px rgba(16, 185, 129, 0.1); }
        select { background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3e%3cpath stroke='%236b7280' stroke-linecap='round' stroke-linejoin='round' stroke-width='1.5' d='M6 8l4 4 4-4'/%3e%3c/svg%3e"); background-position: right 0.75rem center; background-repeat: no-repeat; background-size: 1.5em 1.5em; }
    </style>
</head>
<body class="h-full antialiased">

<div class="flex min-h-screen">
    <div class="hidden lg:flex w-[400px] bg-slate-900 p-12 flex-col justify-between fixed h-full">
        <div>
            <div class="flex items-center gap-3 mb-16">
                <div class="h-10 w-10 bg-emerald-500 rounded-xl flex items-center justify-center shadow-lg shadow-emerald-500/20">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/></svg>
                </div>
                <span class="text-white text-xl font-bold tracking-tight">{{ gs()->siteName}}</span>
            </div>

            <div class="space-y-12">
                <div class="flex gap-4 relative">
                    <div class="absolute left-[15px] top-[32px] w-[2px] h-[50px] bg-emerald-500/30"></div>
                    <div class="h-8 w-8 rounded-full bg-emerald-500 flex items-center justify-center text-white ring-4 ring-emerald-500/20 z-10">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"/></svg>
                    </div>
                    <div>
                        <h4 class="text-white font-semibold">Security Verified</h4>
                        <p class="text-slate-400 text-sm">Email and phone confirmed</p>
                    </div>
                </div>
                <div class="flex gap-4 relative">
                    <div class="absolute left-[15px] top-[32px] w-[2px] h-[50px] bg-slate-700"></div>
                    <div class="h-8 w-8 rounded-full bg-emerald-500 flex items-center justify-center text-white ring-4 ring-emerald-500/20 z-10">
                        <span class="text-xs font-bold">2</span>
                    </div>
                    <div>
                        <h4 class="text-white font-semibold text-lg">Personal Details</h4>
                        <p class="text-slate-400 text-sm">Setting up your investor profile</p>
                    </div>
                </div>
                <div class="flex gap-4">
                    <div class="h-8 w-8 rounded-full bg-slate-800 flex items-center justify-center text-slate-500 z-10">
                        <span class="text-xs font-bold">3</span>
                    </div>
                    <div>
                        <h4 class="text-slate-500 font-semibold">Financial Access</h4>
                        <p class="text-slate-600 text-sm">Full dashboard activation</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="bg-slate-800/50 p-6 rounded-2xl border border-slate-700/50">
            <p class="text-slate-400 text-xs leading-relaxed">
                <strong class="text-slate-200 block mb-1 uppercase tracking-wider">Privacy Guaranteed</strong>
                Your data is encrypted using AES-256 and stored in compliance with international financial regulations.
            </p>
        </div>
    </div>

    <div class="flex-1 lg:ml-[400px] bg-[#f8fafc] min-h-screen flex flex-col items-center py-16 px-6">
        <div class="w-full max-w-2xl">
            <div class="mb-10">
                <h2 class="text-4xl font-extrabold text-slate-900 tracking-tight mb-3">Finalize your account</h2>
                <p class="text-slate-500 text-lg">Complete the information below to start investing.</p>
            </div>

            <form method="POST" action="{{ route('user.data.submit') }}" class="space-y-8">
                @csrf
                
                <div class="bg-white p-8 rounded-3xl border border-slate-200 shadow-sm">
                    <div class="flex items-center gap-3 mb-8">
                        <div class="p-2 bg-emerald-50 rounded-lg text-emerald-600">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/></svg>
                        </div>
                        <h3 class="text-xl font-bold text-slate-900">Identity Details</h3>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        @if (!$user->email)
                        <div class="space-y-2">
                            <label class="text-sm font-bold text-slate-700 ml-1">First Name</label>
                            <input type="text" name="firstname" value="{{ old('firstname') }}" required class="w-full px-4 py-3.5 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none input-focus-effect transition-all" placeholder="Jane">
                        </div>
                        <div class="space-y-2">
                            <label class="text-sm font-bold text-slate-700 ml-1">Last Name</label>
                            <input type="text" name="lastname" value="{{ old('lastname') }}" required class="w-full px-4 py-3.5 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none input-focus-effect transition-all" placeholder="Doe">
                        </div>
                        <div class="md:col-span-2 space-y-2">
                            <label class="text-sm font-bold text-slate-700 ml-1">Email Address</label>
                            <input type="email" name="email" value="{{ old('email') }}" required class="checkUser w-full px-4 py-3.5 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none input-focus-effect transition-all" placeholder="jane@example.com">
                            <small class="text-red-500 emailExist font-medium"></small>
                        </div>
                        @endif

                        <div class="md:col-span-2 space-y-2">
                            <label class="text-sm font-bold text-slate-700 ml-1">Preferred Username</label>
                            <div class="relative">
                                <span class="absolute left-4 top-1/2 -translate-y-1/2 text-slate-400 font-medium">@</span>
                                <input type="text" name="username" value="{{ old('username') }}" required class="checkUser w-full pl-10 pr-4 py-3.5 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none input-focus-effect transition-all" placeholder="username">
                            </div>
                            <small class="text-red-500 usernameExist font-medium"></small>
                        </div>
                    </div>
                </div>

                <div class="bg-white p-8 rounded-3xl border border-slate-200 shadow-sm">
                    <div class="flex items-center gap-3 mb-8">
                        <div class="p-2 bg-blue-50 rounded-lg text-blue-600">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                        </div>
                        <h3 class="text-xl font-bold text-slate-900">Contact Information</h3>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="space-y-2">
                            <label class="text-sm font-bold text-slate-700 ml-1">Country</label>
                            <select name="country" class="w-full px-4 py-3.5 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none input-focus-effect transition-all appearance-none cursor-pointer">
                                @foreach ($countries as $key => $country)
                                    <option data-mobile_code="{{ $country->dial_code }}" value="{{ $country->country }}" data-code="{{ $key }}">
                                        {{ __($country->country) }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="space-y-2">
                            <label class="text-sm font-bold text-slate-700 ml-1">Mobile Number</label>
                            <div class="flex rounded-xl overflow-hidden border border-slate-200 focus-within:border-emerald-500 focus-within:ring-4 focus-within:ring-emerald-500/10 transition-all bg-slate-50">
                                <span class="mobile-code flex items-center px-4 bg-slate-100 border-r border-slate-200 text-slate-600 font-bold text-sm">--</span>
                                <input type="hidden" name="mobile_code">
                                <input type="hidden" name="country_code">
                                <input type="number" name="mobile" value="{{ old('mobile') }}" required class="flex-1 px-4 py-3.5 bg-transparent border-none focus:ring-0 outline-none text-slate-900 font-medium" placeholder="000 000 000">
                            </div>
                            <small class="text-red-500 mobileExist font-medium"></small>
                        </div>
                    </div>
                </div>

                <div class="bg-white p-8 rounded-3xl border border-slate-200 shadow-sm">
                    <div class="flex items-center gap-3 mb-8">
                        <div class="p-2 bg-amber-50 rounded-lg text-amber-600">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/></svg>
                        </div>
                        <h3 class="text-xl font-bold text-slate-900">Residential Address</h3>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="md:col-span-2 space-y-2">
                            <label class="text-sm font-bold text-slate-700 ml-1">Street Address</label>
                            <input type="text" name="address" value="{{ old('address') }}" class="w-full px-4 py-3.5 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none input-focus-effect transition-all" placeholder="123 Investment Way">
                        </div>
                        <div class="space-y-2">
                            <label class="text-sm font-bold text-slate-700 ml-1">City</label>
                            <input type="text" name="city" value="{{ old('city') }}" class="w-full px-4 py-3.5 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none input-focus-effect transition-all">
                        </div>
                        <div class="space-y-2">
                            <label class="text-sm font-bold text-slate-700 ml-1">State</label>
                            <input type="text" name="state" value="{{ old('state') }}" class="w-full px-4 py-3.5 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none input-focus-effect transition-all">
                        </div>
                        <div class="md:col-span-2 space-y-2">
                            <label class="text-sm font-bold text-slate-700 ml-1">Zip Code</label>
                            <input type="text" name="zip" value="{{ old('zip') }}" class="w-full px-4 py-3.5 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none input-focus-effect transition-all">
                        </div>
                    </div>
                </div>

                <button type="submit" class="w-full bg-slate-900 text-white py-5 rounded-2xl font-bold text-xl hover:bg-emerald-600 active:scale-[0.98] transition-all shadow-xl shadow-slate-200 flex items-center justify-center gap-3">
                    Activate Dashboard
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                </button>
            </form>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    "use strict";
    (function($) {
        // Provided checkUser logic
        $('.checkUser').on('focusout', function() {
            var value = $(this).val();
            var name = $(this).attr('name');
            checkUser(value, name);
        });

        function checkUser(value, name) {
            var url = '{{ route("user.checkUser") }}';
            var token = '{{ csrf_token() }}';
            var data = { _token: token };
            
            if (name == 'mobile') {
                data.mobile = value;
                data.mobile_code = $('.mobile-code').text().substr(1);
            } else {
                data[name] = value;
            }

            $.post(url, data, function(response) {
                if (response.data != false) {
                    $(`.${response.type}Exist`).text(`${response.field} already exist`);
                } else {
                    $(`.${response.type}Exist`).text('');
                }
            });
        }

        // Country & Mobile Logic
        $('select[name=country]').on('change', function() {
            let dialCode = $(this).find(':selected').data('mobile_code');
            let countryCode = $(this).find(':selected').data('code');
            $('.mobile-code').text('+' + dialCode);
            $('[name=mobile_code]').val(dialCode);
            $('[name=country_code]').val(countryCode);
        }).change();

    })(jQuery);
</script>
</body>
</html>