@extends('Template::layouts.master')
@section('content')
    <div class="max-w-7xl mx-auto">
        <!-- Enhanced Welcome Section with Wallet Balance -->
        <div
            class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
                <div class="absolute bottom-0 left-0 w-24 h-24 bg-white rounded-full translate-y-12 -translate-x-12"></div>
            </div>

            <div class="relative z-10">
                <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                    <div class="mb-4 lg:mb-0 lg:flex-1">
                        <h1 class="text-xl font-light mb-1">Wallet Balance</h1>
                        <p class="text-gray-300 text-sm">Manage your funds and transactions</p>
                    </div>

                    <!-- Enhanced Wallet Card -->
                    <div
                        class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-64">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-xs text-gray-300 mb-1">Available Balance</p>
                                <p class="text-xl font-light" data-balance-target="available-balance"
                                    data-balance-amount="0.00">
                                    {{ showAmount($user->deposit_wallet) }}
                                </p>
                                <p class="text-[11px] text-gray-200 mt-1" data-btc-target="available-balance">—</p>
                            </div>
                            <div class="w-10 h-10 flex items-center justify-center">
                                <i data-lucide="wallet" class="w-5 h-5 text-white"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Enhanced Quick Actions Grid -->
        <div class="grid grid-cols-2 md:grid-cols-2 gap-3 mb-6">
            <!-- Deposit -->
            <a href="{{ route('user.deposit.index') }}"
                class="group bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 hover:scale-105 relative overflow-hidden">
                <div
                    class="absolute inset-0 bg-gradient-to-br from-green-50 to-green-100 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                </div>
                <div class="relative z-10">
                    <div
                        class="w-10 h-10 flex items-center justify-center mb-3 group-hover:scale-110 transition-transform duration-300">
                        <i data-lucide="plus" class="w-5 h-5 text-green-500"></i>
                    </div>
                    <h3 class="font-medium text-black text-sm mb-1">Deposit Funds</h3>
                    <p class="text-xs text-gray-500 mb-2">Add money to your wallet</p>
                    <div class="flex items-center text-green-600 text-xs font-medium">
                        <span>Add Funds</span>
                        <i data-lucide="arrow-right"
                            class="w-3 h-3 ml-1 group-hover:translate-x-1 transition-transform duration-200"></i>
                    </div>
                </div>
            </a>

            <!-- Withdraw -->
            <a href="{{ route('user.withdraw') }}"
                class="group bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 hover:scale-105 relative overflow-hidden">
                <div
                    class="absolute inset-0 bg-gradient-to-br from-red-50 to-red-100 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                </div>
                <div class="relative z-10">
                    <div
                        class="w-10 h-10 flex items-center justify-center mb-3 group-hover:scale-110 transition-transform duration-300">
                        <i data-lucide="minus" class="w-5 h-5 text-red-500"></i>
                    </div>
                    <h3 class="font-medium text-black text-sm mb-1">Withdraw Funds</h3>
                    <p class="text-xs text-gray-500 mb-2">Transfer money to your bank</p>
                    <div class="flex items-center text-red-600 text-xs font-medium">
                        <span>Withdraw</span>
                        <i data-lucide="arrow-right"
                            class="w-3 h-3 ml-1 group-hover:translate-x-1 transition-transform duration-200"></i>
                    </div>
                </div>
            </a>
        </div>

        <!-- Enhanced Wallet Statistics -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
            <!-- Total Deposits -->
            <div
                class="bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 group">
                <div class="flex items-center justify-between">
                    <div class="flex-1">
                        <p class="text-xs font-medium text-gray-500 mb-1">Total Deposits</p>
                        <p class="text-lg font-light text-black mb-1" data-balance-target="total-deposits"
                            data-balance-amount="0">
                            {{ showAmount($successfulDeposits) }}
                        </p>
                        <p class="text-[11px] text-gray-500" data-btc-target="total-deposits">—</p>
                        <p class="text-xs text-green-600">This month</p>
                    </div>
                    <div class="flex flex-col items-end space-y-1">
                        <div
                            class="w-10 h-10 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                            <i data-lucide="trending-up" class="w-5 h-5 text-green-500"></i>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Total Withdrawals -->
            <div
                class="bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 group">
                <div class="flex items-center justify-between">
                    <div class="flex-1">
                        <p class="text-xs font-medium text-gray-500 mb-1">Total Withdrawals</p>
                        <p class="text-lg font-light text-black mb-1" data-balance-target="total-withdrawals"
                            data-balance-amount="0">
                            {{ showAmount($successfulWithdrawals) }}
                        </p>
                        <p class="text-[11px] text-gray-500" data-btc-target="total-withdrawals">—</p>
                        <p class="text-xs text-red-600">This month</p>
                    </div>
                    <div class="flex flex-col items-end space-y-1">
                        <div
                            class="w-10 h-10 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                            <i data-lucide="trending-down" class="w-5 h-5 text-red-500"></i>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Total Investments -->
            <div
                class="bg-white rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 group">
                <div class="flex items-center justify-between">
                    <div class="flex-1">
                        <p class="text-xs font-medium text-gray-500 mb-1">Total Invested</p>
                        <p class="text-lg font-light text-black mb-1" data-balance-target="total-invested"
                            data-balance-amount="0">
                            {{ showAmount($totalInvest) }}
                        </p>
                        <p class="text-[11px] text-gray-500" data-btc-target="total-invested">—</p>
                        <p class="text-xs text-blue-600">Portfolio value</p>
                    </div>
                    <div class="flex flex-col items-end space-y-1">
                        <div
                            class="w-10 h-10 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                            <i data-lucide="pie-chart" class="w-5 h-5 text-blue-500"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Enhanced Recent Transactions -->
        <div class="bg-white rounded-xl p-5 shadow-sm border border-gray-100">
            <div class="flex items-center justify-between mb-4">
                <div>
                    <h3 class="text-lg font-light text-black mb-1">Recent Transactions</h3>
                    <p class="text-xs text-gray-500">Your latest wallet activity</p>
                </div>
                <a href="{{ route('user.transactions') }}"
                    class="text-xs text-black hover:text-gray-600 transition-colors duration-200 font-medium">
                    View All
                    <i data-lucide="arrow-right" class="w-3 h-3 inline ml-1"></i>
                </a>
            </div>

            <div class="space-y-3">
                @forelse($transactions as $transactions)
                    <div
                        class="flex items-center space-x-3 p-3 bg-gray-50 rounded-lg hover:bg-gray-100 transition-colors duration-200 group">
                        <div class="w-10 h-10 flex items-center justify-center">
                            @if ($transactions->trx_type == '+')
                                <i data-lucide="plus" class="w-5 h-5 text-green-500"></i>
                            @else
                                <i data-lucide="minus" class="w-5 h-5 text-red-500"></i>
                            @endif
                        </div>

                        <div class="flex-1 min-w-0">
                            <h4 class="font-medium text-black text-sm truncate">{{ $transactions->remark }}</h4>
                            <p class="text-xs text-gray-600">Bitcoin</p>
                            <p class="text-xs text-gray-500">{{ showDateTime($transactions->created_at, 'd M, Y') }}</p>
                        </div>

                        <div class="text-right">
                            <p
                                class="font-medium @if ($transactions->trx_type == '+') text-green-600 @else text-rose-500 @endif text-sm">
                                {{ $transactions->trx_type }} {{ showAmount($transactions->amount) }}
                            </p>
                            <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium ">
                                @if ($transactions->wallet_type == 'deposit_wallet')
                                    <span
                                        class="text-[9px] font-black px-3 py-1 bg-blue-500/10 text-blue-500 rounded-full border border-blue-500/20 uppercase tracking-widest">@lang('Deposit')</span>
                                @else
                                    <span
                                        class="text-[9px] font-black px-3 py-1 bg-emerald-500/10 text-emerald-500 rounded-full border border-emerald-500/20 uppercase tracking-widest">@lang('Interest')</span>
                                @endif
                            </span>
                        </div>
                    </div>
                @empty
                    <tr>
                        <td class="px-8 py-24 text-center" colspan="100%">
                            <div class="flex flex-col items-center opacity-30">
                                <i data-lucide="database-zap" class="w-12 h-12 mb-4"></i>
                                <p class="text-[10px] font-black uppercase tracking-[0.3em]">
                                    No Transaction Data</p>
                            </div>
                        </td>
                    </tr>
                @endforelse

            </div>
        </div>
    </div>
@endsection
