<?php $__env->startSection('content'); ?>
    <div class="min-h-screen bg-white">
        <!-- Immersive Hero -->
        <header class="relative overflow-hidden bg-gradient-to-br from-black via-gray-900 to-black text-white">
            <svg class="absolute inset-0 opacity-[0.06] z-0 pointer-events-none" xmlns="http://www.w3.org/2000/svg"
                preserveAspectRatio="none" aria-hidden="true" focusable="false">
                <defs>
                    <pattern id="grid" width="40" height="40" patternUnits="userSpaceOnUse">
                        <path d="M 40 0 L 0 0 0 40" fill="none" stroke="white" stroke-width="1" />
                    </pattern>
                </defs>
                <rect width="100%" height="100%" fill="url(#grid)" />
            </svg>

            <div class="absolute inset-0 z-0 pointer-events-none" aria-hidden="true">
                <img src="<?php echo e(getImage(getFilePath('inventory').'/'.$car->image)); ?>"
                    alt="" class="h-full w-full object-cover opacity-20" loading="eager" decoding="async" />
                <div class="absolute inset-0 bg-gradient-to-b from-black/80 via-black/70 to-black/90"></div>
            </div>

            <div class="relative z-10">
                <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8 py-16 lg:py-24 text-center">
                    <h1 class="text-4xl font-semibold tracking-tight sm:text-5xl"><?php echo e($car->name); ?></h1>
                    <p class="mt-4 max-w-2xl mx-auto text-base text-gray-300 sm:text-lg">
                        <?php echo e($car->details); ?>

                        </p>

                    <div class="mt-10 grid grid-cols-1 gap-3 sm:grid-cols-3">
                        <div class="rounded-lg border border-white/10 bg-white/5 p-4">
                            <p class="text-xs text-gray-300">Range (EPA est.)</p>
                            <p class="mt-1 text-2xl font-light text-white"> <?php echo e($car->range); ?> <span class="text-lg">mi</span></p>
                        </div>
                        <div class="rounded-lg border border-white/10 bg-white/5 p-4">
                            <p class="text-xs text-gray-300">Mph </p>
                            <p class="mt-1 text-2xl font-light text-white"><?php echo e($car->mph); ?> <span class="text-lg">s</span></p>
                        </div>
                        <div class="rounded-lg border border-white/10 bg-white/5 p-4">
                            <p class="text-xs text-gray-300">Top Speed</p>
                            <p class="mt-1 text-2xl font-light text-white"> <?php echo e($car->topspeed); ?> <span class="text-lg"></span></p>
                        </div>
                    </div>

                    <div class="mt-8 flex flex-col sm:flex-row justify-center gap-3">
                        <a href="#order"
                            class="inline-flex items-center rounded-md bg-white px-8 py-3 text-sm font-medium text-black transition hover:bg-gray-100">Order
                            Now</a>
                        <a href="#order"
                            class="inline-flex items-center rounded-md border border-white/20 px-8 py-3 text-sm font-medium text-white transition hover:bg-white/10">Learn
                            More</a>
                    </div>
                </div>
            </div>

            <div class="absolute bottom-0 left-0 right-0 translate-y-[1px]" aria-hidden="true">
                <svg viewBox="0 0 1440 80" xmlns="http://www.w3.org/2000/svg">
                    <path fill="#ffffff" fill-opacity="1"
                        d="M0,64L48,69.3C96,75,192,85,288,85.3C384,85,480,75,576,53.3C672,32,768,0,864,0C960,0,1056,32,1152,53.3C1248,75,1344,85,1392,90.7L1440,96L1440,160L1392,160C1344,160,1248,160,1152,160C1050,160,960,160,864,160C768,160,672,160,576,160C480,160,384,160,288,160C192,160,96,160,48,160L0,160Z">
                    </path>
                </svg>
            </div>
        </header>

        <!-- Order Section -->
        <section id="order" class="py-16 bg-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-start">
                    <!-- Left: Image Gallery -->
                    <div class="order-2 lg:order-1">
                        <div class="lg:sticky lg:top-24">
                            <!-- Main Image -->
                            <div class="aspect-w-16 aspect-h-10 mb-6 rounded-xl overflow-hidden border border-gray-200">
                                <img id="main-image"
                                    src="<?php echo e(getImage(getFilePath('inventory').'/'.$car->image)); ?>"
                                    alt="Tesla Model X" class="w-full h-full object-cover transition-opacity duration-300">
                            </div>

                            <!-- Thumbnail Gallery -->
                        </div>
                    </div>

                    <!-- Right: Order Form -->
                    <div class="order-1 lg:order-2">
                        <div class="max-w-lg mx-auto lg:mx-0 border border-gray-200 rounded-2xl p-6 shadow-sm">
                            <!-- Header -->
                            <div class="text-center lg:text-left mb-8">
                                <h2 class="text-3xl lg:text-4xl font-light text-black mb-2">Order Your Tesla Model X</h2>
                                <p class="text-gray-600 font-light">Estimated delivery: 2-4 weeks</p>
                            </div>

                            <!-- Payment Options -->
                            <div class="mb-8">
                                <div class="flex border-b border-gray-200 mb-6">
                                    <button
                                        class="payment-tab flex-1 py-3 text-sm font-medium text-gray-500 border-b border-transparent hover:text-black hover:border-gray-300 transition-colors duration-200"
                                        data-type="cash">Purchase</button>
                                    <button
                                        class="payment-tab flex-1 py-3 text-sm font-medium text-black border-b border-black"
                                        data-type="lease">Lease</button>
                                    <button
                                        class="payment-tab flex-1 py-3 text-sm font-medium text-gray-500 border-b border-transparent hover:text-black hover:border-gray-300 transition-colors duration-200"
                                        data-type="finance">Finance</button>
                                </div>

                                <!-- Pricing Display -->
                                <div class="text-center mb-6">
                                    <div class="text-4xl font-light text-black mb-1">
                                        <span id="price-display"><?php echo e(showAmount($car->lease)); ?></span>
                                        <span id="price-period" class="text-xl text-gray-500">/mo</span>
                                    </div>
                                    <p class="text-sm text-gray-500 font-light" id="price-details">Est. Lease | $7,500 down,
                                        36 months, 10,000 miles</p>
                                </div>

                                <!-- Vehicle Options -->
                                <div class="space-y-3 mb-6">
                                    <div class="vehicle-option border border-black bg-gray-50 p-4 rounded-lg cursor-pointer selected"
                                        data-price="<?php echo e(showAmount($car->finance)); ?>" data-name="All-Wheel Drive">
                                        <div class="flex justify-between items-center">
                                            <span class="font-medium text-black">All-Wheel Drive</span>
                                            <span class="text-gray-700"><?php echo e(showAmount($car->finance)); ?>/mo</span>
                                        </div>
                                    </div>

                                </div>

                                <!-- Features Button -->
                                <button
                                    class="w-full flex items-center justify-between p-4 bg-gray-50 hover:bg-gray-100 border border-gray-200 rounded-lg transition-colors duration-200 mb-6">
                                    <div class="flex items-center space-x-4">
                                        <img src="<?php echo e(getImage(getFilePath('inventory').'/'.$car->image)); ?>"
                                            alt="Features" class="w-12 h-8 object-cover">
                                        <span class="font-medium text-black">View & Compare Features</span>
                                    </div>
                                    <svg class="w-5 h-5 text-gray-500" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 5l7 7-7 7" />
                                    </svg>
                                </button>

                                <!-- Gas Savings -->
                                <div class="flex items-center space-x-3 mb-6">
                                    <input type="checkbox" id="gas-savings"
                                        class="w-4 h-4 text-black border-gray-300 focus:ring-black">
                                    <label for="gas-savings" class="text-sm text-gray-600">Include est. gas savings of
                                        <?php echo e(showAmount($car->finance)); ?>/mo</label>
                                </div>

                                <!-- Action Links -->
                                <div
                                    class="flex flex-wrap justify-center lg:justify-start gap-6 text-sm text-gray-500 mb-8">
                                    <a href="#"
                                        class="hover:text-black underline transition-colors duration-200">Get
                                        Prequalified</a>
                                    <a href="#"
                                        class="hover:text-black underline transition-colors duration-200">Edit Terms &
                                        Savings</a>
                                    <a href="#"
                                        class="hover:text-black underline transition-colors duration-200">Learn About
                                        Financing</a>
                                </div>
                            </div>

                            <?php if($car->soldout != 1): ?>
                            <!-- Order Button -->
                            <div class="space-y-6">
                                <a href="<?php echo e(route('car.buy',$car->id)); ?>"
                                    class="block w-full bg-black hover:bg-gray-800 text-white text-center py-4 px-6 font-medium transition-colors duration-200">
                                    Order Now
                                </a>

                                <p class="text-xs text-gray-500 text-center font-light">
                                    Secure checkout • Free delivery • 30-day return policy
                                </p>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Features Section -->
        <section class="py-16 bg-gray-50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-12">
                    <h2 class="text-3xl lg:text-4xl font-light text-black mb-3">Key Features</h2>
                    <p class="text-gray-600 max-w-2xl mx-auto font-light">Experience cutting-edge technology and
                        unparalleled performance in every aspect of your Tesla Model X.</p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                    <div
                        class="bg-white border border-gray-200 p-6 rounded-xl hover:border-gray-400 transition-colors duration-200">
                        <div class="w-12 h-12 bg-green-100 flex items-center justify-center mb-6">
                            <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M13 10V3L4 14h7v7l9-11h-7z" />
                            </svg>
                        </div>
                        <h3 class="text-xl font-medium text-black mb-3">100% Electric</h3>
                        <p class="text-gray-600 font-light">Zero emissions with instant torque and incredible power
                            delivery.</p>
                    </div>

                    <div
                        class="bg-white border border-gray-200 p-6 rounded-xl hover:border-gray-400 transition-colors duration-200">
                        <div class="w-12 h-12 bg-blue-100 flex items-center justify-center mb-6">
                            <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                        <h3 class="text-xl font-medium text-black mb-3">Autopilot</h3>
                        <p class="text-gray-600 font-light">Advanced driver assistance features for enhanced safety and
                            convenience.</p>
                    </div>

                    <div
                        class="bg-white border border-gray-200 p-6 rounded-xl hover:border-gray-400 transition-colors duration-200">
                        <div class="w-12 h-12 bg-purple-100 flex items-center justify-center mb-6">
                            <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                            </svg>
                        </div>
                        <h3 class="text-xl font-medium text-black mb-3">Advanced Security</h3>
                        <p class="text-gray-600 font-light">Comprehensive security system with Sentry Mode protection.</p>
                    </div>

                    <div
                        class="bg-white border border-gray-200 p-6 rounded-xl hover:border-gray-400 transition-colors duration-200">
                        <div class="w-12 h-12 bg-red-100 flex items-center justify-center mb-6">
                            <svg class="w-6 h-6 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                            </svg>
                        </div>
                        <h3 class="text-xl font-medium text-black mb-3">Premium Interior</h3>
                        <p class="text-gray-600 font-light">Luxurious materials and cutting-edge technology throughout.</p>
                    </div>
                </div>
            </div>
        </section>

        <!-- Specifications Section -->
        <section class="py-16 bg-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-12">
                    <h2 class="text-3xl lg:text-4xl font-light text-black mb-3">Specifications</h2>
                    <p class="text-gray-600 max-w-2xl mx-auto font-light">Detailed technical specifications for your Tesla
                        Model X.</p>
                </div>

                <div class="max-w-4xl mx-auto">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-12">
                        <div>
                            <h3 class="text-xl font-medium text-black mb-8">Performance</h3>
                            <div class="space-y-6">
                                <div class="flex justify-between py-4 border-b border-gray-200">
                                    <span class="text-gray-600">Acceleration</span>
                                    <span class="font-medium text-black"><?php echo e($car->mph); ?></span>
                                </div>
                                <div class="flex justify-between py-4 border-b border-gray-200">
                                    <span class="text-gray-600">Top Speed</span>
                                    <span class="font-medium text-black"><?php echo e($car->topspeed); ?></span>
                                </div>
                                <div class="flex justify-between py-4 border-b border-gray-200">
                                    <span class="text-gray-600">Range</span>
                                    <span class="font-medium text-black"><?php echo e($car->range); ?> (EPA est.)</span>
                                </div>
                                <div class="flex justify-between py-4 border-b border-gray-200">
                                    <span class="text-gray-600">Drive</span>
                                    <span class="font-medium text-black">All-Wheel Drive</span>
                                </div>
                            </div>
                        </div>

                        <div>
                            <h3 class="text-xl font-medium text-black mb-8">Vehicle Details</h3>
                            <div class="space-y-6">
                                <div class="flex justify-between py-4 border-b border-gray-200">
                                    <span class="text-gray-600">Make</span>
                                    <span class="font-medium text-black">Tesla</span>
                                </div>
                                <div class="flex justify-between py-4 border-b border-gray-200">
                                    <span class="text-gray-600">Model</span>
                                    <span class="font-medium text-black"><?php echo e($car->name); ?></span>
                                </div>
                                <div class="flex justify-between py-4 border-b border-gray-200">
                                    <span class="text-gray-600">Year</span>
                                    <span class="font-medium text-black"><?php echo e($car->year); ?></span>
                                </div>
                                <div class="flex justify-between py-4 border-b border-gray-200">
                                    <span class="text-gray-600">Color</span>
                                    <span class="font-medium text-black"><?php echo e($car->color); ?></span>
                                </div>
                                <div class="flex justify-between py-4 border-b border-gray-200">
                                    <span class="text-gray-600">Transmission</span>
                                    <span class="font-medium text-black">Automatic</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <?php $__env->startPush('script'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            let currentPrice = 36000.00;
            let currentPaymentType = 'lease';
            const gasSavings = 108;

            // Payment tab functionality
            const paymentTabs = document.querySelectorAll('.payment-tab');
            const vehicleOptions = document.querySelectorAll('.vehicle-option');
            const gasSavingsCheckbox = document.getElementById('gas-savings');

            function updatePriceDisplay() {
                const priceDisplay = document.getElementById('price-display');
                const pricePeriod = document.getElementById('price-period');
                const priceDetails = document.getElementById('price-details');

                let displayPrice = currentPrice;
                let period = '';
                let details = '';

                if (currentPaymentType === 'cash') {
                    period = '';
                    details = 'Est. Purchase Price';
                } else {
                    displayPrice = Math.round(currentPrice / 36);
                    if (gasSavingsCheckbox.checked) {
                        displayPrice -= gasSavings;
                    }
                    period = '/mo';
                    details = currentPaymentType === 'lease' ?
                        'Est. Lease | $7,500 down, 36 months, 10,000 miles' :
                        'Est. Finance | $7,500 down, 36 months';
                }

                priceDisplay.textContent = '$' + displayPrice.toLocaleString();
                pricePeriod.textContent = period;
                priceDetails.textContent = details;
            }

            // Payment tab event listeners
            paymentTabs.forEach(tab => {
                tab.addEventListener('click', function() {
                    paymentTabs.forEach(t => {
                        t.classList.remove('text-black', 'border-black');
                        t.classList.add('text-gray-500', 'border-transparent');
                    });

                    this.classList.add('text-black', 'border-black');
                    this.classList.remove('text-gray-500', 'border-transparent');

                    currentPaymentType = this.dataset.type;
                    updatePriceDisplay();
                });
            });

            // Vehicle option event listeners
            vehicleOptions.forEach(option => {
                option.addEventListener('click', function() {
                    vehicleOptions.forEach(opt => {
                        opt.classList.remove('border-black', 'bg-gray-50', 'selected');
                        opt.classList.add('border-gray-200');
                    });

                    this.classList.add('border-black', 'bg-gray-50', 'selected');
                    this.classList.remove('border-gray-200');

                    currentPrice = parseInt(this.dataset.price);
                    updatePriceDisplay();
                });
            });

            // Gas savings checkbox
            if (gasSavingsCheckbox) {
                gasSavingsCheckbox.addEventListener('change', updatePriceDisplay);
            }

            // Image gallery functionality
            window.changeImage = function(src) {
                const mainImage = document.getElementById('main-image');
                const thumbnails = document.querySelectorAll('.thumbnail');

                if (mainImage) {
                    mainImage.style.opacity = '0.5';
                    setTimeout(() => {
                        mainImage.src = src;
                        mainImage.style.opacity = '1';
                    }, 150);
                }

                thumbnails.forEach(thumb => {
                    thumb.classList.remove('border-black');
                    thumb.classList.add('border-gray-200');
                });

                event.target.closest('.thumbnail').classList.add('border-black');
                event.target.closest('.thumbnail').classList.remove('border-gray-200');
            };

            // Smooth scrolling for anchor links
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function(e) {
                    e.preventDefault();
                    const target = document.querySelector(this.getAttribute('href'));
                    if (target) {
                        target.scrollIntoView({
                            behavior: 'smooth',
                            block: 'start'
                        });
                    }
                });
            });

            // Initialize price display
            updatePriceDisplay();
        });
    </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Template::layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/cars/details.blade.php ENDPATH**/ ?>