<div class="glass-vault border border-slate-200 dark:border-white/10 bg-white/50 dark:bg-slate-900/50 backdrop-blur-xl rounded-xl overflow-hidden shadow-sm">
        <div class="overflow-x-auto">
            <table class="w-full text-left border-collapse">
                <thead>
                    <tr class="bg-slate-50 dark:bg-white/5 border-b border-slate-200 dark:border-white/10">
                        <th class="px-6 py-4 text-[10px] font-black uppercase tracking-widest text-slate-500"><?php echo app('translator')->get('Asset Plan'); ?></th>
                        <th class="px-6 py-4 text-[10px] font-black uppercase tracking-widest text-slate-500"><?php echo app('translator')->get('Return Setup'); ?></th>
                        <th class="px-6 py-4 text-[10px] font-black uppercase tracking-widest text-slate-500"><?php echo app('translator')->get('Yield Status'); ?></th>
                        <th class="px-6 py-4 text-[10px] font-black uppercase tracking-widest text-slate-500"><?php echo app('translator')->get('Next Payout'); ?></th>
                        <th class="px-6 py-4 text-[10px] font-black uppercase tracking-widest text-slate-500 text-right"><?php echo app('translator')->get('Terminal'); ?></th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-slate-100 dark:divide-white/5">
                    <?php $__empty_1 = true; $__currentLoopData = $invests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-slate-50/80 dark:hover:bg-white/[0.02] transition-colors group">
                            <td class="px-6 py-5">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 rounded-lg bg-slate-900 dark:bg-white/10 flex items-center justify-center shrink-0">
                                        <i data-lucide="bar-chart-3" class="w-5 h-5 text-slate-400"></i>
                                    </div>
                                    <div class="flex flex-col">
                                        <span class="text-sm font-bold text-slate-900 dark:text-white uppercase"><?php echo e(__($invest->plan->name)); ?></span>
                                        <span class="text-xs font-medium text-slate-500"><?php echo e(showAmount($invest->amount)); ?></span>
                                    </div>
                                </div>
                            </td>

                            <td class="px-6 py-5">
                                <div class="flex flex-col">
                                    <span class="text-sm font-bold text-slate-700 dark:text-slate-300">
                                        <?php echo e(showAmount($invest->interest)); ?> <span class="text-[10px] text-slate-400 uppercase">/ <?php echo e($invest->time_name); ?></span>
                                    </span>
                                    <span class="text-[10px] font-medium text-slate-400 mt-0.5">
                                        <?php if($invest->period == '-1'): ?> <?php echo app('translator')->get('Lifetime'); ?> <?php else: ?> <?php echo e($invest->period); ?> cycles <?php endif; ?>
                                        <?php if($invest->capital_status == '1'): ?> + <?php echo app('translator')->get('Capital'); ?> <?php endif; ?>
                                    </span>
                                </div>
                            </td>

                            <td class="px-6 py-5">
                                <div class="flex flex-col">
                                    <div class="flex justify-between items-end mb-1">
                                        <span class="text-[10px] font-black text-slate-400 uppercase tracking-tighter"><?php echo app('translator')->get('Received'); ?></span>
                                        <span class="text-[10px] font-black text-emerald-500"><?php echo e($invest->return_rec_time); ?> Cycles</span>
                                    </div>
                                    <span class="text-sm font-black text-slate-900 dark:text-white"><?php echo e(showAmount($invest->paid)); ?></span>
                                </div>
                            </td>

                            <td class="px-6 py-5 min-w-[180px]">
                                <?php if($invest->status == 1): ?>
                                    <div class="flex flex-col gap-2">
                                        <div class="flex items-center gap-2">
                                            <i data-lucide="clock" class="w-3 h-3 text-emerald-500"></i>
                                            <span id="counter<?php echo e($invest->id); ?>" class="text-[11px] font-black text-slate-900 dark:text-white font-mono tracking-tighter uppercase"></span>
                                        </div>
                                        
                                        <?php
                                            $start = $invest->last_time ?? $invest->created_at;
                                            $percent = diffDatePercent($start, $invest->next_time);
                                        ?>
                                        <div class="w-full bg-slate-200 dark:bg-white/10 rounded-full h-1.5 overflow-hidden">
                                            <div class="bg-emerald-500 h-full rounded-full transition-all duration-700" style="width: <?php echo e($percent); ?>%"></div>
                                        </div>
                                    </div>
                                <?php elseif($invest->status == 2): ?>
                                    <span class="px-3 py-1 rounded-md bg-rose-500/10 text-rose-500 text-[10px] font-black uppercase"><?php echo app('translator')->get('Canceled'); ?></span>
                                <?php else: ?>
                                    <div class="flex items-center gap-2 text-emerald-500">
                                        <i data-lucide="check-circle-2" class="w-4 h-4"></i>
                                        <span class="text-[10px] font-black uppercase"><?php echo app('translator')->get('Completed'); ?></span>
                                    </div>
                                <?php endif; ?>
                            </td>

                            <td class="px-6 py-5 text-right">
                                <div class="flex items-center justify-end gap-2">
                                    <a href="<?php echo e(route('user.invest.details', encrypt($invest->id))); ?>" class="p-2 rounded-lg border border-slate-200 dark:border-white/10 text-slate-500 hover:bg-slate-900 hover:text-white dark:hover:bg-white dark:hover:text-slate-900 transition-all shadow-sm">
                                        <i data-lucide="maximize-2" class="w-4 h-4"></i>
                                    </a>
                                    <?php if($invest->eligibleCapitalBack()): ?>
                                        <button class="manageCapital p-2 rounded-lg border border-slate-200 dark:border-white/10 text-emerald-500 hover:bg-emerald-500 hover:text-white transition-all shadow-sm" data-id="<?php echo e($invest->id); ?>">
                                            <i data-lucide="hand-coins" class="w-4 h-4"></i>
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>

                        <?php if($invest->status == 1 && \Carbon\Carbon::parse($invest->next_time) > now()): ?>
                            <script>
                                createCountDown('counter<?php echo e($invest->id); ?>', <?php echo e(abs(\Carbon\Carbon::parse($invest->next_time)->diffInSeconds())); ?>);
                            </script>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="100%" class="px-6 py-20 text-center">
                                <div class="flex flex-col items-center justify-center text-slate-400">
                                    <i data-lucide="inbox" class="w-10 h-10 mb-4 opacity-20"></i>
                                    <p class="text-[10px] font-black uppercase tracking-widest"><?php echo e(__($emptyMessage)); ?></p>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    
    <?php if($invests->hasPages()): ?>
        <div class="mt-8">
            <?php echo e(paginateLinks($invests)); ?>

        </div>
    <?php endif; ?>
     


<div id="capitalModal" class="hidden fixed inset-0 z-[9999] flex items-center justify-center p-4">
    <div class="absolute inset-0 bg-slate-900/60 backdrop-blur-sm opacity-0 transition-opacity duration-300" id="capitalBackdrop"></div>
    <div class="relative w-full max-w-md bg-white dark:bg-slate-900 rounded-xl border border-slate-200 dark:border-white/10 shadow-2xl overflow-hidden transform scale-95 opacity-0 transition-all duration-300" id="capitalContent">
        <div class="p-6 border-b border-slate-100 dark:border-white/5 flex justify-between items-center bg-slate-50/50 dark:bg-slate-800/30">
            <h2 class="text-[11px] font-black text-slate-900 dark:text-white uppercase tracking-widest"><?php echo app('translator')->get('Capital Terminal'); ?></h2>
            <button type="button" class="closeCapital text-slate-400 hover:text-slate-900 dark:hover:text-white transition-colors">
                <i data-lucide="x" class="w-5 h-5"></i>
            </button>
        </div>
        <form action="<?php echo e(route('user.invest.capital.manage')); ?>" method="post" class="m-0">
            <?php echo csrf_field(); ?>
            <div class="p-8">
                <input type="hidden" name="invest_id">
                <div class="space-y-2">
                    <label class="text-[10px] font-black text-slate-400 uppercase ml-1"><?php echo app('translator')->get('Withdrawal / Reinvest Strategy'); ?></label>
                    <select name="capital" class="w-full bg-slate-50 dark:bg-slate-800 border border-slate-200 dark:border-white/5 rounded-lg p-3 text-sm font-bold focus:ring-2 focus:ring-emerald-500 transition-all outline-none text-slate-900 dark:text-white">
                        <option value="reinvest"><?php echo app('translator')->get('Reinvest Principal'); ?></option>
                        <option value="capital_back"><?php echo app('translator')->get('Capital Back to Wallet'); ?></option>
                    </select>
                </div>
            </div>
            <div class="p-6 bg-slate-50/50 dark:bg-slate-800/30 flex gap-3">
                <button type="button" class="closeCapital flex-1 py-3 text-[10px] font-black uppercase text-slate-500"><?php echo app('translator')->get('Cancel'); ?></button>
                <button type="submit" class="flex-[2] py-3 bg-slate-900 dark:bg-white text-white dark:text-slate-900 rounded-lg text-[10px] font-black uppercase tracking-widest shadow-lg hover:bg-emerald-600 dark:hover:bg-emerald-500 transition-colors"><?php echo app('translator')->get('Process Strategy'); ?></button>
            </div>
        </form>
    </div>
</div> 

<?php $__env->startPush('script'); ?>
<script src="https://unpkg.com/lucide@latest"></script>
<script>
    "use strict";

    // Global store for countdowns
    const countdowns = [];

    function createCountDown(elementId, sec) {
        let tms = sec;
        let x = setInterval(function() {
            let distance = tms * 1000;
            
            let days = Math.floor(distance / (1000 * 60 * 60 * 24));
            let hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            let minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            let seconds = Math.floor((distance % (1000 * 60)) / 1000);
            
            let element = document.getElementById(elementId);
            if(element) {
                element.innerHTML = days + "D " + hours + "H " + minutes + "M " + seconds + "S";
                
                if (distance < 0) {
                    clearInterval(x);
                    element.innerHTML = "SETTLING...";
                    element.classList.add('text-emerald-500');
                }
            } else {
                // If element is not found, stop the interval to save memory
                clearInterval(x);
            }
            tms--;
        }, 1000);
    }

    // Capture all active investments from Blade
    <?php $__currentLoopData = $invests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($invest->status == 1 && \Carbon\Carbon::parse($invest->next_time) > now()): ?>
            countdowns.push({
                id: 'counter<?php echo e($invest->id); ?>',
                seconds: <?php echo e(abs(\Carbon\Carbon::parse($invest->next_time)->diffInSeconds())); ?>

            });
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    $(document).ready(function() {
        lucide.createIcons();

        // Start all countdowns ONLY after document is ready
        countdowns.forEach(item => {
            createCountDown(item.id, item.seconds);
        });
    });
</script>
<script>
    "use strict";

     

    (function($) {
        // Init Lucide Icons
        lucide.createIcons();

        const modal = $('#capitalModal');
        const backdrop = $('#capitalBackdrop');
        const content = $('#capitalContent');

        // Modal Logic
        $('.manageCapital').on('click', function() {
            modal.find('[name=invest_id]').val($(this).data('id'));
            modal.removeClass('hidden').addClass('flex');
            setTimeout(() => {
                backdrop.removeClass('opacity-0').addClass('opacity-100');
                content.removeClass('opacity-0 scale-95').addClass('opacity-100 scale-100');
            }, 10);
        });

        function closeCapitalModal() {
            backdrop.removeClass('opacity-100').addClass('opacity-0');
            content.removeClass('opacity-100 scale-100').addClass('opacity-0 scale-95');
            setTimeout(() => modal.addClass('hidden').removeClass('flex'), 300);
        }

        $('.closeCapital, #capitalBackdrop').on('click', closeCapitalModal);

    })(jQuery);
</script>
<?php $__env->stopPush(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/partials/invest_history.blade.php ENDPATH**/ ?>