<?php $__env->startSection('content'); ?>
<div style="padding: 1.5rem; margin: 0 auto; max-width: 1600px; font-family: 'Inter', system-ui, sans-serif; min-height: 100vh;">
    
    <div style="background: linear-gradient(135deg, #000000 0%, #111827 50%, #1f2937 100%); border-radius: 1.5rem; padding: 2.5rem; margin-bottom: 2.5rem; color: #ffffff; position: relative; overflow: hidden; box-shadow: 0 20px 25px -5px rgba(0,0,0,0.1);">
        <div style="position: absolute; inset: 0; opacity: 0.1; pointer-events: none;">
            <div style="position: absolute; top: 0; right: 0; width: 15rem; height: 15rem; background: #ffffff; border-radius: 50%; transform: translate(7rem, -7rem);"></div>
            <div style="position: absolute; bottom: 0; left: 0; width: 8rem; height: 8rem; background: #ffffff; border-radius: 50%; transform: translate(-4rem, 4rem);"></div>
        </div>

        <div style="position: relative; z-index: 10; display: flex; flex-wrap: wrap; justify-content: space-between; align-items: center; gap: 2rem;">
            <div>
                <h1 style="font-size: 1.75rem; font-weight: 300; margin: 0; letter-spacing: -0.02em;"><?php echo app('translator')->get('Support Terminal'); ?></h1>
                <p style="color: #9ca3af; font-size: 0.875rem; margin-top: 0.5rem; font-weight: 400;"><?php echo app('translator')->get('Interface with our global technical protocols'); ?></p>
                
                <div style="margin-top: 2rem;">
                    <a href="<?php echo e(route('ticket.open')); ?>" style="display: inline-flex; align-items: center; gap: 0.75rem; padding: 0.85rem 1.75rem; background: #ffffff; color: #000000; border-radius: 1rem; font-size: 11px; font-weight: 900; text-transform: uppercase; letter-spacing: 0.1em; text-decoration: none; transition: transform 0.2s ease;" onmouseover="this.style.transform='translateY(-2px)'" onmouseout="this.style.transform='translateY(0)'">
                        <?php echo app('translator')->get('New Transmission'); ?>
                        <i data-lucide="send" style="width: 14px; height: 14px;"></i>
                    </a>
                </div>
            </div>

            <div style="background: rgba(255, 255, 255, 0.1); backdrop-filter: blur(20px); -webkit-backdrop-filter: blur(20px); border-radius: 1.25rem; padding: 1.5rem; border: 1px solid rgba(255, 255, 255, 0.15); box-shadow: 0 10px 15px -3px rgba(0,0,0,0.2); min-width: 240px;">
                <div style="display: flex; align-items: center; justify-content: space-between;">
                    <div>
                        <p style="font-size: 0.7rem; color: #94a3b8; margin-bottom: 0.25rem; text-transform: uppercase; letter-spacing: 0.15em;"><?php echo app('translator')->get('Active Requests'); ?></p>
                        <p style="font-size: 2rem; font-weight: 300; margin: 0;"><?php echo e($supports->count()); ?></p>
                    </div>
                    <div style="width: 3rem; height: 3rem; background: rgba(59, 130, 246, 0.2); border-radius: 1rem; display: flex; align-items: center; justify-content: center;">
                        <i data-lucide="message-square" style="width: 1.5rem; height: 1.5rem; color: #60a5fa;"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div style="background: #ffffff; border-radius: 1.5rem; border: 1px solid #e5e7eb; overflow: hidden; box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05);">
        <div style="padding: 1.5rem 2rem; border-bottom: 1px solid #f3f4f6; display: flex; justify-content: space-between; align-items: center;">
            <h3 style="font-size: 0.75rem; font-weight: 900; color: #64748b; text-transform: uppercase; letter-spacing: 0.2em; margin: 0;"><?php echo app('translator')->get('Communication Ledger'); ?></h3>
        </div>

        <div style="overflow-x: auto;">
            <table style="width: 100%; border-collapse: collapse; min-width: 900px;">
                <thead>
                    <tr style="background: #f9fafb; text-align: left;">
                        <th style="padding: 1.25rem 2rem; font-size: 10px; font-weight: 900; color: #94a3b8; text-transform: uppercase; letter-spacing: 0.1em;"><?php echo app('translator')->get('Subject & Token'); ?></th>
                        <th style="padding: 1.25rem 1rem; font-size: 10px; font-weight: 900; color: #94a3b8; text-transform: uppercase; letter-spacing: 0.1em; text-align: center;"><?php echo app('translator')->get('Status'); ?></th>
                        <th style="padding: 1.25rem 1rem; font-size: 10px; font-weight: 900; color: #94a3b8; text-transform: uppercase; letter-spacing: 0.1em; text-align: center;"><?php echo app('translator')->get('Priority'); ?></th>
                        <th style="padding: 1.25rem 1rem; font-size: 10px; font-weight: 900; color: #94a3b8; text-transform: uppercase; letter-spacing: 0.1em; text-align: center;"><?php echo app('translator')->get('Last Activity'); ?></th>
                        <th style="padding: 1.25rem 2rem; font-size: 10px; font-weight: 900; color: #94a3b8; text-transform: uppercase; letter-spacing: 0.1em; text-align: right;"><?php echo app('translator')->get('Interface'); ?></th>
                    </tr>
                </thead>
                <tbody style="font-size: 13px;">
                    <?php $__empty_1 = true; $__currentLoopData = $supports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $support): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr style="border-bottom: 1px solid #f3f4f6; transition: all 0.2s;" onmouseover="this.style.background='#fcfcfc'" onmouseout="this.style.background='transparent'">
                            
                            <td style="padding: 1.5rem 2rem;">
                                <div style="display: flex; flex-direction: column; gap: 4px;">
                                    <span style="font-family: monospace; font-size: 10px; font-weight: 700; color: #3b82f6; text-transform: uppercase;">#<?php echo e($support->ticket); ?></span>
                                    <a href="<?php echo e(route('ticket.view', $support->ticket)); ?>" style="text-decoration: none; color: #0f172a; font-weight: 700; font-size: 13px; letter-spacing: -0.01em;"><?php echo e(__($support->subject)); ?></a>
                                </div>
                            </td>

                            
                            <td style="padding: 1.5rem 1rem; text-align: center;">
                                <div class="status-badge-wrapper" style="display: inline-block;">
                                    <?php echo $support->statusBadge; ?>
                                </div>
                            </td>

                            
                            <td style="padding: 1.5rem 1rem; text-align: center;">
                                <div class="priority-badge-wrapper" style="display: inline-block;">
                                    <?php echo $support->priorityBadge; ?>
                                </div>
                            </td>

                            
                            <td style="padding: 1.5rem 1rem; text-align: center;">
                                <span style="font-size: 11px; font-weight: 800; color: #64748b; text-transform: uppercase;"><?php echo e(diffForHumans($support->last_reply)); ?></span>
                            </td>

                            
                            <td style="padding: 1.5rem 2rem; text-align: right;">
                                <a href="<?php echo e(route('ticket.view', $support->ticket)); ?>" style="display: inline-flex; align-items: center; justify-content: center; width: 36px; height: 36px; background: #f1f5f9; color: #64748b; border-radius: 10px; text-decoration: none; transition: all 0.2s;" onmouseover="this.style.background='#000'; this.style.color='#fff'" onmouseout="this.style.background='#f1f5f9'; this.style.color='#64748b'">
                                    <i data-lucide="terminal" style="width: 16px; height: 16px;"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" style="padding: 6rem 2rem; text-align: center;">
                                <div style="display: flex; flex-direction: column; align-items: center; opacity: 0.3;">
                                    <i data-lucide="inbox" style="width: 3rem; height: 3rem; margin-bottom: 1rem;"></i>
                                    <p style="font-size: 11px; font-weight: 900; text-transform: uppercase; letter-spacing: 0.2em;"><?php echo e(__($emptyMessage)); ?></p>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        <div style="height: 4px; background: linear-gradient(90deg, #10b981, #3b82f6, #6366f1);"></div>
    </div>

    <?php if($supports->hasPages()): ?>
        <div style="margin-top: 2rem; display: flex; justify-content: flex-end;">
            <?php echo e(paginateLinks($supports)); ?>

        </div>
    <?php endif; ?>
</div>

<style>
    /* Integration with Terminal Badge Styles */
    .status-badge-wrapper .badge,
    .priority-badge-wrapper .badge {
        padding: 5px 12px !important;
        font-size: 9px !important;
        font-weight: 900 !important;
        text-transform: uppercase !important;
        letter-spacing: 0.05em !important;
        border-radius: 8px !important;
        border: 1px solid transparent !important;
    }

    .badge.bg--success { background: rgba(16, 185, 129, 0.1) !important; color: #10b981 !important; border-color: rgba(16, 185, 129, 0.2) !important; }
    .badge.bg--primary { background: rgba(59, 130, 246, 0.1) !important; color: #3b82f6 !important; border-color: rgba(59, 130, 246, 0.2) !important; }
    .badge.bg--warning { background: rgba(245, 158, 11, 0.1) !important; color: #f59e0b !important; border-color: rgba(245, 158, 11, 0.2) !important; }
    .badge.bg--danger { background: rgba(239, 68, 68, 0.1) !important; color: #ef4444 !important; border-color: rgba(239, 68, 68, 0.2) !important; }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('Template::layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/user/support/index.blade.php ENDPATH**/ ?>