<?php
    $preloader = getContent('preloader.content', true);
?>
<!doctype html>
<html lang="<?php echo e(config('app.locale')); ?>" itemscope itemtype="http://schema.org/WebPage">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> <?php echo e(gs()->siteName(__($pageTitle))); ?></title>
    <?php echo $__env->make('partials.seo', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:300,400,500,600,700&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    <link rel="preload" as="style" href="<?php echo e(asset('assets/frontend/build/assets/app-Cf1VUFo0.css')); ?>" />
    <link rel="modulepreload" as="script" href="<?php echo e(asset('assets/frontend/build/assets/app-C7QjXGVt.js')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/build/assets/app-Cf1VUFo0.css')); ?>" />
    <script type="module" src="<?php echo e(asset('assets/frontend/build/assets/app-C7QjXGVt.js')); ?>"></script>

    <?php echo $__env->yieldPushContent('style-lib'); ?>

    <?php echo $__env->yieldPushContent('style'); ?>

</head>

<?php echo loadExtension('google-analytics') ?>

<body class="font-sans antialiased bg-gray-50 text-black">

    <?php echo $__env->yieldPushContent('fbComment'); ?>
    <div class="min-h-screen flex flex-col">
        <?php echo $__env->yieldContent('panel'); ?>
    </div>

    <?php echo $__env->yieldPushContent('script-lib'); ?>
    <?php echo loadExtension('tawk-chat') ?>
    <?php echo $__env->make('partials.notify', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <?php if(gs('pn')): ?>
        <?php echo $__env->make('partials.push_script', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php endif; ?>
    <?php echo $__env->yieldPushContent('script'); ?>
</body>

</html>
<?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/layouts/app.blade.php ENDPATH**/ ?>