<?php
    $calculationCaption = getContent('calculation.content', true);
    $planList = \App\Models\Plan::whereHas('timeSetting', function ($time) {
        $time->where('status', 1);
    })
    ->where('status', 1)
    ->orderBy('id', 'desc')
    ->get();
?>

<section class="py-32 bg-[#FDFDFD] dark:bg-slate-950 relative overflow-hidden">
    <div class="absolute inset-0 opacity-[0.03] dark:opacity-[0.05] pointer-events-none" 
         style="background-image: linear-gradient(#000 1px, transparent 1px), linear-gradient(90deg, #000 1px, transparent 1px); background-size: 40px 40px;"></div>

    <div class="container mx-auto px-6 relative z-10">
        
        <div class="max-w-3xl mb-20">
            <div class="flex items-center gap-3 mb-4">
                <span class="px-2 py-0.5 bg-emerald-500/10 text-emerald-500 text-[9px] font-black uppercase tracking-widest rounded">Real-Time</span>
                <span class="text-[9px] font-black text-slate-400 uppercase tracking-[0.4em]">Projection Engine v.2.0</span>
            </div>
            <h2 class="text-5xl md:text-6xl font-black text-slate-900 dark:text-white uppercase tracking-tighter leading-none mb-6">
                <?php echo e(__(@$calculationCaption->data_values->heading_w)); ?> <span class="text-emerald-500"><?php echo e(__(@$calculationCaption->data_values->heading_c)); ?></span>
            </h2>
            <p class="text-lg text-slate-500 dark:text-slate-400 font-medium max-w-xl">
                <?php echo e(__(@$calculationCaption->data_values->sub_heading)); ?>

            </p>
        </div>

        <div class="max-w-5xl mx-auto">
            <div class="bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/5 rounded-[2.5rem] overflow-hidden shadow-2xl shadow-slate-900/5">
                <div class="grid lg:grid-cols-2">
                    
                    <div class="p-10 lg:p-14 border-b lg:border-b-0 lg:border-r border-slate-100 dark:border-white/5">
                        <form class="space-y-8">
                            <div class="space-y-3">
                                <label class="text-[10px] font-black text-slate-400 uppercase tracking-[0.2em] ml-1">Execution Plan</label>
                                <div class="relative">
                                    <select id="changePlan" class="w-full bg-slate-50 dark:bg-slate-950 border border-slate-200 dark:border-white/10 p-5 rounded-2xl text-slate-900 dark:text-white font-bold text-sm appearance-none outline-none focus:border-emerald-500 transition-all">
                                        <?php $__currentLoopData = $planList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($data->id); ?>" data-fixed_amount="<?php echo e($data->fixed_amount); ?>" data-minimum_amount="<?php echo e($data->minimum); ?>" data-maximum_amount="<?php echo e($data->maximum); ?>"> 
                                                <?php echo e(__($data->name)); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div class="absolute right-5 top-1/2 -translate-y-1/2 pointer-events-none opacity-50">
                                        <i data-lucide="chevron-down" class="w-4 h-4 text-slate-400"></i>
                                    </div>
                                </div>
                            </div>

                            <div class="space-y-3">
                                <div class="flex justify-between items-end ml-1">
                                    <label class="text-[10px] font-black text-slate-400 uppercase tracking-[0.2em]">Investment Capital</label>
                                    <span class="invest-range text-[9px] font-bold text-emerald-500 uppercase italic"></span>
                                </div>
                                <div class="relative">
                                    <span class="absolute left-5 top-1/2 -translate-y-1/2 text-slate-400 font-mono"><?php echo e(gs('cur_sym')); ?></span>
                                    <input type="text" placeholder="0.00" class="invest-input w-full bg-slate-50 dark:bg-slate-950 border border-slate-200 dark:border-white/10 p-5 pl-10 rounded-2xl text-slate-900 dark:text-white font-mono font-bold text-lg outline-none focus:border-emerald-500 transition-all" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')">
                                </div>
                            </div>
                        </form>
                    </div>

                    <div class="p-10 lg:p-14 bg-slate-50/50 dark:bg-white/[0.01] flex flex-col justify-center">
                        <div class="space-y-10">
                            <div>
                                <p class="text-[10px] font-black text-slate-400 uppercase tracking-[0.2em] mb-4">Projected Profit Yield</p>
                                <div class="profit-input text-4xl md:text-5xl font-black text-emerald-500 tracking-tighter italic min-h-[1em]">
                                    </div>
                            </div>

                            <div class="pt-8 border-t border-slate-200 dark:border-white/10 flex items-center justify-between">
                                <div>
                                    <p class="text-[9px] font-black text-slate-400 uppercase tracking-widest mb-1">Net Earnings</p>
                                    <p class="period text-xl font-black text-slate-900 dark:text-white italic tracking-tight"></p>
                                </div>
                                <div class="w-12 h-12 rounded-full bg-emerald-500/10 flex items-center justify-center">
                                    <i data-lucide="trending-up" class="text-emerald-500 w-6 h-6"></i>
                                </div>
                            </div>

                            <p class="text-[9px] font-medium text-slate-400 leading-relaxed italic">
                                *Projections are based on current neural node performance. Actual settlements may vary based on market volatility index.
                            </p>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $(document).ready(function() {
                // Initialize Lucide icons if you're using them
                if (typeof lucide !== 'undefined') { lucide.createIcons(); }

                var curSym = '<?php echo e(gs('cur_sym')); ?>';
                $("#changePlan").on('change', function() {
                    var selectedPlan = $('#changePlan').find(':selected');
                    var planId = selectedPlan.val();
                    var data = selectedPlan.data();
                    var fixedAmount = parseFloat(data.fixed_amount).toFixed(2);
                    var minimumAmount = parseFloat(data.minimum_amount).toFixed(2);
                    var maximumAmount = parseFloat(data.maximum_amount).toFixed(2);

                    if (fixedAmount > 0) {
                        $('.invest-input').val(fixedAmount);
                        $('.invest-input').attr('readonly', true).addClass('opacity-60 cursor-not-allowed');
                        $('.invest-range').text('Fixed Amount');
                    } else {
                        $('.invest-input').val(minimumAmount);
                        $('.invest-input').attr('readonly', false).removeClass('opacity-60 cursor-not-allowed');
                        $('.invest-range').text('Range: ' + curSym + minimumAmount + ' - ' + curSym + maximumAmount);
                    }

                    var investAmount = $('.invest-input').val();
                    if (investAmount != '' && planId != null) {
                        ajaxPlanCalc(planId, investAmount)
                    }
                }).change();

                $(".invest-input").on('keyup change', function() {
                    var planId = $("#changePlan option:selected").val();
                    var investAmount = $(this).val();
                    if (investAmount != '' && planId != null) {
                        ajaxPlanCalc(planId, investAmount)
                    }
                });
            });

            function ajaxPlanCalc(planId, investAmount) {
                $.ajax({
                    url: "<?php echo e(route('planCalculator')); ?>",
                    type: "post",
                    data: {
                        planId,
                        _token: '<?php echo e(csrf_token()); ?>',
                        investAmount
                    },
                    success: function(response) {
                        if (response.errors) {
                            // Professional clean error handling
                            console.error(response.errors);
                        } else {
                            // Smoothly update the text
                            $('.profit-input').fadeOut(100, function() {
                                $(this).text(response.description).fadeIn(100);
                            });
                            
                            if (response.netProfit) {
                                $('.period').text(curSym + response.netProfit);
                            }
                        }
                    }
                });
            }
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/sections/calculation.blade.php ENDPATH**/ ?>