<?php
    $weAcceptContent = getContent('we_accept.content', true);
    $methods = getContent('we_accept.element', false, null, true);
?>

<section class="py-24 bg-white dark:bg-slate-950 overflow-hidden relative">
    <div class="absolute top-0 inset-x-0 h-px bg-gradient-to-r from-transparent via-slate-200 dark:via-white/10 to-transparent"></div>
    <div class="absolute bottom-0 inset-x-0 h-px bg-gradient-to-r from-transparent via-slate-200 dark:via-white/10 to-transparent"></div>

    <div class="container mx-auto px-6 relative z-10">
        <div class="flex flex-col md:flex-row items-center justify-between mb-16 gap-6">
            <div class="flex items-center gap-4">
                <div class="w-12 h-[1px] bg-emerald-500"></div>
                <h2 class="text-3xl font-black text-slate-900 dark:text-white uppercase tracking-tighter">
                    <?php echo e(__(@$weAcceptContent->data_values->heading_w)); ?> 
                    <span class="text-emerald-500"><?php echo e(__(@$weAcceptContent->data_values->heading_c)); ?></span>
                </h2>
            </div>
            <p class="text-[10px] font-black text-slate-400 uppercase tracking-[0.4em] italic">
                Secure Channel Verification // Active
            </p>
        </div>

        <div class="relative">
            <div class="absolute inset-y-0 left-0 w-32 bg-gradient-to-r from-white dark:from-slate-950 to-transparent z-20"></div>
            <div class="absolute inset-y-0 right-0 w-32 bg-gradient-to-l from-white dark:from-slate-950 to-transparent z-20"></div>

            <div class="payment-slider flex items-center gap-12 lg:gap-24">
                <?php $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="single-slide shrink-0">
                        <div class="group relative py-4">
                            <img src="<?php echo e(frontendImage('we_accept', $method->data_values->image, '75x75')); ?>" 
                                 alt="Gateway" 
                                 class="h-12 w-auto object-contain opacity-40 grayscale group-hover:opacity-100 group-hover:grayscale-0 transition-all duration-500 transform group-hover:scale-110">
                            
                            <div class="absolute -inset-4 bg-emerald-500/5 rounded-full blur-xl opacity-0 group-hover:opacity-100 transition-opacity pointer-events-none"></div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        
        <div class="mt-16 text-center">
            <p class="text-sm font-medium text-slate-500 dark:text-slate-400 max-w-xl mx-auto italic">
                <?php echo e(__(@$weAcceptContent->data_values->sub_heading)); ?>

            </p>
        </div>
    </div>
</section>

<?php $__env->startPush('style'); ?>
<style>
    /* CSS Marquee Animation if not using a JS slider */
    .payment-slider {
        animation: marquee 40s linear infinite;
        width: max-content;
    }

    @keyframes marquee {
        0% { transform: translateX(0); }
        100% { transform: translateX(-50%); }
    }

    /* Pause on hover for better UX */
    .payment-slider:hover {
        animation-play-state: paused;
    }
</style>
<?php $__env->stopPush(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/sections/we_accept.blade.php ENDPATH**/ ?>