<?php $__env->startSection('content'); ?>
    <div class="px-4 mx-auto py-8">

        
        
            <div class="flex flex-col md:flex-row md:items-center justify-between gap-6 mb-12 px-4">
                <?php $__env->startPush('breadcrumb_text'); ?>
                <div class="flex items-center gap-5">
                    <div class="relative group">
                        <div class="absolute -inset-1 bg-gradient-to-r from-blue-500 to-indigo-600 rounded-2xl blur opacity-25">
                        </div>
                        <div
                            class="relative w-14 h-14 bg-slate-900 rounded-2xl flex items-center justify-center text-white border border-white/10 shadow-2xl">
                            <i data-lucide="plus-square" class="w-7 h-7 text-blue-400"></i>
                        </div>
                    </div>
                    <div>
                        <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase">
                            <?php echo app('translator')->get('Open Ticket'); ?></h2>
                        <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest mt-1"><?php echo app('translator')->get('Initialize new communication protocol'); ?></p>
                    </div>
                </div>
                <?php $__env->stopPush(); ?>
                <?php $__env->startPush('breadcrumb'); ?>
                <a href="<?php echo e(route('ticket.index')); ?>"
                    class="group relative px-6 py-3 bg-slate-100 dark:bg-white/5 rounded-xl transition-all hover:bg-slate-900 dark:hover:bg-white overflow-hidden">
                    <span
                        class="relative z-10 text-[10px] font-black uppercase tracking-widest text-slate-600 dark:text-slate-400 group-hover:text-white dark:group-hover:text-slate-900"><?php echo app('translator')->get('My Tickets'); ?></span>
                </a>
                <?php $__env->stopPush(); ?>
            </div>

        <div class="relative group">
            <div class="absolute -inset-0.5 bg-gradient-to-b from-blue-500/10 to-transparent rounded-[2.5rem] blur-sm">
            </div>

            <div
                class="relative bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2.5rem] p-8 md:p-12 shadow-2xl overflow-hidden">

                <form action="<?php echo e(route('ticket.store')); ?>" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="grid grid-cols-12 gap-8">

                        
                        <div class="col-span-12 lg:col-span-7 space-y-6">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div class="space-y-2">
                                    <label
                                        class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Ticket Subject'); ?></label>
                                    <input type="text" name="subject" value="<?php echo e(old('subject')); ?>"
                                        class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-blue-500 transition-all outline-none"
                                        placeholder="<?php echo app('translator')->get('Brief summary of issue'); ?>" required>
                                </div>
                                <div class="space-y-2">
                                    <label
                                        class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Priority Level'); ?></label>
                                    <div class="relative">
                                        <select name="priority"
                                            class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-sm font-black text-slate-900 dark:text-white focus:ring-2 focus:ring-blue-500 transition-all outline-none appearance-none cursor-pointer"
                                            required>
                                            <option value="3"><?php echo app('translator')->get('High Priority'); ?></option>
                                            <option value="2"><?php echo app('translator')->get('Medium Priority'); ?></option>
                                            <option value="1"><?php echo app('translator')->get('Low Priority'); ?></option>
                                        </select>
                                        <i data-lucide="chevron-down"
                                            class="absolute right-6 top-1/2 -translate-y-1/2 w-4 h-4 text-slate-400 pointer-events-none"></i>
                                    </div>
                                </div>
                            </div>

                            <div class="space-y-2">
                                <label
                                    class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Protocol Message'); ?></label>
                                <textarea name="message" id="inputMessage" rows="8"
                                    class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-[2rem] p-6 text-sm font-bold text-slate-900 dark:text-white focus:ring-2 focus:ring-blue-500 transition-all outline-none"
                                    placeholder="<?php echo app('translator')->get('Describe your issue in detail...'); ?>" required><?php echo e(old('message')); ?></textarea>
                            </div>
                        </div>

                        
                        <div class="col-span-12 lg:col-span-5 flex flex-col justify-between">
                            <div class="space-y-6">
                                <div class="flex items-center justify-between px-2">
                                    <label
                                        class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Attached Evidence'); ?></label>
                                    <button type="button"
                                        class="addAttachment text-[9px] font-black text-emerald-500 uppercase tracking-widest flex items-center gap-2 hover:text-emerald-400 transition-colors">
                                        <i data-lucide="plus-circle" class="w-4 h-4"></i> <?php echo app('translator')->get('Add File'); ?>
                                    </button>
                                </div>

                                <div class="fileUploadsContainer space-y-4">
                                    
                                </div>

                                <div class="p-6 rounded-2xl bg-blue-500/5 border border-blue-500/10">
                                    <p
                                        class="text-[9px] font-black text-blue-500 uppercase tracking-widest mb-2 flex items-center gap-2">
                                        <i data-lucide="info" class="w-3 h-3"></i> <?php echo app('translator')->get('Dispatch Requirements'); ?>
                                    </p>
                                    <p
                                        class="text-[8px] font-bold text-slate-500 dark:text-slate-400 uppercase leading-relaxed tracking-widest">
                                        <?php echo app('translator')->get('Max 5 files | Max Size:'); ?> <?php echo e(convertToReadableSize(ini_get('upload_max_filesize'))); ?> <br>
                                        <?php echo app('translator')->get('Extensions: .jpg, .jpeg, .png, .pdf, .doc, .docx'); ?>
                                    </p>
                                </div>
                            </div>

                            <div class="mt-10 lg:mt-0">
                                <button type="submit"
                                    class="group relative w-full h-20 bg-slate-900 dark:bg-white rounded-2xl overflow-hidden transition-all active:scale-95 shadow-2xl">
                                    <div
                                        class="absolute inset-0 bg-gradient-to-r from-blue-600 to-indigo-600 opacity-0 group-hover:opacity-100 transition-opacity">
                                    </div>
                                    <div class="relative flex flex-col items-center justify-center">
                                        <span
                                            class="text-[11px] font-black text-white dark:text-slate-900 uppercase tracking-[0.4em] group-hover:text-white"><?php echo app('translator')->get('Dispatch Ticket'); ?></span>
                                        <span
                                            class="text-[8px] font-bold text-slate-400 uppercase tracking-[0.2em] group-hover:text-blue-200"><?php echo app('translator')->get('Send to central support node'); ?></span>
                                    </div>
                                </button>
                            </div>
                        </div>
                    </div>
                </form>

                
                <div class="absolute bottom-0 left-0 right-0 h-1.5 bg-gradient-to-r from-blue-500 to-indigo-600"></div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="https://unpkg.com/lucide@latest"></script>
    <script>
        (function($) {
            "use strict";
            lucide.createIcons();

            var fileAdded = 0;
            $('.addAttachment').on('click', function() {
                if (fileAdded >= 5) return;
                fileAdded++;
                if (fileAdded == 5) {
                    $(this).fadeOut();
                }

                $(".fileUploadsContainer").append(`
                <div class="removeFileInput group/file animate-in slide-in-from-right-2 duration-300">
                    <div class="relative flex items-center gap-2">
                        <div class="relative flex-1">
                            <input type="file" name="attachments[]" class="w-full bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 rounded-xl py-3 px-4 text-[10px] font-black text-slate-500 dark:text-slate-400 file:hidden outline-none" accept=".jpeg,.jpg,.png,.pdf,.doc,.docx" required>
                            <i data-lucide="file-up" class="absolute right-4 top-1/2 -translate-y-1/2 w-4 h-4 text-slate-400 pointer-events-none"></i>
                        </div>
                        <button type="button" class="removeFile w-10 h-10 rounded-xl bg-rose-500/10 text-rose-500 hover:bg-rose-500 hover:text-white transition-all flex items-center justify-center">
                            <i data-lucide="x" class="w-4 h-4"></i>
                        </button>
                    </div>
                </div>
            `);
                lucide.createIcons();
            });

            $(document).on('click', '.removeFile', function() {
                $('.addAttachment').fadeIn();
                fileAdded--;
                $(this).closest('.removeFileInput').remove();
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('Template::layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/user/support/create.blade.php ENDPATH**/ ?>