<?php
    $preloader = getContent('preloader.content', true);
?>
<!doctype html>
<html lang="<?php echo e(config('app.locale')); ?>" itemscope itemtype="http://schema.org/WebPage">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> <?php echo e(gs()->siteName(__($pageTitle))); ?></title>
    <?php echo $__env->make('partials.seo', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <!-- Bootstrap -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/bootstrap.min.css')); ?>">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/all.min.css')); ?>">
    <!-- Flat Icon -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/fonts/flaticon_xtrade.css')); ?>">
    <!-- Fancy Box -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/fancybox.css')); ?>">
    <!-- Swiper Slider -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/swiper-bundle.min.css')); ?>">
    <!-- Odometer -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/odometer.css')); ?>">
    <!-- Main css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/main.css')); ?>">
    <?php echo $__env->yieldPushContent('style-lib'); ?>

    <?php echo $__env->yieldPushContent('style'); ?>

</head>

<?php echo loadExtension('google-analytics') ?>

<body>
    <!--==========================   Preloader Start  ==========================-->
    <div id="preloader">
        <div id="text">
            <p class="active">X</p>
            <p>B</p>
            <p>L</p>
            <p>O</p>
            <p>C</p>
            <p>K</p>
            <p>W</p>
            <p>E</p>
            <p>A</p>
            <p>L</p>
            <p>T</p>
            <p>H</p>
        </div>
    </div>
    <!--==========================  Preloader End  ==========================-->
    <?php echo $__env->yieldPushContent('fbComment'); ?>
        <div class="wrapper">
            <?php echo $__env->yieldContent('panel'); ?>
        </div>

    <?php
        $cookie = App\Models\Frontend::where('data_keys', 'cookie.data')->first();
    ?>
    <?php if($cookie->data_values->status == Status::ENABLE && !\Cookie::get('gdpr_cookie')): ?>
        
    <?php endif; ?>

    <div class="progress-wrap">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>


    <!-- Jquery js -->
    <script data-cfasync="false" src="/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
    <script src="<?php echo e(asset('assets/frontend//js/jquery-3.7.1.min.js')); ?>"></script>
    <!-- gsap Js -->
    <script src="<?php echo e(asset('assets/frontend//js/gsap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/frontend//js/ScrollTrigger.js')); ?>"></script>
    <!-- Bootstrap Bundle Js -->
    <script src="<?php echo e(asset('assets/frontend//js/boostrap.bundle.min.js')); ?>"></script>
    <!-- Scroll Reveal Js -->
    <script src="<?php echo e(asset('assets/frontend//js/scrollreveal.min.js')); ?>"></script>
    <!-- Swiper Bundle Js -->
    <script src="<?php echo e(asset('assets/frontend//js/swiper-bundle.min.js')); ?>"></script>
    <!-- Fancy Box js -->
    <script src="<?php echo e(asset('assets/frontend//js/fancybox.umd.js')); ?>"></script>
    <!-- Odometer js -->
    <script src="<?php echo e(asset('assets/frontend//js/odometer.min.js')); ?>"></script>

    <!-- main js -->
    <script src="<?php echo e(asset('assets/frontend//js/main.js')); ?>"></script>
    <script defer src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015"
        integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ=="
        data-cf-beacon='{"version":"2024.11.0","token":"3c29d7bffb424472bfac70b0302e98df","r":1,"server_timing":{"name":{"cfCacheStatus":true,"cfEdge":true,"cfExtPri":true,"cfL4":true,"cfOrigin":true,"cfSpeedBrain":true},"location_startswith":null}}'
        crossorigin="anonymous"></script>

    <?php echo $__env->yieldPushContent('script-lib'); ?>
    <?php echo loadExtension('tawk-chat') ?>
    <?php echo $__env->make('partials.notify', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <?php if(gs('pn')): ?>
        <?php echo $__env->make('partials.push_script', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php endif; ?>
    <?php echo $__env->yieldPushContent('script'); ?>
</body>

</html>
<?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/layouts/app.blade.php ENDPATH**/ ?>