<?php $__env->startSection('content'); ?>
    <div class="w-full max-w-sm">
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <!-- Enhanced Header -->
            <div class="px-6 py-6 text-center">
                <h1 class="text-xl font-light text-black mb-1">Verify your email</h1>
                <p class="text-xs text-gray-500">Enter the code sent to your email k</p>
            </div>

            <!-- Session Status -->

            <!-- Reset Form -->
            <div class="px-6 pb-6">
                <div class="mb-4 text-xs text-gray-500 text-center">
                    <p class="mt-3 text-sm text-slate-500 leading-relaxed">
                        We've sent a 6-digit verification code to <br>
                        <span class="font-semibold text-slate-900"><?php echo e(showEmailAddress($email)); ?></span>
                    </p>
                </div>

                <form action="<?php echo e(route('user.password.update')); ?>" method="POST" class="verify-gcaptcha space-y-4">
                    <?php echo csrf_field(); ?>

                    <input type="hidden" name="email" value="<?php echo e($email); ?>">
                    <input type="hidden" name="token" value="<?php echo e($token); ?>">

                    <!-- New Password -->
                    <div>
                        <label for="password" class="block text-xs font-medium text-black mb-1">Enter New Password</label>
                        <input type="password" id="password" name="password" type="password" value="<?php echo e(old('password')); ?>"
                            required autofocus
                            class="w-full px-3 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200 ">
                    </div>
                    <?php if(gs('secure_password')): ?>
                        <p class="mt-2 text-xs text-slate-400">Password must include symbols, numbers, and capital letters.
                        </p>
                    <?php endif; ?>
                    <!-- Confirm New Password -->

                    <div>
                        <label for="password_confirmation" class="block text-xs font-medium text-black mb-1">Confirm New
                            Password</label>
                        <input type="password" id="password_confirmation" name="password_confirmation" type="password"
                            value="<?php echo e(old('password_confirmation')); ?>" required autofocus
                            class="w-full px-3 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200 ">
                    </div>

                    <!-- Submit Button -->
                    <div class="pt-2">
                        <button type="submit"
                            class="w-full bg-black hover:bg-gray-800 text-white py-2.5 px-4 rounded-lg text-sm font-medium transition-all duration-200">
                            Reset Password </button>
                    </div>
                </form>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php if(gs('secure_password')): ?>
    <script src="<?php echo e(asset('assets/global/js/secure_password.js')); ?>"></script>
<?php endif; ?> 


<?php echo $__env->make('Template::layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/user/auth/passwords/reset.blade.php ENDPATH**/ ?>