<!-- header-section start  -->
<?php
    $pages = App\Models\Page::where('tempname', activeTemplate())->where('is_default', 0)->get();
?>
<header>
<nav class="navbar navbar-expand-lg navbar-main">
    <div class="container">
        <a class="navbar-brand" href="<?php echo e(url('/')); ?>">
            <img src="<?php echo e(siteLogo()); ?>" width="100" alt="logo" class="logo-img">
        </a>
        <div class="right-nav">
            <a href="<?php echo e(route('user.login')); ?>" class="btn btn-outline--base d-none d-sm-block">
                Log In <i class="flaticon-arrow-upper-right"></i>
            </a>
            <a href="<?php echo e(route('contact')); ?>" class="btn btn--base-two d-none d-sm-block">
                Contact Us <i class="flaticon-arrow-upper-right"></i>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasNavbar"
                aria-controls="offcanvasNavbar" aria-label="Toggle navigation">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                    class="bi bi-list" viewBox="0 0 16 16">
                    <path fill-rule="evenodd"
                        d="M2.5 12a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5" />
                </svg>
            </button>
        </div>
        <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasNavbar" aria-labelledby="offcanvasNavbarLabel">
            <div class="offcanvas-header">
                <h5 class="offcanvas-title" id="offcanvasNavbarLabel">
                    <img src="<?php echo e(siteLogo()); ?>" alt="logo" class="logo-img">
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
            </div>
            <div class="d-flex d-lg-none gap-4 pt-3 justify-content-center">
                <a href="<?php echo e(route('user.login')); ?>" class="btn btn-outline--base d-sm-none">
                    Log In <i class="flaticon-arrow-upper-right"></i>
                </a>
                <a href="<?php echo e(route('contact')); ?>" class="btn btn--base-two d-sm-none">
                    Contact Us <i class="flaticon-arrow-upper-right"></i>
                </a>
            </div>
            <div class="offcanvas-body align-items-center">
                <ul class="navbar-nav justify-content-center flex-grow-1">
                    <li class="nav-item dropdown">
                        <a class="nav-link" href="<?php echo e(route('home')); ?>">
                            Home
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('user.login')); ?>">Market</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('contact')); ?>">Contact</a>
                    </li> 
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown"
                            aria-expanded="false">
                            Pages
                        </a>
                        <ul class="dropdown-menu fade-down">
                            <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a class="dropdown-item" href="<?php echo e(route('pages', [$data->slug])); ?>">Blog</a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </li> 
                </ul>
            </div>
        </div>
    </div>
</nav>
</header>
<?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/partials/header.blade.php ENDPATH**/ ?>