<?php $__env->startSection('content'); ?>
<div class="px-4 mx-auto py-8">

    
    <?php $__env->startPush('breadcrumb_text'); ?>
    <div class="flex flex-col md:flex-row md:items-center justify-between gap-6 mb-12 px-4">
        <div class="flex items-center gap-5">
            <div class="relative group">
                <div class="absolute -inset-1 bg-gradient-to-r from-yellow-500 to-amber-600 rounded-2xl blur opacity-25"></div>
                <div class="relative w-14 h-14 bg-slate-900 rounded-2xl flex items-center justify-center text-white border border-white/10 shadow-2xl">
                    <i data-lucide="award" class="w-7 h-7 text-yellow-500"></i>
                </div>
            </div>
            <div>
                <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase"><?php echo app('translator')->get('Tier Ranking'); ?></h2>
                <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest mt-1"><?php echo app('translator')->get('Achieve volume milestones to unlock bonuses'); ?></p>
            </div>
        </div>
    </div>
    <?php $__env->stopPush(); ?>

    <?php $nextRanking = $userRankings->where('id', '>', $user->user_ranking_id)->first(); ?>
    
    
    <?php if($nextRanking): ?>
    <div class="relative group mb-16">
        <div class="absolute -inset-1 bg-gradient-to-r from-emerald-500/20 to-blue-500/20 rounded-[2.5rem] blur opacity-30"></div>
        <div class="relative bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2.5rem] p-8 md:p-12 shadow-2xl">
            <div class="flex flex-col lg:flex-row items-center gap-10">
                
                
                <div class="flex flex-col items-center shrink-0">
                    <div class="relative w-32 h-32 mb-4">
                        <div class="absolute inset-0 bg-emerald-500/20 rounded-full blur-xl animate-pulse"></div>
                        <img src="<?php echo e(getImage(getFilePath('userRanking') . '/' . $nextRanking->icon, getFileSize('userRanking'))); ?>" class="relative w-full h-full object-contain drop-shadow-[0_0_15px_rgba(16,185,129,0.5)]">
                    </div>
                    <span class="text-[10px] font-black text-emerald-500 bg-emerald-500/10 px-4 py-1.5 rounded-full border border-emerald-500/20 uppercase tracking-widest">
                        <?php echo app('translator')->get('Targeting'); ?>: <?php echo e(__($nextRanking->name)); ?>

                    </span>
                </div>

                
                <div class="flex-1 w-full grid grid-cols-1 md:grid-cols-3 gap-8">
                    <div class="space-y-3">
                        <div class="flex justify-between items-end">
                            <span class="text-[9px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Personal Volume'); ?></span>
                            <span class="text-xs font-black text-slate-900 dark:text-white"><?php echo e(showAmount($user->total_invests)); ?> / <?php echo e(showAmount($nextRanking->minimum_invest)); ?></span>
                        </div>
                        <div class="h-2 bg-slate-100 dark:bg-white/5 rounded-full overflow-hidden">
                            <div class="h-full bg-gradient-to-r from-emerald-500 to-blue-500 transition-all duration-1000" style="width: <?php echo e(($user->total_invests / $nextRanking->minimum_invest) * 100); ?>%"></div>
                        </div>
                    </div>

                    <div class="space-y-3">
                        <div class="flex justify-between items-end">
                            <span class="text-[9px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Active Nodes'); ?></span>
                            <span class="text-xs font-black text-slate-900 dark:text-white"><?php echo e($user->activeReferrals->count()); ?> / <?php echo e($nextRanking->min_referral); ?></span>
                        </div>
                        <div class="h-2 bg-slate-100 dark:bg-white/5 rounded-full overflow-hidden">
                            <div class="h-full bg-gradient-to-r from-blue-500 to-indigo-500 transition-all duration-1000" style="width: <?php echo e(($user->activeReferrals->count() / $nextRanking->min_referral) * 100); ?>%"></div>
                        </div>
                    </div>

                    <div class="space-y-3">
                        <div class="flex justify-between items-end">
                            <span class="text-[9px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Network Strength'); ?></span>
                            <span class="text-xs font-black text-slate-900 dark:text-white"><?php echo e(showAmount($user->team_invests)); ?> / <?php echo e(showAmount($nextRanking->min_referral_invest)); ?></span>
                        </div>
                        <div class="h-2 bg-slate-100 dark:bg-white/5 rounded-full overflow-hidden">
                            <div class="h-full bg-gradient-to-r from-indigo-500 to-purple-500 transition-all duration-1000" style="width: <?php echo e(($user->team_invests / $nextRanking->min_referral_invest) * 100); ?>%"></div>
                        </div>
                    </div>
                </div>
            </div>
            
            <?php if($nextRanking->minimum_invest - $user->total_invests > 0): ?>
                <div class="absolute bottom-6 right-8 flex items-center gap-2 opacity-40">
                    <i data-lucide="lock" class="w-3 h-3 text-slate-400"></i>
                    <span class="text-[8px] font-black uppercase tracking-widest text-slate-400"><?php echo e(showAmount($nextRanking->minimum_invest - $user->total_invests)); ?> <?php echo app('translator')->get('deficit to unlock'); ?></span>
                </div>
            <?php endif; ?>

            <div class="absolute bottom-0 left-0 right-0 h-1.5 bg-gradient-to-r from-emerald-500 via-blue-500 to-indigo-500"></div>
        </div>
    </div>
    <?php endif; ?>

    
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8">
        <?php $__currentLoopData = $userRankings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $userRanking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $isAchieved = $user->user_ranking_id >= $userRanking->id;
                $isLocked = $nextRanking && $nextRanking->id < $userRanking->id;
                
                if ($isAchieved) {
                    $progressPercent = 100;
                } else {
                    $myInvestPercent = min(($user->total_invests / $userRanking->minimum_invest) * 100, 100);
                    $refInvestPercent = min(($user->team_invests / $userRanking->min_referral_invest) * 100, 100);
                    $refCountPercent = min(($user->activeReferrals->count() / $userRanking->min_referral) * 100, 100);
                    $progressPercent = ($myInvestPercent + $refInvestPercent + $refCountPercent) / 3;
                }
            ?>

            <div class="relative group h-full">
                
                <?php if(!$isLocked): ?>
                    <div class="absolute -inset-0.5 bg-gradient-to-b from-emerald-500/20 to-blue-500/20 rounded-[2.5rem] blur opacity-40 group-hover:opacity-70 transition duration-500"></div>
                <?php endif; ?>

                <div class="relative h-full bg-white dark:bg-slate-900 border <?php echo e($isAchieved ? 'border-emerald-500/30' : 'border-slate-200 dark:border-white/10'); ?> rounded-[2.5rem] p-8 flex flex-col items-center text-center shadow-xl transition-all duration-500 <?php echo e($isLocked ? 'grayscale opacity-50' : ''); ?>">
                    
                    
                    <div class="relative w-20 h-20 mb-6">
                        <?php if($isLocked): ?>
                            <div class="absolute inset-0 flex items-center justify-center z-10">
                                <i data-lucide="lock" class="w-8 h-8 text-slate-400"></i>
                            </div>
                        <?php endif; ?>
                        <img src="<?php echo e(getImage(getFilePath('userRanking') . '/' . $userRanking->icon, getFileSize('userRanking'))); ?>" class="w-full h-full object-contain <?php echo e($isLocked ? 'opacity-20 blur-[1px]' : 'drop-shadow-[0_5px_15px_rgba(0,0,0,0.2)]'); ?>">
                    </div>

                    <h4 class="text-lg font-black text-slate-900 dark:text-white tracking-tighter uppercase mb-1"><?php echo e(__($userRanking->name)); ?></h4>
                    <p class="text-[9px] font-black text-emerald-500 uppercase tracking-widest mb-6"><?php echo app('translator')->get('Bonus'); ?>: <?php echo e(showAmount($userRanking->bonus)); ?></p>

                    
                    <ul class="w-full space-y-3 mb-8 pt-6 border-t border-slate-100 dark:border-white/5">
                        <li class="flex justify-between items-center text-[9px] font-black uppercase tracking-widest">
                            <span class="text-slate-400"><?php echo app('translator')->get('Level'); ?></span>
                            <span class="text-slate-900 dark:text-white"><?php echo e($userRanking->level); ?></span>
                        </li>
                        <li class="flex flex-col gap-1 text-left">
                            <span class="text-[8px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Minimum Invest'); ?></span>
                            <span class="text-[10px] font-black text-slate-900 dark:text-white tracking-tight"><?php echo e(showAmount($userRanking->minimum_invest)); ?></span>
                        </li>
                        <li class="flex flex-col gap-1 text-left">
                            <span class="text-[8px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Nodes Required'); ?></span>
                            <span class="text-[10px] font-black text-slate-900 dark:text-white tracking-tight"><?php echo e($userRanking->min_referral); ?> Active Referrals</span>
                        </li>
                    </ul>

                    
                    <?php if($isAchieved): ?>
                        <div class="mt-auto w-full py-2 bg-emerald-500/10 text-emerald-500 border border-emerald-500/20 rounded-xl text-[9px] font-black uppercase tracking-widest">
                            <i data-lucide="check-circle" class="w-3 h-3 inline-block mr-1"></i> <?php echo app('translator')->get('Unlocked'); ?>
                        </div>
                    <?php else: ?>
                        <div class="mt-auto w-full h-1.5 bg-slate-100 dark:bg-white/5 rounded-full overflow-hidden">
                            <div class="h-full bg-blue-500 transition-all duration-1000" style="width: <?php echo e($progressPercent); ?>%"></div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script src="https://unpkg.com/lucide@latest"></script>
<script>
    "use strict";
    (function ($) {
        lucide.createIcons();
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('Template::layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/user_ranking.blade.php ENDPATH**/ ?>