<?php
    $promotionCount = App\Models\PromotionTool::count();
?>
<header class="sticky top-0 z-50 glass @container">
  <div class="flex items-center justify-between px-2 sm:px-6 py-2 sm:py-4">
    <div class="flex items-center gap-4">
      <!-- Mobile Menu Button -->
      <button class="mobile-menu-btn js-mobile-menu-toggle" id="mobileMenuBtn" aria-label="Toggle Mobile Menu">
        <i data-lucide="menu" class="w-5 h-5"></i>
      </button>

      <!-- Sidebar Toggle (Desktop) -->
      <button class="sidebar-toggle-btn js-sidebar-toggle" aria-label="Toggle Sidebar">
        <i data-lucide="panel-left" class="w-5 h-5"></i>
      </button>

      <!-- Search -->
      <div class="relative hidden md:block">
        <i data-lucide="search" class="w-5 h-5 absolute left-2 top-1/2 -translate-y-1/2 text-muted"></i>
        <input type="text" id="globalSearch" placeholder="Search bots, assets, strategies... (⌘K)" class="form-control pl-8! w-80" />
      </div>
    </div>

    <div class="flex items-center gap-2 sm:gap-3">
      <!-- Live Status -->
      <div class="live-indicator hidden! md:flex">LIVE</div>
 

      <!-- Notifications -->

         <?php
            $notifyme = \App\Models\SupportTicket::where('user_id', auth()->id())
                ->latest()
                ->whereStatus(1)
                ->take(5)
                ->get();
        ?>
      <div class="dropdown">
        <button class="btn-icon relative js-dropdown-toggle" aria-label="Toggle Notifications">
          <i data-lucide="bell" class="w-5 h-5"></i>
          <span class="absolute -top-1 -right-1 w-5 h-5 bg-red-500 text-white text-xs rounded-full flex items-center justify-center"><?php echo e(count($notifyme)); ?></span>
        </button>
        <div class="dropdown-menu notifications-menu w-75 min-[400px]:w-80">
          <div class="p-4 border-b border-border">
            <h2 class="text-base font-semibold text-text">Notifications</h2>
          </div>
          <div class="max-h-64 overflow-y-auto">
            <?php $__currentLoopData = $notifyme; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notif): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e(route('ticket.view', $notif->ticket)); ?>">
            <div class="dropdown-item">

                <div class="w-8 h-8 rounded-full gradient-warning flex items-center justify-center shrink-0">
                <i data-lucide="alert-triangle" class="w-4 h-4 text-white"></i>
              </div>
              <div class="flex-1 min-w-0">
                <p class="text-sm font-medium truncate"><?php echo e($notif->subject); ?></p>
                <p class="text-xs text-muted"><?php echo e(diffForHumans($notif->created_at)); ?></p>
              </div>
            </div>


            </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
             
          </div>
          <div class="p-3 border-t border-border">
            <a href="<?php echo e(route('ticket.index')); ?>" class="w-full text-center text-sm font-medium text-indigo-500 hover:text-indigo-600">View all notifications</a>
          </div>
        </div>
      </div>

      <!-- Theme Toggle -->
      <button
        class="btn-icon"
        id="themeToggle"
        aria-label="Toggle Theme"
        onclick="
          document.documentElement.classList.toggle('dark');
          localStorage.setItem('theme', document.documentElement.classList.contains('dark') ? 'dark' : 'light');
        "
      >
        <i data-lucide="moon" class="w-5 h-5 dark:hidden"></i>
        <i data-lucide="sun" class="w-5 h-5 hidden dark:block"></i>
      </button>

      <!-- Profile Dropdown -->
      <div class="dropdown">
        <button class="flex items-center gap-2 p-1 rounded-xl hover:bg-border/50 transition js-dropdown-toggle">
          <span class="w-9 h-9 rounded-full gradient-primary flex items-center justify-center">
            <span class="text-white font-semibold text-sm"><?php echo e(substr(auth()->user()->fullname, 0, 2)); ?></span>
          </span>
          <i data-lucide="chevron-down" class="w-4 h-4 text-muted hidden sm:block"></i>
        </button>
        <div class="dropdown-menu">
          <div class="p-4 border-b border-border">
            <p class="font-semibold text-text"><?php echo e(auth()->user()->username); ?></p>
            <p class="text-xs text-muted">Pro Trader</p>
          </div>
          <a href="<?php echo e(route('user.profile.setting')); ?>" class="dropdown-item">
            <i data-lucide="user" class="w-4 h-4"></i>
            <span>My Profile</span>
          </a>
          <a href="<?php echo e(route('user.change.password')); ?>" class="dropdown-item">
            <i data-lucide="settings" class="w-4 h-4"></i>
            <span>Settings</span>
          </a>
          <a href="<?php echo e(route('ticket.index')); ?>" class="dropdown-item">
            <i data-lucide="help-circle" class="w-4 h-4"></i>
            <span>Help & Support</span>
          </a>
          <div class="p-2 border-t border-border">
            <a href="<?php echo e(route('user.logout')); ?>" class="dropdown-item text-red-500 hover:bg-red-500/10 hover:text-red-500">
              <i data-lucide="log-out" class="w-4 h-4"></i>
              <span>Logout</span>
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
</header><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/partials/dashboard_header.blade.php ENDPATH**/ ?>