<!DOCTYPE html>
<html lang="en" class="h-full bg-white">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> <?php echo e(gs()->siteName(__($pageTitle))); ?></title>
    <?php echo $__env->make('partials.seo', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; }
        /* Style for the 6-digit code to look spaced out */
        #verification-code {
            letter-spacing: 1.25rem;
            text-align: center;
            padding-left: 1.25rem;
        }
    </style>
</head>
<body class="h-full antialiased">

<div class="flex min-h-full">
    
    <div class="flex flex-1 flex-col justify-center px-4 py-12 sm:px-6 lg:flex-none lg:px-20 xl:px-24">
        <div class="mx-auto w-full max-w-sm lg:w-96">
            
            <div class="mb-10 text-center lg:text-left">
                <div class="inline-flex h-14 w-14 items-center justify-center rounded-2xl bg-emerald-50 text-emerald-600 mb-6">
                    <svg class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                    </svg>
                </div>
                <h2 class="text-3xl font-extrabold tracking-tight text-slate-900">Verify your email</h2>
                <p class="mt-3 text-sm text-slate-500 leading-relaxed">
                    We've sent a 6-digit verification code to <br>
                    <span class="font-semibold text-slate-900"><?php echo e(showEmailAddress($email)); ?></span>
                </p>
            </div>

            <div class="mt-8">
                <form action="<?php echo e(route('user.password.verify.code')); ?>" method="POST" class="submit-form space-y-6">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="email" value="<?php echo e($email); ?>">

                    <div>
                        <label for="verification-code" class="block text-sm font-semibold text-slate-700 mb-2">Verification Code</label>
                        <input type="text" name="code" id="verification-code" maxlength="6" required 
                            class="block w-full rounded-xl border border-slate-200 py-4 text-2xl font-bold text-slate-900 shadow-sm focus:border-emerald-500 focus:ring-4 focus:ring-emerald-500/10 transition-all outline-none"
                            placeholder="000000" autocomplete="off">
                    </div>

                    <button type="submit" class="flex w-full justify-center rounded-xl bg-slate-900 px-4 py-4 text-sm font-bold text-white shadow-lg hover:bg-slate-800 active:scale-[0.98] transition-all">
                        Verify Code
                    </button>
                </form>

                <div class="mt-8 rounded-xl bg-slate-50 p-4 border border-slate-100">
                    <p class="text-xs text-slate-500 text-center leading-normal">
                        <span class="font-bold text-slate-700">Can't find the email?</span> Check your junk or spam folder. 
                        If it's still not there, you can 
                        <a href="<?php echo e(route('user.password.request')); ?>" class="text-emerald-600 font-bold hover:underline">request a new code</a>.
                    </p>
                </div>
            </div>
        </div>
    </div>

    <div class="relative hidden w-0 flex-1 lg:block">
        <div class="absolute inset-0 h-full w-full bg-slate-900">
            <div class="absolute inset-0 opacity-40" style="background-image: radial-gradient(circle at 20% 30%, #10b981 0%, transparent 50%), radial-gradient(circle at 80% 70%, #0ea5e9 0%, transparent 50%);"></div>
            
            <div class="relative flex h-full flex-col justify-center px-20 text-white">
                <div class="max-w-md">
                    <div class="h-1 w-20 bg-emerald-500 mb-8 rounded-full"></div>
                    <h3 class="text-3xl font-bold mb-6 italic font-serif">"Security is not a product, but a process."</h3>
                    <p class="text-slate-400 text-lg">
                        This verification step ensures that only you can access your investment portfolio. We're protecting your future.
                    </p>
                    
                    <div class="mt-12 flex items-center gap-6">
                        <div class="text-center">
                            <p class="text-2xl font-bold">2FA</p>
                            <p class="text-xs text-slate-500 uppercase tracking-widest mt-1">Protection</p>
                        </div>
                        <div class="w-px h-10 bg-slate-700"></div>
                        <div class="text-center">
                            <p class="text-2xl font-bold">100%</p>
                            <p class="text-xs text-slate-500 uppercase tracking-widest mt-1">Encrypted</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Auto-focus on code input
    document.getElementById('verification-code').focus();
    
    // Optional: Only allow numbers
    document.getElementById('verification-code').addEventListener('input', function (e) {
        this.value = this.value.replace(/[^0-9]/g, '');
    });
</script>
</body>
</html><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/auth/passwords/code_verify.blade.php ENDPATH**/ ?>