<?php $__env->startSection('content'); ?>
    <div class="px-4 mx-auto py-8">

        
        <?php $__env->startPush('breadcrumb_text'); ?>
            <div class="flex flex-col md:flex-row md:items-center justify-between gap-6 mb-12 px-4">
                <div class="flex items-center gap-5">
                    <div class="relative group">
                        <div class="absolute -inset-1 bg-gradient-to-r from-emerald-500 to-blue-500 rounded-2xl blur opacity-25">
                        </div>
                        <div
                            class="relative w-14 h-14 bg-slate-900 rounded-2xl flex items-center justify-center text-white border border-white/10 shadow-2xl">
                            <i data-lucide="shield-check" class="w-7 h-7 text-emerald-400"></i>
                        </div>
                    </div>
                    <div>
                        <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase">
                            <?php echo app('translator')->get('Two-Factor Security'); ?></h2>
                        <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest mt-1"><?php echo app('translator')->get('Biometric layer & timed protocol codes'); ?></p>
                    </div>
                </div>
            </div>
        <?php $__env->stopPush(); ?>

        <div class="grid grid-cols-12 gap-8">
            <?php if(!auth()->user()->ts): ?>
                
                <div class="col-span-12 lg:col-span-6 space-y-6">
                    <div class="relative group">
                        <div
                            class="absolute -inset-0.5 bg-gradient-to-r from-emerald-500/20 to-blue-500/20 rounded-[2.5rem] blur opacity-20">
                        </div>
                        <div
                            class="relative bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2.5rem] p-8 shadow-2xl overflow-hidden">

                            <div class="text-center mb-8">
                                <h4
                                    class="text-sm font-black text-slate-900 dark:text-white uppercase tracking-widest mb-2">
                                    <?php echo app('translator')->get('Add Your Account'); ?></h4>
                                <p class="text-[10px] font-bold text-slate-400 uppercase leading-relaxed px-4">
                                    <?php echo app('translator')->get('Sync your mobile authenticator via QR or setup key'); ?></p>
                            </div>

                            
                            <div class="relative w-48 h-48 mx-auto mb-8 p-3 bg-white rounded-3xl shadow-inner group/qr">
                                <div class="absolute -inset-2 border-2 border-emerald-500/20 rounded-[2rem] animate-pulse">
                                </div>
                                <img class="w-full h-full object-contain rounded-xl" src="<?php echo e($qrCodeUrl); ?>">
                            </div>

                            
                            <div class="space-y-4">
                                <label
                                    class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Manual Setup Key'); ?></label>
                                <div class="relative group/input">
                                    <input type="text" name="key" value="<?php echo e($secret); ?>"
                                        class="referralURL w-full bg-slate-50 dark:bg-slate-950 border border-slate-100 dark:border-white/5 rounded-2xl py-4 px-6 text-xs font-black text-emerald-500 outline-none"
                                        readonly>
                                    <button type="button" id="copyBoard"
                                        class="absolute right-2 top-1/2 -translate-y-1/2 w-10 h-10 bg-slate-900 dark:bg-white text-white dark:text-slate-900 rounded-xl flex items-center justify-center hover:bg-emerald-500 dark:hover:bg-emerald-500 transition-all active:scale-90">
                                        <i data-lucide="copy" class="w-4 h-4"></i>
                                    </button>
                                </div>
                            </div>

                            
                            <div class="mt-8 p-6 rounded-2xl bg-blue-500/5 border border-blue-500/10">
                                <div class="flex items-center gap-2 mb-2 text-blue-500">
                                    <i data-lucide="help-circle" class="w-4 h-4"></i>
                                    <span class="text-[10px] font-black uppercase tracking-widest"><?php echo app('translator')->get('Protocol Help'); ?></span>
                                </div>
                                <p
                                    class="text-[9px] font-bold text-slate-500 dark:text-slate-400 uppercase leading-relaxed tracking-tight">
                                    <?php echo app('translator')->get('Install Google Authenticator to generate time-based codes.'); ?>
                                    <a class="text-emerald-500 hover:underline"
                                        href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2&hl=en"
                                        target="_blank"><?php echo app('translator')->get('Download Application'); ?></a>
                                </p>
                            </div>

                            <div
                                class="absolute bottom-0 left-0 right-0 h-1.5 bg-gradient-to-r from-emerald-500 to-blue-500">
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            
            <div
                class="col-span-12 <?php if(!auth()->user()->ts): ?> lg:col-span-6 <?php else: ?> lg:col-start-4 lg:col-span-6 <?php endif; ?>">
                <div class="relative group">
                    <?php $isTs = auth()->user()->ts; ?>
                    <div
                        class="absolute -inset-0.5 bg-gradient-to-r <?php if($isTs): ?> from-rose-500/20 to-orange-500/20 <?php else: ?> from-emerald-500/20 to-blue-500/20 <?php endif; ?> rounded-[2.5rem] blur opacity-20">
                    </div>

                    <div
                        class="relative bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2.5rem] p-10 shadow-2xl">

                        <div class="text-center mb-10">
                            <div
                                class="w-16 h-16 <?php if($isTs): ?> bg-rose-500/10 text-rose-500 <?php else: ?> bg-emerald-500/10 text-emerald-500 <?php endif; ?> rounded-2xl flex items-center justify-center mx-auto mb-4 border border-current opacity-50">
                                <i data-lucide="<?php echo e($isTs ? 'shield-off' : 'shield-check'); ?>" class="w-8 h-8"></i>
                            </div>
                            <h4 class="text-sm font-black text-slate-900 dark:text-white uppercase tracking-widest">
                                <?php if($isTs): ?>
                                    <?php echo app('translator')->get('Disable 2FA Security'); ?>
                                <?php else: ?>
                                    <?php echo app('translator')->get('Enable 2FA Security'); ?>
                                <?php endif; ?>
                            </h4>
                        </div>

                        <form action="<?php echo e($isTs ? route('user.twofactor.disable') : route('user.twofactor.enable')); ?>"
                            method="POST" class="space-y-8">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="key" value="<?php echo e($secret); ?>">

                            <div class="space-y-3">
                                <label
                                    class="text-[10px] font-black text-slate-400 uppercase tracking-widest text-center block"><?php echo app('translator')->get('Enter 6-Digit OTP Code'); ?></label>
                                <input type="text" name="code"
                                    class="w-full bg-slate-50 dark:bg-slate-950 border border-slate-100 dark:border-white/5 rounded-2xl py-5 px-6 text-2xl font-black text-center tracking-[0.5em] text-slate-900 dark:text-white focus:ring-2 <?php if($isTs): ?> focus:ring-rose-500 <?php else: ?> focus:ring-emerald-500 <?php endif; ?> transition-all outline-none"
                                    required placeholder="000000">
                            </div>

                            <button type="submit"
                                class="group relative w-full h-16 <?php if($isTs): ?> bg-slate-900 dark:bg-rose-600 <?php else: ?> bg-slate-900 dark:bg-white <?php endif; ?> rounded-2xl overflow-hidden transition-all active:scale-95 shadow-xl">
                                <div
                                    class="absolute inset-0 bg-gradient-to-r <?php if($isTs): ?> from-rose-600 to-orange-600 <?php else: ?> from-emerald-500 to-blue-500 <?php endif; ?> opacity-0 group-hover:opacity-100 transition-opacity">
                                </div>
                                <span
                                    class="relative text-[11px] font-black <?php if($isTs): ?> text-white <?php else: ?> text-white dark:text-slate-900 <?php endif; ?> uppercase tracking-[0.3em] group-hover:text-white">
                                    <?php if($isTs): ?>
                                        <?php echo app('translator')->get('Terminate Security'); ?>
                                    <?php else: ?>
                                        <?php echo app('translator')->get('Activate Protocol'); ?>
                                    <?php endif; ?>
                                </span>
                            </button>
                        </form>

                        <div
                            class="absolute bottom-0 left-0 right-0 h-1.5 bg-gradient-to-r <?php if($isTs): ?> from-rose-500 to-orange-500 <?php else: ?> from-emerald-500 to-blue-500 <?php endif; ?>">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="https://unpkg.com/lucide@latest"></script>
    <script>
        "use strict";
        (function($) {
            lucide.createIcons();

            $('#copyBoard').click(function() {
                var copyText = document.getElementsByClassName("referralURL")[0];
                copyText.select();
                copyText.setSelectionRange(0, 99999);
                document.execCommand("copy");
                copyText.blur();

                $(this).addClass('bg-emerald-500 text-white').html(
                    '<i data-lucide="check" class="w-4 h-4"></i>');
                lucide.createIcons();

                setTimeout(() => {
                    $(this).removeClass('bg-emerald-500 text-white').html(
                        '<i data-lucide="copy" class="w-4 h-4"></i>');
                    lucide.createIcons();
                }, 1500);
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('Template::layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/twofactor.blade.php ENDPATH**/ ?>