<?php $__env->startSection('content'); ?>
<div class="max-w-2xl mx-auto py-10 px-4">
    <div class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
        <div class="absolute inset-0 opacity-10">
            <div class="absolute top-0 right-0 w-32 h-32 bg-white rounded-full -translate-y-16 translate-x-16"></div>
            <div class="absolute bottom-0 left-0 w-16 h-16 bg-white rounded-full translate-y-8 -translate-x-8"></div>
        </div>
        <div class="relative z-10">
            <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                <div class="mb-4 lg:mb-0 lg:flex-1">
                    <h1 class="text-xl font-light mb-1"><?php echo app('translator')->get('Withdraw Funds'); ?></h1>
                    <p class="text-gray-300 text-sm"><?php echo app('translator')->get('Transfer money from your wallet to your chosen destination'); ?></p>
                </div>
                <div class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-64">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-xs text-gray-300 mb-1"><?php echo app('translator')->get('Available Balance'); ?></p>
                            <p class="text-lg font-light"><?php echo e(gs('cur_sym')); ?><?php echo e(showAmount(auth()->user()->balance)); ?></p>
                        </div>
                        <div class="w-10 h-10 flex items-center justify-center">
                            <i data-lucide="wallet" class="w-5 h-5 text-white"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php if($isHoliday && !gs('holiday_withdraw')): ?>
        <div class="bg-white rounded-xl p-12 shadow-sm border border-gray-100 text-center">
            <div class="w-20 h-20 bg-rose-50 rounded-3xl flex items-center justify-center mx-auto mb-6 border border-rose-100">
                <i data-lucide="calendar-off" class="w-10 h-10 text-rose-500"></i>
            </div>
            <h3 class="text-xl font-bold text-black uppercase tracking-tighter mb-4"><?php echo app('translator')->get('Withdrawal Protocol Suspended'); ?></h3>
            <p class="text-gray-500 text-sm mb-10 uppercase tracking-widest font-bold"><?php echo app('translator')->get('Requests will restore in'); ?>:</p>
            <div id="counter" class="flex justify-center gap-4 font-mono text-2xl font-black text-black"></div>
        </div>
    <?php else: ?>
        <div class="bg-white rounded-xl p-6 shadow-sm border border-gray-100">
            <form action="<?php echo e(route('user.withdraw.money')); ?>" method="POST" class="withdraw-form space-y-6">
                <?php echo csrf_field(); ?>
                
                <div>
                    <label for="amount" class="block text-sm font-medium text-gray-700 mb-2"><?php echo app('translator')->get('Withdrawal Amount'); ?></label>
                    <div class="relative">
                        <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-500"><?php echo e(gs('cur_sym')); ?></span>
                        <input type="number" id="amount" name="amount" step="any" class="amount w-full pl-8 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200" placeholder="0.00" required>
                    </div>
                    <p class="text-[10px] text-gray-400 mt-2 uppercase tracking-widest">
                        <?php echo app('translator')->get('Limit'); ?>: <span class="gateway-limit">0.00</span>
                    </p>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-3"><?php echo app('translator')->get('Withdrawal Method'); ?></label>
                    <div class="space-y-3 gateway-option-list">
                        <?php $__currentLoopData = $withdrawMethod; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label class="flex items-center p-4 border border-gray-200 rounded-lg cursor-pointer hover:border-gray-300 hover:bg-gray-50 transition-all duration-200 group gateway-option <?php if($loop->index > 3): ?> d-none <?php endif; ?>">
                                <input type="radio" name="method_code" value="<?php echo e($data->id); ?>" class="gateway-input w-4 h-4 text-black border-gray-300 focus:ring-black" 
                                    data-gateway='<?php echo json_encode($data, 15, 512) ?>' 
                                    data-min-amount="<?php echo e(showAmount($data->min_limit)); ?>" 
                                    data-max-amount="<?php echo e(showAmount($data->max_limit)); ?>"
                                    <?php if(old('method_code', $loop->first) == $data->id): echo 'checked'; endif; ?> required>
                                
                                <div class="ml-3 flex items-center flex-1">
                                    <img src="<?php echo e(getImage(getFilePath('withdrawMethod') . '/' . $data->image)); ?>" alt="<?php echo e(__($data->name)); ?>" class="w-8 h-8 mr-3 object-contain">
                                    <div class="flex-1">
                                        <p class="font-medium text-black text-sm uppercase"><?php echo e(__($data->name)); ?></p>
                                        <p class="text-[10px] text-gray-400 uppercase"><?php echo app('translator')->get('Secure Payout'); ?></p>
                                    </div>
                                    <div class="w-6 h-6 flex items-center justify-center group-hover:scale-110 transition-transform duration-200">
                                        <i data-lucide="arrow-right" class="w-4 h-4 text-gray-400 group-hover:text-gray-600"></i>
                                    </div>
                                </div>
                            </label>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php if($withdrawMethod->count() > 4): ?>
                        <button type="button" class="more-gateway-option w-full mt-4 py-3 text-[10px] font-bold text-gray-400 uppercase tracking-widest border border-dashed border-gray-200 rounded-lg hover:border-black hover:text-black transition-all">
                            <?php echo app('translator')->get('Show More Options'); ?>
                        </button>
                    <?php endif; ?>
                </div>

                <div class="bg-gradient-to-br from-red-50 to-red-100 rounded-xl p-5 border border-red-200">
                    <div class="flex items-center justify-between mb-4">
                        <span class="text-xs font-bold text-red-800 uppercase tracking-widest"><?php echo app('translator')->get('Fee Breakdown'); ?></span>
                        <i data-lucide="calculator" class="w-4 h-4 text-red-600"></i>
                    </div>
                    <div class="space-y-2">
                        <div class="flex items-center justify-between">
                            <span class="text-xs text-red-700"><?php echo app('translator')->get('Withdrawal Amount'); ?>:</span>
                            <span class="text-xs font-bold text-red-800"><?php echo e(gs('cur_sym')); ?><span class="display-amount">0.00</span></span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-xs text-red-700"><?php echo app('translator')->get('Processing Fee'); ?>:</span>
                            <span class="text-xs font-bold text-red-800">- <?php echo e(gs('cur_sym')); ?><span class="processing-fee">0.00</span></span>
                        </div>
                        
                        <div class="gateway-conversion d-none border-t border-red-200 pt-2 mt-2">
                            <div class="flex justify-between items-center italic">
                                <span class="text-[10px] text-red-600"><?php echo app('translator')->get('Rate'); ?>:</span>
                                <span class="text-[10px] text-red-600 conversion-rate-text"></span>
                            </div>
                        </div>

                        <div class="border-t border-red-300 pt-3 mt-1">
                            <div class="flex items-center justify-between">
                                <span class="text-sm font-bold text-red-800"><?php echo app('translator')->get("You'll Receive"); ?>:</span>
                                <span class="text-lg font-black text-red-900"><span class="final-amount">0.00</span> <span class="in-currency-code"></span></span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="pt-4">
                    <button type="submit" class="w-full bg-black text-white py-4 px-6 rounded-xl font-bold uppercase tracking-[0.2em] hover:bg-gray-800 transition-all active:scale-[0.98] flex items-center justify-center disabled:opacity-50" sdisabled>
                        <i data-lucide="minus" class="w-4 h-4 mr-2"></i>
                        <?php echo app('translator')->get('Withdraw Funds'); ?>
                    </button>
                </div>
            </form>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script>
    (function($) {
        "use strict";
        lucide.createIcons();

        var amount = 0;
        var gateway = null;

        $('.amount').on('input', function() {
            amount = parseFloat($(this).val()) || 0;
            $('.display-amount').text(amount.toFixed(2));
            calculation();
        });

        $('.gateway-input').on('change', function() {
            gatewayChange();
        });

        function gatewayChange() {
            let selected = $('.gateway-input:checked');
            gateway = selected.data('gateway');
            $('.gateway-limit').text(selected.data('min-amount') + " - " + selected.data('max-amount') + " <?php echo e(gs('cur_text')); ?>");
            calculation();
        }

        function calculation() {
            if (!gateway) return;

            let percentCharge = parseFloat(gateway.percent_charge);
            let fixedCharge = parseFloat(gateway.fixed_charge);
            let totalCharge = (amount / 100 * percentCharge) + fixedCharge;
            let finalAmount = amount - totalCharge;

            $('.processing-fee').text(totalCharge.toFixed(2));
            $('.final-amount').text(finalAmount > 0 ? finalAmount.toFixed(2) : "0.00");
            $('.in-currency-code').text("<?php echo e(gs('cur_text')); ?>");

            // Conversion Logic
            if (gateway.currency != "<?php echo e(gs('cur_text')); ?>") {
                $(".gateway-conversion").removeClass('d-none');
                $(".conversion-rate-text").text(`1 <?php echo e(gs('cur_text')); ?> = ${parseFloat(gateway.rate).toFixed(4)} ${gateway.currency}`);
                $('.in-currency-code').text(gateway.currency);
                $('.final-amount').text((finalAmount * gateway.rate).toFixed(2));
            } else {
                $(".gateway-conversion").addClass('d-none');
            }

            // Validation
            if (amount < Number(gateway.min_limit) || amount > Number(gateway.max_limit) || amount <= 0) {
                $(".withdraw-form button[type=submit]").attr('disabled', true);
            } else {
                $(".withdraw-form button[type=submit]").removeAttr('disabled');
            }
        }

        <?php if($isHoliday && !gs('holiday_withdraw')): ?>
            function createCountDown(elementId, sec) {
                var tms = sec;
                var x = setInterval(function() {
                    var d = Math.floor(tms / 86400);
                    var h = Math.floor((tms % 86400) / 3600);
                    var m = Math.floor((tms % 3600) / 60);
                    var s = tms % 60;
                    document.getElementById(elementId).innerHTML = `${d}d : ${h}h : ${m}m : ${s}s`;
                    if (tms < 0) { clearInterval(x); location.reload(); }
                    tms--;
                }, 1000);
            }
            createCountDown('counter', <?php echo e(abs(\Carbon\Carbon::parse($nextWorkingDay)->diffInSeconds())); ?>);
        <?php endif; ?>

        $(".more-gateway-option").on("click", function() {
            $(".gateway-option").removeClass("d-none");
            $(this).fadeOut();
        });

        gatewayChange();
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($activeTemplate . 'layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/user/withdraw/methods.blade.php ENDPATH**/ ?>