<?php $__env->startSection('content'); ?>
 <?php $__env->startPush('breadcrumb_text'); ?>
        <div class="flex items-center gap-5">
            <div class="relative group">
                <div class="absolute -inset-1 bg-gradient-to-r from-emerald-500 to-blue-500 rounded-2xl blur opacity-25"></div>
                <div class="relative w-14 h-14 bg-slate-900 rounded-2xl flex items-center justify-center text-white border border-white/10 shadow-2xl">
                    <i data-lucide="calendar" class="w-7 h-7 text-emerald-400"></i>
                </div>
            </div>
            <div>
                <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase"><?php echo app('translator')->get('Scheduled Trade'); ?></h2>
                <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest mt-1"><?php echo app('translator')->get('All scheduled investment'); ?></p>
            </div>
        </div>
        <?php $__env->stopPush(); ?>

    <div class="py-4 px-4 mx-auto"> 

        <div
            class="glass-vault border border-slate-200 dark:border-white/10 bg-white/50 dark:bg-slate-900/50 backdrop-blur-xl rounded-xl overflow-hidden shadow-sm">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr class="bg-slate-50 dark:bg-white/5 border-b border-slate-200 dark:border-white/10">
                            <th class="px-6 py-4 text-[10px] font-black uppercase tracking-widest text-slate-500">
                                <?php echo app('translator')->get('Strategy'); ?></th>
                            <th class="px-6 py-4 text-[10px] font-black uppercase tracking-widest text-slate-500">
                                <?php echo app('translator')->get('Return Profile'); ?></th>
                            <th class="px-6 py-4 text-[10px] font-black uppercase tracking-widest text-slate-500">
                                <?php echo app('translator')->get('Status'); ?></th>
                            <th class="px-6 py-4 text-[10px] font-black uppercase tracking-widest text-slate-500">
                                <?php echo app('translator')->get('Execution'); ?></th>
                            <th
                                class="px-6 py-4 text-[10px] font-black uppercase tracking-widest text-slate-500 text-right">
                                <?php echo app('translator')->get('Options'); ?></th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-100 dark:divide-white/5">
                        <?php $__empty_1 = true; $__currentLoopData = $scheduleInvests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $scheduleInvest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $plan = $scheduleInvest->plan;
                                $interest =
                                    $plan->interest_type == 1
                                        ? ($scheduleInvest->amount * $plan->interest) / 100
                                        : $plan->interest;
                            ?>

                            <tr class="hover:bg-slate-50/80 dark:hover:bg-white/[0.02] transition-colors">
                                <td class="px-6 py-5">
                                    <div class="flex items-center gap-3">
                                        <div
                                            class="w-10 h-10 rounded-lg bg-slate-900 dark:bg-white/10 flex items-center justify-center shrink-0">
                                            <i data-lucide="layers" class="w-5 h-5 text-slate-400"></i>
                                        </div>
                                        <div class="flex flex-col">
                                            <span
                                                class="text-sm font-bold text-slate-900 dark:text-white"><?php echo e(__($plan->name)); ?></span>
                                            <span
                                                class="text-xs font-medium text-slate-500"><?php echo e(showAmount($scheduleInvest->amount)); ?></span>
                                        </div>
                                    </div>
                                </td>

                                <td class="px-8 py-6">
                                    <div class="flex flex-col">
                                        <span class="text-sm font-bold text-slate-700 dark:text-slate-300">
                                            <?php echo e(showAmount($interest)); ?> <span
                                                class="text-[10px] text-slate-400 uppercase tracking-tighter">/
                                                <?php echo e($plan->timeSetting->name); ?></span>
                                        </span>
                                        <span class="text-[10px] font-black text-slate-400 uppercase tracking-widest mt-1">
                                            <?php if($plan->lifetime): ?>
                                                <?php echo app('translator')->get('Lifetime Yield'); ?>
                                            <?php else: ?>
                                                <?php echo e($plan->repeat_time); ?> <?php echo app('translator')->get('Cycles Total'); ?>
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                </td>

                                <td class="px-8 py-6">
                                    <div
                                        class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-slate-100 dark:bg-white/5 border border-slate-200 dark:border-white/10">
                                        <span
                                            class="w-2 h-2 rounded-full <?php echo e($scheduleInvest->status ? 'bg-emerald-500 animate-pulse' : 'bg-amber-500'); ?>"></span>
                                        <span class="text-[10px] font-black text-slate-600 dark:text-slate-300 uppercase">
                                            <?php echo e($scheduleInvest->rem_schedule_times); ?> <?php echo app('translator')->get('Left'); ?>
                                        </span>
                                    </div>
                                </td>

                                <td class="px-6 py-5">
                                    <div
                                        class="flex items-center gap-2 text-xs font-medium text-slate-600 dark:text-slate-400 italic">
                                        <?php echo e($scheduleInvest->next_invest ? showDateTime($scheduleInvest->next_invest) : '----'); ?>

                                    </div>
                                </td>

                                <td class="px-6 py-5 text-right">
                                    <div class="flex items-center justify-end gap-2">
                                        <button
                                            class="detailsBtn p-2 rounded-lg border border-slate-200 dark:border-white/10 text-slate-500 hover:bg-slate-900 hover:text-white dark:hover:bg-white dark:hover:text-slate-900 transition-all"
                                            data-schedule_invest="<?php echo e($scheduleInvest); ?>"
                                            data-interest="<?php echo e(getAmount($interest)); ?>"
                                            data-next_invest="<?php echo e($scheduleInvest->next_invest ? showDateTime($scheduleInvest->next_invest) : '-----'); ?>">
                                            <i data-lucide="maximize-2" class="w-4 h-4"></i>
                                        </button>

                                        <?php if($scheduleInvest->rem_schedule_times): ?>
                                            <button
                                                class="confirmationBtn p-2 rounded-lg border border-slate-200 dark:border-white/10 <?php echo e($scheduleInvest->status ? 'text-amber-500 hover:border-amber-500' : 'text-emerald-500 hover:border-emerald-500'); ?>"
                                                data-question="<?php echo app('translator')->get('Confirm action on this schedule?'); ?>"
                                                data-action="<?php echo e(route('user.invest.schedule.status', $scheduleInvest->id)); ?>">
                                                <i data-lucide="<?php echo e($scheduleInvest->status ? 'pause-circle' : 'play-circle'); ?>"
                                                    class="w-4 h-4"></i>
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="100%"
                                    class="px-6 py-16 text-center text-slate-400 text-xs font-bold uppercase tracking-widest">
                                    <?php echo e(__($emptyMessage)); ?>

                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <?php if($scheduleInvests->hasPages()): ?>
            <div class="mt-10">
                <?php echo e(paginateLinks($scheduleInvests)); ?>

            </div>
        <?php endif; ?>
    </div>

    <div id="detailsModal" class="hidden fixed inset-0 z-[9999] flex items-center justify-center p-4">
        <div class="absolute inset-0 bg-slate-900/70 backdrop-blur-md opacity-0 transition-opacity duration-300"
            id="detailsBackdrop"></div>

        <div class="relative w-full max-w-lg bg-white dark:bg-slate-900 rounded-[3.5rem] border border-white/20 shadow-2xl overflow-hidden transform scale-95 opacity-0 transition-all duration-300"
            id="detailsContent">

            <div
                class="p-8 border-b border-slate-100 dark:border-white/5 flex justify-between items-center bg-slate-50/50 dark:bg-slate-800/30">
                <div class="flex items-center gap-4">
                    <div
                        class="w-14 h-14 bg-emerald-500 rounded-2xl flex items-center justify-center text-white shadow-lg shadow-emerald-500/20">
                        <i data-lucide="info" class="w-7 h-7"></i>
                    </div>
                    <div>
                        <h2 class="text-xl font-black text-slate-900 dark:text-white uppercase tracking-tighter">
                            <?php echo app('translator')->get('Deployment Specs'); ?></h2>
                        <p class="text-[10px] font-bold text-emerald-500 uppercase tracking-widest"><?php echo app('translator')->get('Real-time Analytics'); ?></p>
                    </div>
                </div>
                <button type="button"
                    class="closeDetails p-3 rounded-full hover:bg-slate-200 dark:hover:bg-white/10 transition-colors">
                    <i data-lucide="x" class="w-6 h-6 text-slate-400"></i>
                </button>
            </div>

            <div class="p-8">
                <div class="space-y-1">
                    <?php
                        $rows = [
                            ['label' => 'Strategy Name', 'class' => 'planName'],
                            ['label' => 'Deployed Capital', 'class' => 'investAmount'],
                            ['label' => 'Cycle Return', 'class' => 'interestAmount'],
                            [
                                'label' => 'Compound Cycles',
                                'class' => 'compoundInterest',
                                'id' => 'compoundInterestBlock',
                            ],
                            ['label' => 'Total Scheduled', 'class' => 'scheduleTimes'],
                            ['label' => 'Remaining Cycles', 'class' => 'remScheduleTimes'],
                            ['label' => 'Update Interval', 'class' => 'intervalHours'],
                            ['label' => 'Next Execution', 'class' => 'nextInvest'],
                        ];
                    ?>

                    <?php $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div
                            class="flex justify-between items-center py-4 border-b border-slate-100 dark:border-white/5 last:border-0 <?php echo e($row['id'] ?? ''); ?>">
                            <span
                                class="text-[10px] font-black text-slate-400 uppercase tracking-widest"><?php echo e(__($row['label'])); ?></span>
                            <span class="text-sm font-bold text-slate-900 dark:text-white <?php echo e($row['class']); ?>"></span>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <div class="p-8 bg-slate-50/50 dark:bg-slate-800/30">
                <button type="button"
                    class="closeDetails w-full py-5 bg-slate-900 dark:bg-white text-white dark:text-slate-900 rounded-[2rem] text-[10px] font-black uppercase tracking-widest hover:scale-[1.02] transition-all duration-300">
                    <?php echo app('translator')->get('Return to Terminal'); ?>
                </button>
            </div>
        </div>
    </div>

    <?php if (isset($component)) { $__componentOriginal198649c2376bbacd94125172b51704af = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal198649c2376bbacd94125172b51704af = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.confirmation-modal2','data' => ['closeBtn' => 'py-4 px-8 rounded-2xl bg-slate-100 dark:bg-white/5 text-slate-500 text-[10px] font-black uppercase tracking-widest','submitBtn' => 'py-4 px-8 rounded-2xl bg-emerald-600 text-white text-[10px] font-black uppercase tracking-widest shadow-lg shadow-emerald-500/20']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal2'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['closeBtn' => 'py-4 px-8 rounded-2xl bg-slate-100 dark:bg-white/5 text-slate-500 text-[10px] font-black uppercase tracking-widest','submitBtn' => 'py-4 px-8 rounded-2xl bg-emerald-600 text-white text-[10px] font-black uppercase tracking-widest shadow-lg shadow-emerald-500/20']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal198649c2376bbacd94125172b51704af)): ?>
<?php $attributes = $__attributesOriginal198649c2376bbacd94125172b51704af; ?>
<?php unset($__attributesOriginal198649c2376bbacd94125172b51704af); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal198649c2376bbacd94125172b51704af)): ?>
<?php $component = $__componentOriginal198649c2376bbacd94125172b51704af; ?>
<?php unset($__componentOriginal198649c2376bbacd94125172b51704af); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="https://unpkg.com/lucide@latest"></script>
    <script>
        (function($) {
            "use strict";

            // Init Lucide
            lucide.createIcons();

            let curSym = `<?php echo e(gs('cur_sym')); ?>`;
            const modal = $('#detailsModal');
            const backdrop = $('#detailsBackdrop');
            const content = $('#detailsContent');

            // Open Logic
            $('.detailsBtn').on('click', function() {
                let data = $(this).data();
                let scheduleInvest = data.schedule_invest;

                // Data Injection
                modal.find('.planName').text(scheduleInvest.plan.name);
                modal.find('.investAmount').text(curSym + parseFloat(scheduleInvest.amount).toFixed(2));
                modal.find('.interestAmount').text(curSym + parseFloat(data.interest).toFixed(2));
                modal.find('.scheduleTimes').text(scheduleInvest.schedule_times);
                modal.find('.remScheduleTimes').text(scheduleInvest.rem_schedule_times);
                modal.find('.intervalHours').text(`${scheduleInvest.interval_hours} <?php echo app('translator')->get('Hours'); ?>`);
                modal.find('.nextInvest').text(data.next_invest);

                if (scheduleInvest.compound_times) {
                    modal.find('.compoundInterest').text(`${scheduleInvest.compound_times} <?php echo app('translator')->get('times'); ?>`);
                    $('#compoundInterestBlock').removeClass('hidden').addClass('flex');
                } else {
                    $('#compoundInterestBlock').addClass('hidden').removeClass('flex');
                }

                // Animation In
                modal.removeClass('hidden').addClass('flex');
                setTimeout(() => {
                    backdrop.removeClass('opacity-0').addClass('opacity-100');
                    content.removeClass('opacity-0 scale-95').addClass('opacity-100 scale-100');
                }, 10);
            });

            // Close Logic
            function closeScheduleModal() {
                backdrop.removeClass('opacity-100').addClass('opacity-0');
                content.removeClass('opacity-100 scale-100').addClass('opacity-0 scale-95');
                setTimeout(() => modal.addClass('hidden').removeClass('flex'), 300);
            }

            $('.closeDetails, #detailsBackdrop').on('click', closeScheduleModal);

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('Template::layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/user/schedule_invest.blade.php ENDPATH**/ ?>