<?php
    $promotionCount = App\Models\PromotionTool::count();
?>
<!-- ======================================
         Start Sidebar Area
    ====================================== -->
<div id="sidebarOverlay" class="fixed inset-0 bg-black/50 z-40 hidden lg:hidden transition-opacity duration-300 opacity-0"
    aria-hidden="true"></div>
<aside class="sidebar" id="sidebar">
    <!-- ======================================
       Start Logo Section
       ====================================== -->
    <div class="logo-section flex items-center gap-3 p-5 border-b border-border">
        <div class="w-10 h-10 rounded-xl flex items-center justify-center shrink-0">
            <img src="<?php echo e(siteLogo()); ?>" alt="TradeBotX Logo" class="w-8 h-8 object-contain" />
        </div>
        <div class="logo-text flex-1">
            <p class="text-lg font-bold text-text"><?php echo e(gs()->siteName); ?></p>
            <p class="text-xs text-muted">AI Trading Platform</p>
        </div>
        <button class="btn-icon w-8 h-8 lg:hidden! js-mobile-menu-toggle" aria-label="Close sidebar">
            <i data-lucide="x" class="w-5 h-5"></i>
        </button>
    </div>

    <!-- ======================================
       Start Navigation
       ====================================== -->
    <nav class="py-4">
        <!-- MAIN -->
        <div class="nav-section-title">Main</div>

        <a href="<?php echo e(route('user.home')); ?>" class="nav-item" data-tooltip="Dashboard">
            <i data-lucide="layout-dashboard" class="w-5 h-5"></i>
            <span class="nav-text">Dashboard</span>
        </a> 
 

        
        <!-- TRADING & BOTS -->
        <div class="nav-section-title">Trading & Bots</div>

        <a href="<?php echo e(route('plan')); ?>" class="nav-item" data-tooltip="Trading">
            <i data-lucide="bar-chart-2" class="w-5 h-5"></i>
            <span class="nav-text">Trading Plan</span>
        </a>
        <a href="<?php echo e(route('user.invest.log')); ?>" class="nav-item" data-tooltip="Trading">
            <i data-lucide="sprout" class="w-5 h-5"></i>
            <span class="nav-text">My Trades</span>
        </a>
         <?php if(gs('schedule_invest') || gs('staking_option') || gs('pool_option')): ?>
        <?php if(gs('staking_option')): ?>
        <a href="<?php echo e(route('user.staking.index')); ?>" class="nav-item" data-tooltip="Trading">
            <i data-lucide="pie-chart" class="w-5 h-5"></i>
            <span class="nav-text"><?php echo app('translator')->get('My Staking'); ?></span>
        </a>
        <?php endif; ?>
        <?php if(gs('pool_option')): ?>
        <a href="<?php echo e(route('user.pool.index')); ?>" class="nav-item" data-tooltip="Trading">
            <i data-lucide="droplets" class="w-5 h-5"></i>
            <span class="nav-text"><?php echo app('translator')->get('Trading Pool'); ?></span>
        </a>
        <?php endif; ?>
        <?php if(gs('schedule_invest')): ?>
        <a href="<?php echo e(route('user.invest.schedule')); ?>" class="nav-item" data-tooltip="Trading">
            <i data-lucide="calendar" class="w-5 h-5"></i>
            <span class="nav-text"><?php echo app('translator')->get('Schedule Trade'); ?></span>
        </a>
        <?php endif; ?> 
         <?php endif; ?>

         

        <!-- FINANCE & PORTFOLIO -->
        <div class="nav-section-title">Finance & Portfolio</div>

        <a href="<?php echo e(route('user.deposit.index')); ?>" class="nav-item" data-tooltip="Balance Deposit">
            <i data-lucide="credit-card" class="w-5 h-5"></i>
            <span class="nav-text"><?php echo app('translator')->get('Deposit'); ?></span>
        </a>

        <a href="<?php echo e(route('user.withdraw')); ?>" class="nav-item" data-tooltip="Balance Withdrawal">
            <i data-lucide="wallet" class="w-5 h-5"></i>
            <span class="nav-text"><?php echo app('translator')->get('Withdraw'); ?></span>
        </a>
        <?php if(gs('b_transfer')): ?>
        <a href="<?php echo e(route('user.transfer.balance')); ?>" class="nav-item" data-tooltip="User Transfer">
            <i data-lucide="layers" class="w-5 h-5"></i>
            <span class="nav-text"><?php echo app('translator')->get('Transfer'); ?></span>
        </a>
        <?php endif; ?>

        <a href="<?php echo e(route('user.transactions')); ?>" class="nav-item" data-tooltip="Liquidity Tracker">
            <i data-lucide="droplets" class="w-5 h-5"></i>
            <span class="nav-text"><?php echo app('translator')->get('Transactions'); ?></span>
        </a>
 
        <!-- MARKETPLACE -->
        <div class="nav-section-title">Marketplace</div>

        <a href="<?php echo e(route('user.referrals')); ?>" class="nav-item" data-tooltip="Referal System">
            <i data-lucide="store" class="w-5 h-5"></i>
            <span class="nav-text"><?php echo app('translator')->get('Referrals'); ?></span>
        </a>
         <?php if(gs('promotional_tool') && $promotionCount): ?>
        <a href="<?php echo e(route('user.promotional.banner')); ?>" class="nav-item" data-tooltip="Promotional Tools">
            <i data-lucide="layout-template" class="w-5 h-5"></i>
            <span class="nav-text"><?php echo app('translator')->get('Promotional Tool'); ?></span>
        </a>
        <?php endif; ?>

        <!-- ======================================
         Account Section
         ====================================== -->
        <div class="nav-section-title">Account</div>

        <a href="<?php echo e(route('user.profile.setting')); ?>" class="nav-item" data-tooltip="Preferences">
            <i data-lucide="settings" class="w-5 h-5"></i>
            <span class="nav-text">Preferences</span>
        </a>
 

        <a href="<?php echo e(route('user.change.password')); ?>" class="nav-item" data-tooltip="Security & API Keys">
            <i data-lucide="shield" class="w-5 h-5"></i>
            <span class="nav-text">Security Keys</span>
        </a>

        <a href="<?php echo e(route('user.twofactor')); ?>" class="nav-item" data-tooltip="Google 2FA">
            <i data-lucide="scan" class="w-5 h-5"></i>
            <span class="nav-text">Google 2FA</span>
        </a>
        <?php if(gs('user_ranking')): ?>
        <a href="<?php echo e(route('user.invest.ranking')); ?>" class="nav-item" data-tooltip="Leaderboard">
            <i data-lucide="crown" class="w-5 h-5"></i>
            <span class="nav-text"><?php echo app('translator')->get('Ranking'); ?></span>
            <span class="ml-auto badge bg-accent! text-white! badge-info nav-text">PRO</span>
        </a>
        <?php endif; ?>
        <a href="<?php echo e(route('ticket.index')); ?>" class="nav-item" data-tooltip="Help Center">
            <i data-lucide="help-circle" class="w-5 h-5"></i>
            <span class="nav-text">Help Center</span>
        </a>
    </nav>


    <!-- ======================================
       Start User Section
       ====================================== -->
    <div class="user-section mt-auto p-4 border-t border-border">
        <div class="flex items-center gap-3">
            <div class="w-10 h-10 rounded-full gradient-secondary flex items-center justify-center shrink-0">
                <span class="text-white font-semibold text-sm">JD</span>
            </div>
            <div class="user-info flex-1 min-w-0">
                <p class="font-semibold text-sm text-text truncate"><?php echo e(auth()->user()->fullname); ?></p>
                <p class="text-xs text-muted truncate"><?php echo e(auth()->user()->email); ?></p>
            </div>
        </div>
    </div>
</aside>


    <!-- ====================================== End Sidebar Area ====================================== -->
<?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/partials/dashboard_sidenav.blade.php ENDPATH**/ ?>