<?php $__env->startSection('content'); ?>
 <?php
        // Detect the highest ROI plan to apply the Premium UI
        $maxInterest = $plans->max('interest');
    ?>
    <div class="max-w-7xl mx-auto">
        <!-- Enhanced Header -->
        <div
            class="bg-gradient-to-br from-black via-gray-900 to-gray-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
                <div class="absolute bottom-0 left-0 w-24 h-24 bg-white rounded-full translate-y-12 -translate-x-12"></div>
            </div>

            <div class="relative z-10">
                <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                    <div class="mb-4 lg:mb-0 lg:flex-1">
                        <h1 class="text-xl font-light mb-1">Investment Plans</h1>
                        <p class="text-gray-300 text-sm">Discover and invest in diversified portfolios designed for growth
                        </p>
                    </div>

                    <!-- Enhanced Stats Card -->
                    <div
                        class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-80">
                        <div class="flex items-center justify-between mb-3">
                            <div>
                                <p class="text-xs text-gray-300 mb-1">Available Plans</p>
                                <p class="text-lg font-light"><?php echo e(count($plans)); ?></p>
                            </div>
                            <div class="w-10 h-10 flex items-center justify-center">
                                <i data-lucide="trending-up" class="w-5 h-5 text-white"></i>
                            </div>
                        </div>
                        <div class="flex space-x-4 text-xs">
                            <div class="flex-1 text-center">
                                <p class="text-gray-300">Categories</p>
                                <p class="text-white font-medium">6</p>
                            </div>
                            <div class="flex-1 text-center">
                                <p class="text-gray-300">Featured</p>
                                <p class="text-white font-medium">3</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Collapsible Search and Filters -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 mb-6">
            <div class="p-4">
                <button type="button" onclick="toggleFilters()" class="flex items-center justify-between w-full text-left">
                    <div class="flex items-center">
                        <i data-lucide="filter" class="w-4 h-4 text-gray-600 mr-2"></i>
                        <span class="text-sm font-medium text-black">Search & Filters</span>
                    </div>
                    <i data-lucide="chevron-down" id="filterIcon"
                        class="w-4 h-4 text-gray-600 transition-transform duration-200"></i>
                </button>
            </div>

            <div id="filterSection" class="hidden border-t border-gray-100">
                <form method="GET" class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                        <!-- Search -->
                        <div class="md:col-span-2">
                            <label for="search" class="block text-sm font-medium text-gray-700 mb-2">Search Plans</label>
                            <div class="relative">
                                <i data-lucide="search"
                                    class="absolute left-3 top-1/2 transform -translate-y-1/2 w-4 h-4 text-gray-400"></i>
                                <input type="text" id="search" name="search" value=""
                                    class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200"
                                    placeholder="Search by name, category, or description">
                            </div>
                        </div>

                        <!-- Category Filter -->
                        <div>
                            <label for="category" class="block text-sm font-medium text-gray-700 mb-2">Category</label>
                            <select id="category" name="category"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200">
                                <option value="">All Categories</option>
                                <option value="Conservative">Conservative</option>
                                <option value="Income">Income</option>
                                <option value="Balanced">Balanced</option>
                                <option value="Tesla-Focused">Tesla-Focused</option>
                                <option value="Growth">Growth</option>
                                <option value="ESG">ESG</option>
                            </select>
                        </div>

                        <!-- Risk Level Filter -->
                        <div>
                            <label for="risk_level" class="block text-sm font-medium text-gray-700 mb-2">Risk Level</label>
                            <select id="risk_level" name="risk_level"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200">
                                <option value="">All Risk Levels</option>
                                <option value="conservative">Conservative</option>
                                <option value="moderate">Moderate</option>
                                <option value="aggressive">Aggressive</option>
                            </select>
                        </div>

                        <!-- Sort By -->
                        <div>
                            <label for="sort" class="block text-sm font-medium text-gray-700 mb-2">Sort By</label>
                            <select id="sort" name="sort"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200">
                                <option value="name">Name A-Z</option>
                                <option value="performance">Best Performance</option>
                                <option value="nav">Lowest NAV</option>
                                <option value="risk">Risk Level</option>
                            </select>
                        </div>

                        <!-- Filter Buttons -->
                        <div class="md:col-span-4 flex space-x-3">
                            <button type="submit"
                                class="px-4 py-2 bg-black text-white text-sm font-medium rounded-lg hover:bg-gray-800 transition-colors duration-200 flex items-center">
                                <i data-lucide="filter" class="w-4 h-4 mr-2"></i>
                                Apply Filters
                            </button>
                            <a href="<?php echo e(route('plan')); ?>"
                                class="px-4 py-2 border border-gray-300 text-black text-sm font-medium rounded-lg hover:bg-gray-50 transition-colors duration-200 flex items-center">
                                <i data-lucide="refresh-cw" class="w-4 h-4 mr-2"></i>
                                Clear Filters
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Enhanced Featured Plans -->
        <div class="mb-8">
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-lg font-light text-black">Featured Plans</h2>
                <a href="#" class="text-xs text-black hover:text-gray-600 transition-colors duration-200 font-medium">
                    View All Featured
                    <i data-lucide="arrow-right" class="w-3 h-3 inline ml-1"></i>
                </a>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                $nav = \App\Models\Invest::wherePlanId($data->id)->sum('amount');
                $risk = strToLower($data->risk);
                ?>
                <div
                    class="group bg-white rounded-xl p-5 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 hover:scale-105 relative overflow-hidden">
                    <div
                        class="absolute inset-0 bg-gradient-to-br from-blue-50 to-blue-100 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                    </div>
                    <div class="relative z-10">
                        <div class="flex items-start justify-between mb-4">
                            <div class="flex-1">
                                <h3 class="font-medium text-black text-lg mb-1"><?php echo e(__($data->name)); ?></h3>
                                <p class="text-sm text-gray-600">Tesla-Focused</p>
                            </div>
                            <span
                                class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium <?php if($risk == 'low'): ?> bg-green-100 text-green-800 <?php elseif($risk == 'medium'): ?>  bg-yellow-100 text-yellow-800   <?php else: ?> bg-red-100 text-red-800 <?php endif; ?>">
                                <?php echo e($data->risk); ?>

                            </span>
                        </div>

                        <div class="space-y-3 mb-4">
                            <div class="flex justify-between">
                                <span class="text-sm text-gray-500">Current NAV:</span>
                                <span class="text-sm font-medium text-black"><?php echo e(showAmount($nav)); ?></span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-sm text-gray-500">1Y Return:</span>
                                <span class="text-sm font-medium text-green-600">
                                    +<?php echo e(showAmount($data->interest, currencyFormat: false)); ?><?php echo e($data->interest_type == 1 ? '%' : ' ' . __(gs('cur_text'))); ?>

                                </span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-sm text-gray-500">Min Investment:</span>
                                <span class="text-sm font-medium text-black">
                                <?php if($data->fixed_amount == 0): ?>
                                    <?php echo e(showAmount($data->minimum)); ?>

                                <?php else: ?>
                                    <?php echo e(showAmount($data->fixed_amount)); ?>

                                <?php endif; ?>
                                </span>
                            </div>
                        </div>

                        <div class="flex items-center justify-between">
                            <a href="<?php echo e(route('plan.details',$data->id)); ?>"
                                class="flex items-center text-blue-600 text-xs font-medium hover:text-blue-800 transition-colors duration-200">
                                <span>View Details</span>
                                <i data-lucide="arrow-right"
                                    class="w-3 h-3 ml-1 group-hover:translate-x-1 transition-transform duration-200"></i>
                            </a>
                            <a href="<?php echo e(route('plan.buy',$data->id)); ?>"
                                class="px-3 py-1 bg-black text-white text-xs font-medium rounded-lg hover:bg-gray-800 transition-colors duration-200">
                                Invest Now
                            </a>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Template::layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/plan.blade.php ENDPATH**/ ?>