<?php $__env->startSection('content'); ?>
 <?php $__env->startPush('breadcrumb_text'); ?>
    <div class="flex items-center gap-5">
        <div class="relative group">
            <div class="absolute -inset-1 bg-gradient-to-r from-emerald-500 to-blue-500 rounded-2xl blur opacity-25"></div>
            <div class="relative w-14 h-14 bg-slate-900 rounded-2xl flex items-center justify-center text-white border border-white/10 shadow-2xl">
                <i data-lucide="wallet" class="w-7 h-7 text-emerald-400"></i>
            </div>
        </div>
        <div>
            <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase"><?php echo app('translator')->get('Withdraw Preview'); ?></h2>
            <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest mt-1"><?php echo app('translator')->get('Please preview withdrawal requwst below'); ?></p>
        </div>
    </div>
    <?php $__env->stopPush(); ?>

<div class="min-h-screen py-12 px-4 flex justify-center items-start bg-slate-50/50 dark:bg-transparent">
    <div class="w-full max-w-3xl">
        
        <div class="flex items-center justify-between mb-8 px-4">
            <div class="flex items-center gap-3">
                <div class="w-2 h-2 rounded-full bg-emerald-500 animate-pulse"></div>
                <span class="text-[10px] font-black text-slate-900 dark:text-white uppercase tracking-[0.2em]"><?php echo app('translator')->get('Node Connection Stable'); ?></span>
            </div>
            <span class="text-[10px] font-bold text-slate-400 uppercase tracking-widest">ID: #<?php echo e($withdraw->trx); ?></span>
        </div>

        <div class="relative">
            <div class="absolute -top-2 -left-2 w-8 h-8 border-t-2 border-l-2 border-emerald-500/30 rounded-tl-xl"></div>
            <div class="absolute -bottom-2 -right-2 w-8 h-8 border-b-2 border-r-2 border-emerald-500/30 rounded-br-xl"></div>

            <div class="bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-[2.5rem] shadow-2xl overflow-hidden">
                
                <div class="p-10 text-center bg-gradient-to-b from-slate-50 to-white dark:from-white/[0.02] dark:to-transparent border-b border-slate-100 dark:border-white/5">
                    <div class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-white dark:bg-slate-800 shadow-xl border border-slate-100 dark:border-white/10 mb-6">
                        <img src="<?php echo e(getImage(getFilePath('withdrawMethod') . '/' . $withdraw->method->image)); ?>" class="w-8 h-8 object-contain" alt="method">
                    </div>
                    <h2 class="text-sm font-black text-slate-400 uppercase tracking-[0.4em] mb-2"><?php echo app('translator')->get('Settlement via'); ?> <?php echo e(__($withdraw->method->name)); ?></h2>
                    <div class="flex items-center justify-center gap-4">
                        <span class="text-4xl font-black text-slate-900 dark:text-white tracking-tighter"><?php echo e(showAmount($withdraw->final_amount, currencyFormat:false)); ?></span>
                        <span class="text-xl font-black text-emerald-500 uppercase"><?php echo e(__($withdraw->currency)); ?></span>
                    </div>
                </div>

                <div class="p-8 md:p-12">
                    <form action="<?php echo e(route('user.withdraw.submit')); ?>" method="post" enctype="multipart/form-data" class="space-y-10" id="withdraw-form">
                        <?php echo csrf_field(); ?>
                        
                        <div class="grid grid-cols-2 gap-4 p-6 bg-slate-50 dark:bg-white/[0.02] rounded-3xl border border-slate-100 dark:border-white/5">
                            <div class="space-y-1">
                                <p class="text-[9px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Request Amount'); ?></p>
                                <p class="text-sm font-bold text-slate-900 dark:text-white"><?php echo e(showAmount($withdraw->amount)); ?></p>
                            </div>
                            <div class="space-y-1 text-right">
                                <p class="text-[9px] font-black text-slate-400 uppercase tracking-widest"><?php echo app('translator')->get('Network Fee'); ?></p>
                                <p class="text-sm font-bold text-rose-500"><?php echo e(showAmount($withdraw->charge)); ?></p>
                            </div>
                        </div>

                        <?php if($withdraw->method->description): ?>
                        <div class="relative p-6 rounded-2xl border-l-4 border-emerald-500 bg-emerald-500/5">
                            <h5 class="text-[10px] font-black text-emerald-600 dark:text-emerald-400 uppercase tracking-widest mb-2"><?php echo app('translator')->get('Transfer Instructions'); ?></h5>
                            <div class="text-xs font-medium text-slate-600 dark:text-slate-400 leading-relaxed">
                                <?php echo $withdraw->method->description; ?>
                            </div>
                        </div>
                        <?php endif; ?>

                        <div class="viser-form-custom space-y-6">
                            <?php if (isset($component)) { $__componentOriginal3bd95de28203859144f617d3fb6afebc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3bd95de28203859144f617d3fb6afebc = $attributes; } ?>
<?php $component = App\View\Components\ViserForm::resolve(['identifier' => 'id','identifierValue' => ''.e($withdraw->method->form_id).''] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('viser-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ViserForm::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3bd95de28203859144f617d3fb6afebc)): ?>
<?php $attributes = $__attributesOriginal3bd95de28203859144f617d3fb6afebc; ?>
<?php unset($__attributesOriginal3bd95de28203859144f617d3fb6afebc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3bd95de28203859144f617d3fb6afebc)): ?>
<?php $component = $__componentOriginal3bd95de28203859144f617d3fb6afebc; ?>
<?php unset($__componentOriginal3bd95de28203859144f617d3fb6afebc); ?>
<?php endif; ?>
                        </div>

                        <?php if(auth()->user()->ts): ?>
                        <div class="relative group mt-8">
                            <div class="absolute -inset-1 bg-gradient-to-r from-rose-500/20 to-orange-500/20 rounded-2xl blur opacity-0 group-focus-within:opacity-100 transition-opacity"></div>
                            <div class="relative bg-white dark:bg-slate-950 border border-slate-200 dark:border-white/10 rounded-2xl p-6">
                                <label class="text-[10px] font-black text-slate-400 uppercase tracking-widest mb-4 flex items-center gap-2">
                                    <i data-lucide="shield-check" class="w-3.5 h-3.5 text-rose-500"></i>
                                    <?php echo app('translator')->get('Security: Google 2FA Code'); ?>
                                </label>
                                <input type="text" name="authenticator_code" class="w-full bg-transparent border-none p-0 text-2xl font-black tracking-[0.5em] text-slate-900 dark:text-white focus:ring-0 placeholder:text-slate-200 dark:placeholder:text-slate-800" required placeholder="000000">
                            </div>
                        </div>
                        <?php endif; ?>

                        <div class="pt-6">
                            <button type="submit" class="w-full group relative flex items-center justify-between px-8 py-6 bg-slate-900 dark:bg-white rounded-2xl transition-all hover:scale-[1.02] active:scale-95 shadow-2xl">
                                <span class="text-[11px] font-black text-white dark:text-slate-900 uppercase tracking-[0.4em]"><?php echo app('translator')->get('Execute Settlement'); ?></span>
                                <div class="flex items-center gap-3">
                                    <div class="h-8 w-px bg-white/10 dark:bg-slate-900/10"></div>
                                    <i data-lucide="arrow-right" class="w-5 h-5 text-emerald-400 dark:text-emerald-600 group-hover:translate-x-1 transition-transform"></i>
                                </div>
                            </button>
                            
                            <div class="mt-8 flex items-center justify-center gap-8 border-t border-slate-100 dark:border-white/5 pt-8">
                                <img src="<?php echo e(asset('assets/images/gateways/pci-compliant.png')); ?>" class="h-6 opacity-30 grayscale" alt="pci">
                                <img src="<?php echo e(asset('assets/images/gateways/ssl-secured.png')); ?>" class="h-6 opacity-30 grayscale" alt="ssl">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    /* Minimalist Ledger Form Controls */
    .viser-form-custom .form-group { margin-bottom: 1.5rem; }
    
    .viser-form-custom label {
        font-[900] text-[10px] uppercase tracking-widest text-slate-400 mb-3 block;
    }

    .viser-form-custom input:not([type="file"]), 
    .viser-form-custom select, 
    .viser-form-custom textarea {
        width: 100%;
        background-color: transparent;
        border: none;
        border-bottom: 2px solid rgba(226, 232, 240, 1);
        border-radius: 0;
        padding: 0.75rem 0;
        font-size: 1rem;
        font-weight: 700;
        color: #0f172a;
        transition: all 0.3s;
        outline: none;
    }

    .dark .viser-form-custom input:not([type="file"]),
    .dark .viser-form-custom select,
    .dark .viser-form-custom textarea {
        border-color: rgba(255, 255, 255, 0.1);
        color: white;
    }

    .viser-form-custom input:focus {
        border-color: #10b981;
    }

    /* File Input Premium "Slot" */
    .viser-form-custom input[type="file"] {
        padding: 1.5rem;
        background: rgba(248, 250, 252, 1);
        border: 1px dashed rgba(226, 232, 240, 1);
        border-radius: 1rem;
        width: 100%;
    }
    .dark .viser-form-custom input[type="file"] {
        background: rgba(255,255,255,0.02);
        border-color: rgba(255,255,255,0.1);
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script src="https://unpkg.com/lucide@latest"></script>
<script>
    "use strict";
    (function ($) {
        lucide.createIcons();
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('Template::layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/withdraw/preview.blade.php ENDPATH**/ ?>