<?php $__env->startSection('content'); ?>
    <div class="px-4 mx-auto py-8">
        <?php $__env->startPush('breadcrumb_text'); ?>
            <div class="flex items-center gap-5">
                <div class="relative group">
                    <div class="absolute -inset-1 bg-gradient-to-r from-emerald-500 to-blue-500 rounded-2xl blur opacity-25">
                    </div>
                    <div
                        class="relative w-14 h-14 bg-slate-900 rounded-2xl flex items-center justify-center text-white border border-white/10 shadow-2xl">
                        <i data-lucide="printer" class="w-7 h-7 text-emerald-400"></i>
                    </div>
                </div>
                <div>
                    <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase"><?php echo app('translator')->get('Referal System'); ?>
                    </h2>
                    <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest mt-1"><?php echo app('translator')->get('Refer to earn bonuses on transactions'); ?></p>
                </div>
            </div>
        <?php $__env->stopPush(); ?>


        <!-- Referral Link Card -->
        <div class="referral-card max-sm:p-3! mb-8">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <div>
                    <div class="flex items-center gap-3 mb-4">
                        <div class="w-12 h-12 rounded-xl gradient-primary flex items-center justify-center pulse-glow">
                            <i data-lucide="link" class="w-6 h-6 text-white"></i>
                        </div>
                        <div>
                            <h3 class="text-lg font-bold">Your Referral Link</h3>
                            <p class="text-sm text-muted">Share this link to earn rewards</p>
                        </div>
                    </div>
                    <div class="copy-input-wrapper mb-4">
                        <input type="text" value="<?php echo e(route('home')); ?>?reference=<?php echo e(auth()->user()->username); ?>" readonly
                            class="referralURL max-[350px]:px-2! max-[350px]:py-2!" />
                        <button class="js-copy-link copytext copyBoard" id="copyBoard">
                            <i data-lucide="copy" class="w-4 h-4 inline mr-1 max-[350px]:hidden"></i>
                            Copy
                        </button>
                    </div>
                    <div class="flex flex-wrap gap-3">
                        <button class="share-btn share-btn-twitter js-share-twitter">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                <path
                                    d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z" />
                            </svg>
                            Twitter
                        </button>
                        <button class="share-btn share-btn-telegram js-share-telegram">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                <path
                                    d="M11.944 0A12 12 0 0 0 0 12a12 12 0 0 0 12 12 12 12 0 0 0 12-12A12 12 0 0 0 12 0a12 12 0 0 0-.056 0zm4.962 7.224c.1-.002.321.023.465.14a.506.506 0 0 1 .171.325c.016.093.036.306.02.472-.18 1.898-.962 6.502-1.36 8.627-.168.9-.499 1.201-.82 1.23-.696.065-1.225-.46-1.9-.902-1.056-.693-1.653-1.124-2.678-1.8-1.185-.78-.417-1.21.258-1.91.177-.184 3.247-2.977 3.307-3.23.007-.032.014-.15-.056-.212s-.174-.041-.249-.024c-.106.024-1.793 1.14-5.061 3.345-.48.33-.913.49-1.302.48-.428-.008-1.252-.241-1.865-.44-.752-.245-1.349-.374-1.297-.789.027-.216.325-.437.893-.663 3.498-1.524 5.83-2.529 6.998-3.014 3.332-1.386 4.025-1.627 4.476-1.635z" />
                            </svg>
                            Telegram
                        </button>
                        <button class="share-btn share-btn-discord js-share-discord">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                <path
                                    d="M20.317 4.3698a19.7913 19.7913 0 00-4.8851-1.5152.0741.0741 0 00-.0785.0371c-.211.3753-.4447.8648-.6083 1.2495-1.8447-.2762-3.68-.2762-5.4868 0-.1636-.3933-.4058-.8742-.6177-1.2495a.077.077 0 00-.0785-.037 19.7363 19.7363 0 00-4.8852 1.515.0699.0699 0 00-.0321.0277C.5334 9.0458-.319 13.5799.0992 18.0578a.0824.0824 0 00.0312.0561c2.0528 1.5076 4.0413 2.4228 5.9929 3.0294a.0777.0777 0 00.0842-.0276c.4616-.6304.8731-1.2952 1.226-1.9942a.076.076 0 00-.0416-.1057c-.6528-.2476-1.2743-.5495-1.8722-.8923a.077.077 0 01-.0076-.1277c.1258-.0943.2517-.1923.3718-.2914a.0743.0743 0 01.0776-.0105c3.9278 1.7933 8.18 1.7933 12.0614 0a.0739.0739 0 01.0785.0095c.1202.099.246.1981.3728.2924a.077.077 0 01-.0066.1276 12.2986 12.2986 0 01-1.873.8914.0766.0766 0 00-.0407.1067c.3604.698.7719 1.3628 1.225 1.9932a.076.076 0 00.0842.0286c1.961-.6067 3.9495-1.5219 6.0023-3.0294a.077.077 0 00.0313-.0552c.5004-5.177-.8382-9.6739-3.5485-13.6604a.061.061 0 00-.0312-.0286zM8.02 15.3312c-1.1825 0-2.1569-1.0857-2.1569-2.419 0-1.3332.9555-2.4189 2.157-2.4189 1.2108 0 2.1757 1.0952 2.1568 2.419 0 1.3332-.9555 2.4189-2.1569 2.4189zm7.9748 0c-1.1825 0-2.1569-1.0857-2.1569-2.419 0-1.3332.9554-2.4189 2.1569-2.4189 1.2108 0 2.1757 1.0952 2.1568 2.419 0 1.3332-.946 2.4189-2.1568 2.4189Z" />
                            </svg>
                            Discord
                        </button>
                        <button class="share-btn share-btn-whatsapp js-share-whatsapp">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                <path
                                    d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413Z" />
                            </svg>
                            WhatsApp
                        </button>
                    </div>
                </div>
                <div class="flex flex-col items-center justify-center">
                    <div class="progress-ring mb-4">
                        <svg width="120" height="120">
                            <circle class="progress-ring-bg" cx="60" cy="60" r="52" />
                            <circle class="progress-ring-fill" cx="60" cy="60" r="52"
                                stroke="url(#progressGradient)" stroke-dasharray="326.56" stroke-dashoffset="81.64" />
                            <defs>
                                <linearGradient id="progressGradient" x1="0%" y1="0%" x2="100%"
                                    y2="100%">
                                    <stop offset="0%" style="stop-color: #6366f1" />
                                    <stop offset="100%" style="stop-color: #ec4899" />
                                </linearGradient>
                            </defs>
                        </svg>
                        <div class="progress-ring-center">
                            <p class="text-2xl font-bold text-gradient">75%</p>
                            <p class="text-xs text-muted">to Gold</p>
                        </div>
                    </div>
                    <p class="text-center text-sm text-muted">Invite 3 more friends to unlock <span
                            class="text-yellow-500 font-semibold">Gold Tier</span></p>
                </div>
            </div>
        </div>

        <!-- Tabs -->
        <div class="mb-6">
            <div class="tab-container">
                <button class="tab-button active js-tab-button" data-tab="referrals">My Referrals</button>
                <button class="tab-button js-tab-button" data-tab="rewards">Rewards History</button>
                <?php if($user->allReferrals->count() > 0 && $maxLevel > 0): ?>
                    <button class="tab-button js-tab-button" data-tab="leaderboard">Leaderboard</button>
                <?php endif; ?>
            </div>
        </div>

        <!-- Tab Content: My Referrals -->
        <div class="tab-content active" id="tab-referrals">
            <div class="card-static p-3 sm:p-6">
                <!-- Filters -->


                <!-- Table -->
                <div class="overflow-x-auto">
                    <table class="data-table whitespace-nowrap min-w-200">
                        <thead>
                            <tr>
                                <th>User</th>
                                <th>Joined</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $referals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ref): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="referral-row js-referral-row" data-id="1">
                                    <td>
                                        <div class="flex items-center gap-3">
                                            <div
                                                class="w-10 h-10 rounded-full bg-gradient-to-br from-emerald-500 to-blue-500 flex items-center justify-center shadow-lg border border-white/10">
                                                <span class="text-xs font-black text-primary uppercase tracking-tighter">
                                                    <?php echo e(substr($ref->fullname, 0, 2)); ?>

                                                </span>
                                            </div>
                                            <div>
                                                <p class="font-medium"><?php echo e($ref->fullname); ?>.</p>
                                                <p class="text-xs text-muted"><?php echo e($ref->username); ?></p>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <p class="text-sm"><?php echo e(showDateTime($ref->created_at, 'd M, Y')); ?></p>
                                        <p class="text-xs text-muted"><?php echo e(diffForHumans($ref->created_at)); ?></p>
                                    </td>
                                    <td><span
                                            class="badge <?php if($ref->status == 1): ?> badge-success <?php else: ?> badge-danger <?php endif; ?>">
                                            <?php if($ref->status == 1): ?>
                                                Active
                                            <?php else: ?>
                                                Inactive
                                            <?php endif; ?>
                                        </span></td>

                                </tr>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="px-8 py-24 text-center" colspan="100%">
                                        <div class="flex flex-col items-center opacity-30">
                                            <i data-lucide="layers" class="w-12 h-12 mb-4"></i>
                                            <p class="text-[10px] font-black uppercase tracking-[0.3em]">
                                                Data Not Found</p>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="flex flex-col sm:flex-row items-center justify-between gap-4 mt-6 pt-6 border-t border-border">

                </div>
            </div>
        </div>

        <!-- Tab Content: Rewards History -->
        <div class="tab-content" id="tab-rewards">
            <div class="card-static p-3 sm:p-6">
                <div class="flex flex-col lg:flex-row lg:items-center justify-between gap-4 mb-6">
                    <h3 class="text-lg font-semibold">Rewards History</h3>
                </div>

                <!-- Rewards Chart -->
                <div class="mb-6 p-4 bg-bg rounded-xl h-100">
                    <canvas id="rewardsChart"></canvas>
                </div>

                <!-- Rewards Table -->
                <div class="overflow-x-asuto">
                    <table class="data-table whitespace-nowrap">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Type</th>
                                <th>Amount</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $history; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr
                                    class="group hover:bg-slate-50/50 dark:hover:bg-white/[0.01] transition-all duration-300">
                                    <td>
                                        <p class="text-sm"><?php echo e(showDateTime($data->created_at, 'd M, Y')); ?></p>
                                        <p class="text-xs text-muted"><?php echo e(diffForHumans($data->created_at)); ?></p>
                                    </td>
                                    <td><span class="badge badge-info"><?php echo e($data->remark); ?></span></td>
                                    <td class="text-green-500 font-medium">+ <?php echo e(showAmount($data->amount)); ?></td>
                                    <td><span class="badge badge-success">Paid</span></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr
                                    class="group hover:bg-slate-50/50 dark:hover:bg-white/[0.01] transition-all duration-300">
                                    <td class="px-8 py-24 text-center" colspan="100%">
                                        <div class="flex flex-col items-center opacity-30">
                                            <i data-lucide="layers" class="w-12 h-12 mb-4"></i>
                                            <p class="text-[10px] font-black uppercase tracking-[0.3em]">
                                                Data Not Found</p>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Tab Content: Leaderboard -->
        <div class="tab-content" id="tab-leaderboard">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Top 3 -->
                <div class="card-static p-3 sm:p-6">

                    <?php if($user->allReferrals->count() > 0 && $maxLevel > 0): ?>
                        <div class="treeview-container">
                            <ul class="treeview">
                                <li class="items-expanded"> <?php echo e($user->fullname); ?> ( <?php echo e($user->username); ?> )
                                    <?php echo $__env->make('Template::partials.under_tree', [
                                        'user' => $user,
                                        'layer' => 0,
                                        'isFirst' => true,
                                    ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                                </li>
                            </ul>
                        </div>
                    <?php endif; ?>

                </div>

            </div>
        </div>
    <?php $__env->stopSection(); ?>

    <?php $__env->startPush('style-lib'); ?>
        <link href="<?php echo e(asset('assets/global/css/jquery.treeView.css')); ?>" rel="stylesheet" type="text/css">
    <?php $__env->stopPush(); ?>

    <?php $__env->startPush('script'); ?>
        <script src="<?php echo e(asset('assets/global/js/jquery.treeView.js')); ?>"></script>
        <script>
            (function($) {
                "use strict"
                $('.treeview').treeView();
                $('.copyBoard').click(function() {
                    var copyText = document.getElementsByClassName("referralURL");
                    copyText = copyText[0];
                    copyText.select();
                    copyText.setSelectionRange(0, 99999);

                    /*For mobile devices*/
                    document.execCommand("copy");
                    copyText.blur();
                    this.classList.add('copied');
                    setTimeout(() => this.classList.remove('copied'), 1500);
                });
            })(jQuery);
        </script>
    <?php $__env->stopPush(); ?>

<?php echo $__env->make('Template::layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/referrals.blade.php ENDPATH**/ ?>