 
 <?php $__env->startSection('content'); ?>
     <div class="w-full max-w-sm">
         <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
             <!-- Enhanced Header -->
             <div class="px-6 py-6 text-center">
                 <h1 class="text-xl font-light text-black mb-1">Reset Password</h1>
                 <p class="text-xs text-gray-500">Enter your email to receive a reset link</p>
             </div>

             <!-- Session Status -->

             <!-- Reset Form -->
             <div class="px-6 pb-6">
                 <div class="mb-4 text-xs text-gray-500 text-center">
                     Forgot your password? No problem. Just let us know your email address and we will email you a password
                     reset
                     link that will allow you to choose a new one.
                 </div>

                 <form action="<?php echo e(route('user.password.email')); ?>" method="POST" class="verify-gcaptcha space-y-4">
                     <?php echo csrf_field(); ?>

                     <?php if(session('status')): ?>
                         <div
                             class="rounded-lg bg-emerald-50 p-4 border border-emerald-100 text-sm font-medium text-emerald-800">
                             <?php echo e(session('status')); ?>

                         </div>
                     <?php endif; ?>

                     <!-- Email Address -->
                     <div>
                         <label for="email" class="block text-xs font-medium text-black mb-1">Email</label>
                         <input type="email" id="value" name="value" type="text" value="<?php echo e(old('value')); ?>"
                             required autofocus
                             class="w-full px-3 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200 ">
                     </div>

                     <!-- Submit Button -->
                     <div class="pt-2">
                         <button type="submit"
                             class="w-full bg-black hover:bg-gray-800 text-white py-2.5 px-4 rounded-lg text-sm font-medium transition-all duration-200">
                             Email Password Reset Link
                         </button>
                     </div>
                 </form>
             </div>

             <!-- Back to Login Link -->
             <div class="px-6 py-4 bg-gray-50 border-t border-gray-100 text-center">
                 <p class="text-xs text-gray-500">
                     Remember your password?
                     <a href="<?php echo e(route('user.login')); ?>"
                         class="text-black hover:text-gray-600 font-medium transition-colors duration-200">
                         Sign in
                     </a>
                 </p>
             </div>
         </div>
     </div>
 <?php $__env->stopSection(); ?>

<?php echo $__env->make('Template::layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/user/auth/passwords/email.blade.php ENDPATH**/ ?>