
        <?php
            $plans = \App\Models\Plan::with('timeSetting')->whereHas('timeSetting')->get();
        ?>
<!--==========================  Pricing Section Start  ==========================-->
            <section class="pricing-section bg--black-two py-120">
                <div class="container position-relative">
                    <div class="pricing-shape d-none d-lg-block">
                        <img src="<?php echo e(asset('assets/frontend/svg/analysis-1.svg')); ?>" alt="star">
                        <img src="<?php echo e(asset('assets/frontend/svg/analysis-2.svg')); ?>" alt="star">
                    </div>
                    <div class="row row-gap-3 ">
                        <div class="col-lg-6 align-self-end">
                            <div class="section-content">
                                <h6 class="right-reveal">Pricing Plan</h6>
                                <h2 class="mb-0 right-reveal">Our Pricing Plan</h2>
                            </div>
                        </div>
                        <div class="col-lg-6 align-self-end">
                            <div class="section-content">
                                <p class="right-reveal">Trade Mastery, we believe great traders aren't born they’re
                                    built through
                                    the right tools,
                                    education, and support. Our mission is simple: to empower every client with the
                                    resources they
                                    need to grow, succeed, and master.</p>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-60 row-gap-4 justify-content-center">
                        <div class="col-12 bottom-reveal">
                            <div class="pricing-slide swiper">
                                <div class="swiper-wrapper">
                                    <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="swiper-slide">
                                        <div class="pricing-content">
                                            <div class="pricing-header">
                                                <h6 class="mb-2"><?php echo e(__($plan->name)); ?></h6>
                                                <h2 class="mb-2"><?php echo e(showAmount($plan->interest)); ?><?php echo e($plan->interest_type == 1 ? '%' : ' ' . $general->cur_text); ?><sub class="fs-16 fw-normal">/<?php echo e(__($plan->timeSetting->name)); ?> </sub></h2>
                                                <p>Free Advertisement</p>
                                            </div>
                                            <div class="pricing-body">
                                                <ul>
                                                    <li><?php echo e($plan->lifetime == 0 ? $plan->repeat_time : 'Unlimited'); ?></li>
                                                    <li><?php echo e($plan->featured ? 'Priority Protocol' : 'Standard'); ?></li>
                                                     <?php if($plan->fixed_amount > 0): ?>
                                                    <li><?php echo e(showAmount($plan->fixed_amount)); ?></li>
                                                    <?php else: ?>
                                                    <li><?php echo e(showAmount($plan->minimum)); ?> - <?php echo e(showAmount($plan->maximum)); ?></li>
                                                    <?php endif; ?>
                                                    <li>Swap Free Option Available</li>
                                                    <li>Email Support Only</li>
                                                </ul>
                                            </div>
                                            <div class="pricing-footer">
                                                <a href="<?php echo e(route('user.login')); ?>" class="btn btn--black-two">Choose Plan</a>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                     
                                </div>
                                <div class="swiper-pagination"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--==========================  Pricing Section End  ==========================-->
             <?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/partials/plan.blade.php ENDPATH**/ ?>