<?php
    $preloader = getContent('preloader.content', true);
?>
<!doctype html>
<html lang="en" class="dark">

<head>
    <script>
        if (localStorage.getItem("theme") === "light") document.documentElement.classList.remove("dark");
    </script>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> <?php echo e(gs()->siteName(__($pageTitle))); ?></title>
    <?php echo $__env->yieldPushContent('style'); ?>
    <?php echo $__env->make('partials.seo', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    
    
    <script src="<?php echo e(asset('assets/dashboard/js/tailwind.js')); ?>"></script>
    <link rel="stylesheet" href="https://maxst.icons8.com/vue-static/landings/line-awesome/line-awesome/1.3.0/css/line-awesome.min.css">
    <link href="<?php echo e(asset('assets/dashboard/css/index.css')); ?>" rel="stylesheet">
   
</head>
<?php echo loadExtension('google-analytics') ?>

<body id="dashboards" class="">    
    <div id="loader">
        <div class="spinner"></div>
        <div class="loader-text"><?php echo e(env('APP_NAME')); ?>...</div>
    </div>
    <!-- ======================================
           Start Sidenav Area
           ====================================== -->
    <?php echo $__env->make('Template::partials.dashboard_sidenav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- ======================================
           End Sidenav Area
           ====================================== -->
    <!-- Main Content -->
<main class="main-content text-slate-700 dark:text-slate-200" id="mainContent">        <!-- ======================================
           Start Header Area
           ====================================== -->

        <?php echo $__env->make('Template::partials.dashboard_header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <!-- ======================================
           End Header Area
           ====================================== -->

        <!-- ======================================
           Start Page Content
           ====================================== -->
        <div class="inner-content">

            <?php echo $__env->make('Template::partials.dashboard_breadcrumb', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </main>

            <!-- ======================================
           End Page Content
           ====================================== -->

            <?php
                $cookie = App\Models\Frontend::where('data_keys', 'cookie.data')->first();
            ?>
            <?php if($cookie->data_values->status == Status::ENABLE && !\Cookie::get('gdpr_cookie')): ?>
                <div
            class="cookies-card fixed bottom-8 left-8 z-[9999] max-w-[380px] transition-all duration-700 translate-y-[200%] opacity-0 hide">
            <div
                class="relative bg-white/80 dark:bg-slate-900/80 backdrop-blur-xl border border-slate-200 dark:border-white/10 p-8 rounded-[2.5rem] shadow-[0_20px_50px_rgba(0,0,0,0.1)] dark:shadow-emerald-500/5">

                <div class="absolute top-4 right-8 flex items-center gap-2">
                    <span class="w-1.5 h-1.5 rounded-full bg-emerald-500 animate-pulse"></span>
                    <span class="text-[8px] font-black text-slate-400 uppercase tracking-widest">Active</span>
                </div>

                <div class="flex items-start gap-5">
                    <div
                        class="shrink-0 w-12 h-12 bg-slate-900 dark:bg-white text-white dark:text-slate-900 rounded-2xl flex items-center justify-center shadow-lg">
                        <i data-lucide="shield-check" class="w-6 h-6"></i>
                    </div>

                    <div class="space-y-3">
                        <h5 class="text-sm font-black text-slate-900 dark:text-white uppercase tracking-tight italic">
                            Privacy Protocol</h5>
                        <p class="text-xs font-medium text-slate-500 dark:text-slate-400 leading-relaxed">
                            <?php echo e(__($cookie->data_values->short_desc)); ?>

                            <a href="<?php echo e(route('cookie.policy')); ?>"
                                class="text-emerald-500 hover:text-emerald-600 font-bold underline underline-offset-4"
                                target="_blank">
                                <?php echo app('translator')->get('Review Policy'); ?>
                            </a>
                        </p>
                    </div>
                </div>

                <div class="mt-8 flex gap-3">
                    <button href="javascript:void(0)"
                        class="policy flex-1 py-4 bg-slate-950 dark:bg-white text-white dark:text-slate-950 rounded-2xl font-black text-[10px] uppercase tracking-[0.2em] transition-all hover:bg-emerald-500 hover:text-white shadow-lg shadow-slate-900/10 active:scale-95">
                        <?php echo app('translator')->get('Accept Protocol'); ?>
                    </button>
                </div>
            </div>
        </div>

        <style>
            /* Handled via JS to toggle classes, but initial state for 'hide' logic */
            .cookies-card.show {
                transform: translateY(0);
                opacity: 1;
            }
        </style>
                <!-- cookies dark version end -->
            <?php endif; ?>

            <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js" defer></script>
            <script src="https://cdn.jsdelivr.net/npm/chart.js" defer></script>
            <script defer src="<?php echo e(asset('assets/dashboard/js/index.js')); ?>"></script>
            <script src="<?php echo e(asset('assets/global/js/jquery-3.7.1.min.js')); ?>"></script>

            <?php echo $__env->yieldPushContent('script-lib'); ?>

            <?php echo loadExtension('tawk-chat') ?>

            <?php echo $__env->make('partials.notify', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <?php if(gs('pn')): ?>
                <?php echo $__env->make('partials.push_script', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php endif; ?>
            <?php echo $__env->yieldPushContent('script'); ?>
 

</body>

</html>
<?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/layouts/dashboard.blade.php ENDPATH**/ ?>