<?php $__env->startSection('content'); ?>
    <div class="fixed top-0 left-0 w-full h-1 bg-transparent z-[100]">
        <div id="readingProgress" class="h-full bg-emerald-500 w-0 transition-all duration-100"></div>
    </div>

    <section class="py-24 bg-[#F8FAFC] dark:bg-slate-950">
        <div class="container mx-auto px-6">
            <div class="row gy-5">
                <div class="col-lg-8">
                    <article class="bg-white dark:bg-slate-900 rounded-[3rem] overflow-hidden shadow-sm border border-slate-200 dark:border-white/5">
                        
                        <div class="relative h-[450px] overflow-hidden group">
                            <img src="<?php echo e(frontendImage('blog', @$blog->data_values->image, '920x480')); ?>" 
                                 class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-1000" alt="Cover">
                            <div class="absolute inset-0 bg-gradient-to-t from-slate-950/80 via-transparent to-transparent"></div>
                            
                            <div class="absolute bottom-8 left-8">
                                <span class="px-4 py-2 bg-emerald-500 text-white text-[10px] font-black uppercase tracking-widest rounded-lg shadow-lg">
                                    Market Intelligence
                                </span>
                            </div>
                        </div>

                        <div class="p-8 md:p-16">
                            <div class="flex items-center gap-6 mb-8 opacity-60">
                                <span class="text-[10px] font-black text-slate-500 uppercase tracking-widest flex items-center gap-2">
                                    <i data-lucide="calendar" class="w-3 h-3"></i> <?php echo e(@$blog->created_at->format('M d, Y')); ?>

                                </span>
                                <span class="w-1 h-1 rounded-full bg-slate-300"></span>
                                <span class="text-[10px] font-black text-slate-500 uppercase tracking-widest flex items-center gap-2">
                                    <i data-lucide="clock" class="w-3 h-3"></i> 5 Min Read
                                </span>
                            </div>

                            <h2 class="text-4xl md:text-5xl font-black text-slate-900 dark:text-white uppercase tracking-tighter leading-none mb-10 italic">
                                <?php echo e(__(@$blog->data_values->title)); ?>

                            </h2>

                            <div class="prose prose-slate dark:prose-invert max-w-none 
                                        prose-p:text-lg prose-p:leading-relaxed prose-p:text-slate-600 dark:prose-p:text-slate-400 
                                        prose-headings:font-black prose-headings:uppercase prose-headings:tracking-tighter
                                        prose-img:rounded-[2rem] prose-strong:text-emerald-500">
                                <?php echo @$blog->data_values->description ?>
                            </div>

                            <div class="mt-16 pt-10 border-t border-slate-100 dark:border-white/5 flex flex-wrap items-center justify-between gap-6">
                                <h4 class="text-[10px] font-black text-slate-400 uppercase tracking-[0.4em]">Distribute Intelligence //</h4>
                                <div class="flex items-center gap-4">
                                    <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(urlencode(url()->current())); ?>" class="w-12 h-12 rounded-xl bg-slate-50 dark:bg-white/5 flex items-center justify-center hover:bg-emerald-500 hover:text-white transition-all">
                                        <i class="fab fa-facebook-f text-sm"></i>
                                    </a>
                                    <a href="https://twitter.com/intent/tweet?text=<?php echo e(__(@$blog->data_values->title)); ?>&amp;url=<?php echo e(urlencode(url()->current())); ?>" class="w-12 h-12 rounded-xl bg-slate-50 dark:bg-white/5 flex items-center justify-center hover:bg-emerald-500 hover:text-white transition-all">
                                        <i class="fab fa-twitter text-sm"></i>
                                    </a>
                                    <a href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo e(urlencode(url()->current())); ?>" class="w-12 h-12 rounded-xl bg-slate-50 dark:bg-white/5 flex items-center justify-center hover:bg-emerald-500 hover:text-white transition-all">
                                        <i class="fab fa-linkedin-in text-sm"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </article>

                     
                </div>

                <div class="col-lg-4 mt-4">
                    <div class="sticky top-24 space-y-8">
                        
                        

                        <div class="p-8 bg-emerald-500 rounded-[2.5rem] relative overflow-hidden group">
                            <div class="relative z-10">
                                <h4 class="text-2xl font-black text-white uppercase tracking-tighter leading-tight mb-4">Start Institutional Trading</h4>
                                <p class="text-emerald-100 text-sm mb-6">Access global markets with precision engineering.</p>
                                <a href="/register" class="inline-block px-6 py-3 bg-white text-emerald-600 rounded-xl text-[10px] font-black uppercase tracking-widest">Get Started</a>
                            </div>
                            <i data-lucide="trending-up" class="absolute -bottom-4 -right-4 w-32 h-32 text-white/10 group-hover:scale-110 transition-transform"></i>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    // Reading Progress Logic
    window.onscroll = function() {
        let winScroll = document.body.scrollTop || document.documentElement.scrollTop;
        let height = document.documentElement.scrollHeight - document.documentElement.clientHeight;
        let scrolled = (winScroll / height) * 100;
        document.getElementById("readingProgress").style.width = scrolled + "%";
    };
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('Template::layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/blog_details.blade.php ENDPATH**/ ?>