<?php $__env->startSection('content'); ?>
<div class="px-4 mx-auto py-10">

    <div class="flex flex-col md:flex-row md:items-center justify-between gap-6 mb-12">
        <?php $__env->startPush('breadcrumb_text'); ?>
        <div class="flex items-center gap-5">
            <div class="relative group">
                <div class="absolute -inset-1 bg-gradient-to-r from-emerald-500 to-blue-500 rounded-2xl blur opacity-25"></div>
                <div class="relative w-14 h-14 bg-slate-900 rounded-2xl flex items-center justify-center text-white border border-white/10 shadow-2xl">
                    <i data-lucide="history" class="w-7 h-7 text-emerald-400"></i>
                </div>
            </div>
            <div>
                <h2 class="text-2xl font-black text-slate-900 dark:text-white tracking-tighter uppercase"><?php echo app('translator')->get('Deposit Registry'); ?></h2>
                <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest mt-1"><?php echo app('translator')->get('All inbound asset movements'); ?></p>
            </div>
        </div>
        <?php $__env->stopPush(); ?>

        <div class="flex items-center gap-4">
            <form action="" method="GET" class="relative group">
                <div class="absolute inset-y-0 left-4 flex items-center pointer-events-none">
                    <i data-lucide="search" class="w-4 h-4 text-slate-400 group-hover:text-emerald-500 transition-colors"></i>
                </div>
                <input type="text" name="search" value="<?php echo e(request()->search); ?>" placeholder="<?php echo app('translator')->get('Search TRX ID...'); ?>" 
                    class="w-full md:w-72 bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 rounded-xl py-3 pl-12 pr-4 text-[11px] font-black uppercase tracking-widest focus:ring-2 focus:ring-emerald-500 transition-all outline-none text-slate-900 dark:text-white">
            </form>
        </div>
    </div>

    <div class="relative">
        <div class="absolute -inset-0.5 bg-gradient-to-r from-emerald-500/10 via-cyan-500/5 to-blue-500/10 rounded-[2.5rem] blur-sm"></div>
        <div class="glass-vault border border-slate-200 dark:border-white/10 bg-white/50 dark:bg-slate-900/50 backdrop-blur-xl rounded-xl overflow-hidden shadow-sm">
        <div class="overflow-x-auto">
            <table class="w-full text-left border-collapse">
                    <thead>
                        <tr class="border-b border-slate-100 dark:border-white/5">
                            <th class="px-8 py-6 text-[10px] font-black uppercase tracking-[0.2em] text-slate-400"><?php echo app('translator')->get('Gateway | Reference'); ?></th>
                            <th class="px-8 py-6 text-[10px] font-black uppercase tracking-[0.2em] text-slate-400"><?php echo app('translator')->get('Initiated'); ?></th>
                            <th class="px-8 py-6 text-[10px] font-black uppercase tracking-[0.2em] text-slate-400"><?php echo app('translator')->get('Staked Amount'); ?></th>
                            <th class="px-8 py-6 text-[10px] font-black uppercase tracking-[0.2em] text-slate-400"><?php echo app('translator')->get('Conversion Rate'); ?></th>
                            <th class="px-8 py-6 text-[10px] font-black uppercase tracking-[0.2em] text-slate-400"><?php echo app('translator')->get('Status'); ?></th>
                            <th class="px-8 py-6 text-[10px] font-black uppercase tracking-[0.2em] text-slate-400 text-right"><?php echo app('translator')->get('Details'); ?></th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-50 dark:divide-white/[0.03]">
                        <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="group hover:bg-slate-50/80 dark:hover:bg-white/[0.02] transition-all">
                                <td class="px-8 py-6">
                                    <div class="flex flex-col">
                                        <span class="text-xs font-black text-slate-900 dark:text-white uppercase tracking-tighter"><?php echo e(__($deposit->gateway?->name)); ?></span>
                                        <span class="text-[9px] font-mono font-bold text-slate-400 mt-1 uppercase"><?php echo e($deposit->trx); ?></span>
                                    </div>
                                </td>
                                <td class="px-8 py-6">
                                    <div class="flex flex-col">
                                        <span class="text-xs font-bold text-slate-700 dark:text-slate-300"><?php echo e(showDateTime($deposit->created_at, 'd M, Y')); ?></span>
                                        <span class="text-[9px] font-bold text-slate-400 uppercase tracking-tighter"><?php echo e(diffForHumans($deposit->created_at)); ?></span>
                                    </div>
                                </td>
                                <td class="px-8 py-6">
                                    <div class="flex flex-col">
                                        <span class="text-xs font-black text-slate-900 dark:text-white">
                                            <?php echo e(showAmount($deposit->amount)); ?>

                                        </span>
                                        <span class="text-[9px] font-bold text-rose-500 mt-0.5">
                                            + <?php echo e(showAmount($deposit->charge)); ?> <?php echo app('translator')->get('Fee'); ?>
                                        </span>
                                    </div>
                                </td>
                                <td class="px-8 py-6">
                                    <div class="flex flex-col">
                                        <span class="text-[10px] font-black text-slate-400 uppercase tracking-widest">
                                            1 <?php echo e(gs('cur_text')); ?> = <?php echo e(showAmount($deposit->rate, false)); ?> <?php echo e(__($deposit->method_currency)); ?>

                                        </span>
                                        <span class="text-xs font-black text-emerald-500 mt-1">
                                            <?php echo e(showAmount($deposit->final_amount, false)); ?> <?php echo e(__($deposit->method_currency)); ?>

                                        </span>
                                    </div>
                                </td>
                                <td class="px-8 py-6">
                                    <?php echo $deposit->statusBadge ?>
                                </td>
                                
                                <?php
                                    $details = [];
                                    if ($deposit->method_code >= 1000 && $deposit->method_code <= 5000) {
                                        foreach (@$deposit->detail ?? [] as $key => $info) {
                                            $details[] = $info;
                                            if ($info->type == 'file') {
                                                $details[$key]->value = route('user.download.attachment', encrypt(getFilePath('verify') . '/' . $info->value));
                                            }
                                        }
                                    }
                                ?>

                                <td class="px-8 py-6 text-right">
                                    <?php if($deposit->method_code >= 1000 && $deposit->method_code <= 5000): ?>
                                        <button class="detailBtn group/btn w-10 h-10 rounded-xl bg-slate-900 dark:bg-white flex items-center justify-center transition-all hover:scale-110 active:scale-95 shadow-lg" 
                                            data-info="<?php echo e(json_encode($details)); ?>" 
                                            <?php if($deposit->status == Status::PAYMENT_REJECT): ?> data-admin_feedback="<?php echo e($deposit->admin_feedback); ?>" <?php endif; ?>>
                                            <i data-lucide="layout-panel-top" class="w-4 h-4 text-white dark:text-slate-900"></i>
                                        </button>
                                    <?php else: ?>
                                        <div class="flex justify-end">
                                            <div class="w-10 h-10 rounded-xl bg-emerald-500/10 flex items-center justify-center" data-bs-toggle="tooltip" title="<?php echo app('translator')->get('Auto-Settled'); ?>">
                                                <i data-lucide="shield-check" class="w-4 h-4 text-emerald-500"></i>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="100%" class="px-8 py-24 text-center">
                                    <div class="flex flex-col items-center gap-3">
                                        <i data-lucide="file-x" class="w-12 h-12 text-slate-200"></i>
                                        <p class="text-[10px] font-black text-slate-400 uppercase tracking-[0.4em]"><?php echo app('translator')->get('No transaction packets found'); ?></p>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <?php if($deposits->hasPages()): ?>
        <div class="mt-12">
            <?php echo e(paginateLinks($deposits)); ?>

        </div>
    <?php endif; ?>
</div>

<div id="detailModal" class="hidden fixed inset-0 z-[1000] overflow-y-auto">
    <div class="fixed inset-0 bg-slate-900/80 backdrop-blur-md transition-opacity duration-300 opacity-0" id="modalBackdrop"></div>
    
    <div class="flex min-h-full items-center justify-center p-4">
        <div class="relative w-full max-w-md transform overflow-hidden rounded-[2.5rem] bg-white dark:bg-slate-900 p-8 shadow-2xl transition-all scale-95 opacity-0 duration-300 border border-slate-200 dark:border-white/10" id="modalContent">
            
            <div class="absolute top-0 inset-x-0 h-1.5 bg-gradient-to-r from-emerald-500 via-cyan-500 to-blue-500"></div>
            
            <div class="flex items-center justify-between mb-8">
                <h3 class="text-[11px] font-black text-slate-900 dark:text-white uppercase tracking-[0.4em]">
                    <?php echo app('translator')->get('Provisioning Data'); ?>
                </h3>
                <button type="button" class="closeModal p-2 hover:bg-slate-100 dark:hover:bg-white/5 rounded-full transition-colors text-slate-400">
                    <i data-lucide="x" class="w-5 h-5"></i>
                </button>
            </div>

            <div class="space-y-4 mb-8">
                <ul class="userData space-y-3">
                    </ul>
                <div class="feedback px-6 py-4 rounded-2xl bg-rose-500/5 border border-rose-500/10 hidden">
                    </div>
            </div>

            <button type="button" class="closeModal w-full py-4 bg-slate-900 dark:bg-white text-white dark:text-slate-900 rounded-2xl text-[10px] font-black uppercase tracking-[0.2em] shadow-lg hover:opacity-90 transition-all">
                <?php echo app('translator')->get('Dismiss Terminal'); ?>
            </button>
        </div>
    </div>
</div>>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    (function($) {
        "use strict";

        const $modal = $('#detailModal');
        const $backdrop = $('#modalBackdrop');
        const $content = $('#modalContent');

        function openModal() {
            $modal.removeClass('hidden');
            setTimeout(() => {
                $backdrop.removeClass('opacity-0').addClass('opacity-100');
                $content.removeClass('scale-95 opacity-0').addClass('scale-100 opacity-100');
            }, 10);
        }

        function closeModal() {
            $backdrop.removeClass('opacity-100').addClass('opacity-0');
            $content.removeClass('scale-100 opacity-100').addClass('scale-95 opacity-0');
            setTimeout(() => {
                $modal.addClass('hidden');
            }, 300);
        }

        $('.detailBtn').on('click', function() {
            var userData = $(this).data('info');
            var feedback = $(this).data('admin_feedback');
            var html = '';

            if (userData) {
                userData.forEach(element => {
                    let valDisplay = element.type == 'file' 
                        ? `<a href="${element.value}" class="text-emerald-500 underline"><?php echo app('translator')->get('View Attachment'); ?></a>`
                        : element.value;

                    html += `
                    <li class="flex justify-between items-center p-4 bg-slate-50 dark:bg-white/5 rounded-2xl border border-slate-100 dark:border-white/5">
                        <span class="text-[9px] font-black text-slate-400 uppercase tracking-widest">${element.name}</span>
                        <span class="text-[11px] font-bold text-slate-900 dark:text-white uppercase">${valDisplay}</span>
                    </li>`;
                });
            }

            $('.userData').html(html);

            if (feedback) {
                $('.feedback').html(`
                    <p class="text-[9px] font-black text-rose-500 uppercase tracking-widest mb-1"><?php echo app('translator')->get('Admin Feedback'); ?></p>
                    <p class="text-xs font-bold text-slate-600 dark:text-slate-400">${feedback}</p>
                `).removeClass('hidden');
            } else {
                $('.feedback').addClass('hidden');
            }

            openModal();
            if (typeof lucide !== 'undefined') lucide.createIcons();
        });

        $('.closeModal, #modalBackdrop').on('click', closeModal);

    })(jQuery);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('Template::layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/deposit_history.blade.php ENDPATH**/ ?>