<?php
    $promotionCount = App\Models\PromotionTool::count();
?>

<header class="header">
    <div class="header__bottom">
        <div class="container">
            <nav class="navbar navbar-expand-xl p-0 align-items-center">
                <a class="site-logo site-title" href="<?php echo e(route('home')); ?>"><img src="<?php echo e(siteLogo()); ?>" alt="site-logo"></a>
                <ul class="account-menu responsive-account-menu ms-3">
                    <li class="icon"><a href="<?php echo e(route('user.home')); ?>"><i class="las la-user"></i></a></li>
                </ul>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="menu-toggle"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <ul class="navbar-nav main-menu ms-auto">
                        <li> <a href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a></li>
                        <?php if(gs('schedule_invest') || gs('staking_option') || gs('pool_option')): ?>
                            <li class="menu_has_children"><a href="javascript:void(0)"><?php echo app('translator')->get('Investment'); ?></a>
                                <ul class="sub-menu"> 
                                    <?php if(gs('staking_option')): ?>
                                        <li><a href="<?php echo e(route('user.staking.index')); ?>"><?php echo app('translator')->get('My Staking'); ?></a></li>
                                    <?php endif; ?>
                                    <?php if(gs('pool_option')): ?>
                                        <li><a href="<?php echo e(route('user.pool.index')); ?>"><?php echo app('translator')->get('Pool'); ?></a></li>
                                    <?php endif; ?>
                                    <?php if(gs('schedule_invest')): ?>
                                    <li><a href="<?php echo e(route('user.invest.schedule')); ?>"><?php echo app('translator')->get('Schedule'); ?></a></li>
                                    <?php endif; ?>
                                </ul>
                            </li>
                        <?php else: ?>
                            <li><a href="<?php echo e(route('plan')); ?>"><?php echo app('translator')->get('Plan'); ?></a></li>
                        <?php endif; ?>
                        <li class="menu_has_children"><a href="javascript:void(0)"><?php echo app('translator')->get('Finance'); ?></a>
                            <ul class="sub-menu">
                                <li><a href="<?php echo e(route('user.deposit.index')); ?>"><?php echo app('translator')->get('Deposit'); ?></a></li>
                                <li><a href="<?php echo e(route('user.withdraw')); ?>"><?php echo app('translator')->get('Withdraw'); ?></a></li>
                                <?php if(gs('b_transfer')): ?>
                                    <li><a href="<?php echo e(route('user.transfer.balance')); ?>"><?php echo app('translator')->get('Transfer Balance'); ?></a></li>
                                <?php endif; ?>
                                <li><a href="<?php echo e(route('user.transactions')); ?>"><?php echo app('translator')->get('Transactions'); ?></a></li>
                            </ul>
                        </li>
                        <li><a href="<?php echo e(route('user.referrals')); ?>"><?php echo app('translator')->get('Referrals'); ?></a></li>
                        <?php if(gs('promotional_tool') && $promotionCount): ?>
                            <li><a href="<?php echo e(route('user.promotional.banner')); ?>"><?php echo app('translator')->get('Promotional Tool'); ?></a></li>
                        <?php endif; ?>
                        <li class="menu_has_children"><a href="javascript:void(0)"><?php echo app('translator')->get('Account'); ?></a>
                            <ul class="sub-menu">
                                <li><a href="<?php echo e(route('user.profile.setting')); ?>"><?php echo app('translator')->get('Profile Setting'); ?></a></li>
                                <li><a href="<?php echo e(route('user.change.password')); ?>"><?php echo app('translator')->get('Change Password'); ?></a></li>
                                <?php if(gs('user_ranking')): ?>
                                    <li><a href="<?php echo e(route('user.invest.ranking')); ?>"><?php echo app('translator')->get('Ranking'); ?></a></li>
                                <?php endif; ?>
                                <li><a href="<?php echo e(route('user.twofactor')); ?>"><?php echo app('translator')->get('2FA Security'); ?></a></li>
                                <li><a href="<?php echo e(route('ticket.index')); ?>"><?php echo app('translator')->get('Support Ticket'); ?></a></li>
                                <li><a href="<?php echo e(route('user.logout')); ?>"> <?php echo e(__('Logout')); ?></a></li>
                            </ul>
                        </li>
                    </ul>
                    <div class="nav-right">
                        <ul class="account-menu ms-3">
                            <?php if(auth()->guard()->guest()): ?>
                                <li class="icon"><a href="<?php echo e(route('user.login')); ?>"><i class="las la-user"></i></a></li>
                            <?php else: ?>
                                <li class="icon"><a href="<?php echo e(route('user.home')); ?>"><i class="las la-user"></i></a></li>
                                <?php endif; ?>
                            </ul>
                            <?php if(gs('multi_language')): ?>
                                    <?php echo $__env->make('Template::partials.language', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                                <?php endif; ?>
                        </div>
                    </div>
                </nav>
            </div>
        </div><!-- header__bottom end -->
    </header>
    <!-- header-section end  -->
<?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/partials/user_header.blade.php ENDPATH**/ ?>