  

  <?php $__env->startSection('content'); ?>
      <?php
          $policyPages = getContent('policy_pages.element', false, null, true);
          $registerContent = getContent('register.content', true);
      ?>

      <div class="w-full max-w-sm">
          <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
              <!-- Enhanced Header -->
              <div class="px-6 py-6 text-center">
                  <h1 class="text-xl font-light text-black mb-1">Create Account</h1>
                  <p class="text-xs text-gray-500">Join Tesla Drives today</p>
              </div>

              <!-- Registration Form -->
              <div class="px-6 pb-6">
                  <form action="<?php echo e(route('user.register')); ?>" method="POST" class="space-y-4 verify-gcaptcha">
                      <?php echo csrf_field(); ?>
                      <!-- Name -->
                      <div>
                          <label for="name" class="block text-xs font-medium text-black mb-1">Full Name</label>
                          <input type="text" id="name" name="name" value="" required autofocus
                              autocomplete="name"
                              class="w-full px-3 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200 ">
                      </div>

                      <!-- Email Address -->
                      <div>
                          <label for="email" class="block text-xs font-medium text-black mb-1">Email</label>
                          <input type="email" id="email" name="email" value="" required
                              autocomplete="username"
                              class="w-full px-3 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200 ">
                      </div>

                      <!-- Password -->
                      <div>
                          <label for="password" class="block text-xs font-medium text-black mb-1">Password</label>
                          <input type="password" id="password" name="password" required autocomplete="new-password"
                              class="w-full px-3 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200 ">
                      </div>

                      <!-- Confirm Password -->
                      <div>
                          <label for="password_confirmation" class="block text-xs font-medium text-black mb-1">Confirm
                              Password</label>
                          <input type="password" id="password_confirmation" name="password_confirmation" required
                              autocomplete="new-password"
                              class="w-full px-3 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200 ">
                      </div>

                      <?php if(gs('agree')): ?>
                                    <div class="form-group form--check">
                                        <input class="form-check-input border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200" type="checkbox" id="agree" <?php if(old('agree')): echo 'checked'; endif; ?> name="agree" required>
                                        <label class="form-check-label inline-flex items-center justify-center px-3 py-2 text-xs font-medium text-gray-70" for="agree"><?php echo app('translator')->get('I agree with terms & conditions'); ?></label> <span>
                                          
                                        </span>
                                    </div>
                        <?php endif; ?>

                      <!-- Submit Button -->
                      <div class="pt-2">
                          <button type="submit"
                              class="w-full bg-black hover:bg-gray-800 text-white py-2.5 px-4 rounded-lg text-sm font-medium transition-all duration-200">
                              Create Account
                          </button>
                      </div>
                  </form>
              </div>

              <?php if(@gs('socialite_credentials')->google->status == Status::ENABLE): ?>
                  <!-- Alternative Sign In -->
                  <div class="mt-6">
                      <div class="relative">
                          <div class="absolute inset-0 flex items-center">
                              <div class="w-full border-t border-gray-200"></div>
                          </div>
                          <div class="relative flex justify-center text-xs">
                              <span class="px-3 bg-gray-50 text-gray-500">Or continue with</span>
                          </div>
                      </div>

                      <div class="mt-4 flex justify-center">
                          <a href="<?php echo e(route('user.social.login', 'google')); ?>"
                              class="inline-flex items-center justify-center px-3 py-2 border border-gray-300 rounded-lg shadow-sm bg-white text-xs font-medium text-gray-700 hover:bg-gray-50 transition-colors duration-200">
                              <svg class="h-4 w-4 mr-2" viewBox="0 0 24 24" fill="none"
                                  xmlns="http://www.w3.org/2000/svg">
                                  <path
                                      d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z"
                                      fill="#4285F4" />
                                  <path
                                      d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z"
                                      fill="#34A853" />
                                  <path
                                      d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z"
                                      fill="#FBBC05" />
                                  <path
                                      d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z"
                                      fill="#EA4335" />
                              </svg>
                              Continue with Google
                          </a>
                      </div>
                  </div>
              <?php endif; ?>

              <!-- Login Link -->
              <div class="px-6 py-4 bg-gray-50 border-t border-gray-100 text-center">
                  <p class="text-xs text-gray-500">
                      Already have an account?
                      <a href="<?php echo e(route('user.login')); ?>"
                          class="text-black hover:text-gray-600 font-medium transition-colors duration-200">
                          Sign in
                      </a>
                  </p>
              </div>
          </div>

          <!-- Terms Notice -->
          <div class="mt-6 text-center">
              <p class="text-xs text-gray-400">
                  By creating an account, you agree to our
                  <a href="<?php echo e(url('/terms')); ?>" class="text-black hover:text-gray-600 transition-colors duration-200">Terms
                      of Service</a>
                  and
                  <a href="<?php echo e(url('/privacy')); ?>"
                      class="text-black hover:text-gray-600 transition-colors duration-200">Privacy Policy</a>
              </p>
          </div>
      <?php $__env->stopSection(); ?>

<?php echo $__env->make('Template::layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/user/auth/register.blade.php ENDPATH**/ ?>