<?php $__env->startSection('content'); ?>
<div class="px-4 mx-auto py-10">

    <div class="flex flex-col md:flex-row md:items-center justify-between gap-6 mb-8">
        <div>
            <h1 class="text-xl font-light text-slate-900 dark:text-white"><?php echo app('translator')->get('Deposit History'); ?></h1>
            <p class="text-xs text-slate-500"><?php echo app('translator')->get('Track and manage your asset provisioning logs'); ?></p>
        </div>

        <div class="flex items-center gap-4">
            <form action="" method="GET" class="relative group">
                <div class="absolute inset-y-0 left-4 flex items-center pointer-events-none">
                    <i data-lucide="search" class="w-4 h-4 text-slate-400"></i>
                </div>
                <input type="text" name="search" value="<?php echo e(request()->search); ?>" placeholder="<?php echo app('translator')->get('Search TRX ID...'); ?>" 
                    class="w-full md:w-72 bg-white border border-slate-200 rounded-xl py-3 pl-12 pr-4 text-[11px] font-bold uppercase tracking-widest focus:border-black transition-all outline-none text-slate-900">
            </form>
        </div>
    </div>

    <div class="bg-white rounded-[2rem] border border-slate-100 shadow-sm overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full text-left border-collapse">
                <thead>
                    <tr class="bg-black text-white">
                        <th class="px-8 py-5 text-[10px] font-black uppercase tracking-[0.2em] opacity-70"><?php echo app('translator')->get('Gateway | Reference'); ?></th>
                        <th class="px-8 py-5 text-[10px] font-black uppercase tracking-[0.2em] opacity-70"><?php echo app('translator')->get('Initiated'); ?></th>
                        <th class="px-8 py-5 text-[10px] font-black uppercase tracking-[0.2em] opacity-70"><?php echo app('translator')->get('Staked Amount'); ?></th>
                        <th class="px-8 py-5 text-[10px] font-black uppercase tracking-[0.2em] opacity-70"><?php echo app('translator')->get('Conversion'); ?></th>
                        <th class="px-8 py-5 text-[10px] font-black uppercase tracking-[0.2em] opacity-70"><?php echo app('translator')->get('Status'); ?></th>
                        <th class="px-8 py-5 text-[10px] font-black uppercase tracking-[0.2em] opacity-70 text-right"><?php echo app('translator')->get('Details'); ?></th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-slate-50">
                    <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="group hover:bg-slate-50/50 transition-all">
                            <td class="px-8 py-6">
                                <div class="flex flex-col">
                                    <span class="text-xs font-black text-slate-900 uppercase tracking-tighter"><?php echo e(__($deposit->gateway?->name)); ?></span>
                                    <span class="text-[9px] font-mono font-bold text-slate-400 mt-1 uppercase"><?php echo e($deposit->trx); ?></span>
                                </div>
                            </td>
                            <td class="px-8 py-6">
                                <div class="flex flex-col">
                                    <span class="text-xs font-bold text-slate-700"><?php echo e(showDateTime($deposit->created_at, 'd M, Y')); ?></span>
                                    <span class="text-[9px] font-bold text-slate-400 uppercase tracking-tighter"><?php echo e(diffForHumans($deposit->created_at)); ?></span>
                                </div>
                            </td>
                            <td class="px-8 py-6">
                                <div class="flex flex-col">
                                    <span class="text-xs font-black text-slate-900">
                                        <?php echo e(showAmount($deposit->amount)); ?>

                                    </span>
                                    <span class="text-[9px] font-bold text-rose-500 mt-0.5">
                                        + <?php echo e(showAmount($deposit->charge)); ?> <?php echo app('translator')->get('Fee'); ?>
                                    </span>
                                </div>
                            </td>
                            <td class="px-8 py-6">
                                <div class="flex flex-col">
                                    <span class="text-[10px] font-bold text-slate-400 uppercase tracking-widest">
                                        <?php echo e(showAmount($deposit->final_amount, false)); ?> <?php echo e(__($deposit->method_currency)); ?>

                                    </span>
                                    <span class="text-[9px] text-slate-400 mt-1"><?php echo app('translator')->get('at rate of'); ?> <?php echo e(showAmount($deposit->rate, false)); ?></span>
                                </div>
                            </td>
                            <td class="px-8 py-6">
                                <?php echo $deposit->statusBadge ?>
                            </td>

                            <td class="px-8 py-6 text-right">
                                <?php if($deposit->method_code >= 1000 && $deposit->method_code <= 5000): ?>
                                    <button class="detailBtn group/btn w-10 h-10 rounded-xl bg-black flex items-center justify-center transition-all hover:scale-110 active:scale-95 shadow-lg" 
                                        data-info="<?php echo e(json_encode($deposit->detail)); ?>" 
                                        <?php if($deposit->status == Status::PAYMENT_REJECT): ?> data-admin_feedback="<?php echo e($deposit->admin_feedback); ?>" <?php endif; ?>>
                                        <i data-lucide="eye" class="w-4 h-4 text-white"></i>
                                    </button>
                                <?php else: ?>
                                    <div class="flex justify-end">
                                        <div class="w-10 h-10 rounded-xl bg-gray-100 flex items-center justify-center" data-bs-toggle="tooltip" title="<?php echo app('translator')->get('Auto-Settled'); ?>">
                                            <i data-lucide="check-circle-2" class="w-4 h-4 text-gray-400"></i>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="100%" class="px-8 py-24 text-center">
                                <div class="flex flex-col items-center gap-3">
                                    <i data-lucide="layers" class="w-12 h-12 text-slate-100"></i>
                                    <p class="text-[10px] font-black text-slate-300 uppercase tracking-[0.4em]"><?php echo app('translator')->get('No history found'); ?></p>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <?php if($deposits->hasPages()): ?>
        <div class="mt-8 flex justify-center">
            <?php echo e(paginateLinks($deposits)); ?>

        </div>
    <?php endif; ?>
</div>

<div id="detailModal" class="hidden fixed inset-0 z-[1000] overflow-y-auto">
    <div class="fixed inset-0 bg-black/60 backdrop-blur-sm transition-opacity duration-300 opacity-0" id="modalBackdrop"></div>
    
    <div class="flex min-h-full items-center justify-center p-4">
        <div class="relative w-full max-w-md transform overflow-hidden rounded-[2.5rem] bg-white p-8 shadow-2xl transition-all scale-95 opacity-0 duration-300 border border-slate-100" id="modalContent">
            
            <div class="flex items-center justify-between mb-8">
                <div>
                    <h3 class="text-[11px] font-black text-black uppercase tracking-[0.3em]"><?php echo app('translator')->get('Transaction Detail'); ?></h3>
                    <p class="text-[9px] text-slate-400 uppercase tracking-widest mt-1"><?php echo app('translator')->get('Verified Source Data'); ?></p>
                </div>
                <button type="button" class="closeModal p-2 hover:bg-slate-50 rounded-full transition-colors text-slate-400">
                    <i data-lucide="x" class="w-5 h-5"></i>
                </button>
            </div>

            <div class="space-y-3 mb-8">
                <ul class="userData space-y-3"></ul>
                <div class="feedback px-5 py-4 rounded-2xl bg-rose-50 border border-rose-100 hidden"></div>
            </div>

            <button type="button" class="closeModal w-full py-4 bg-black text-white rounded-2xl text-[10px] font-black uppercase tracking-[0.2em] shadow-lg active:scale-95 transition-all">
                <?php echo app('translator')->get('Dismiss View'); ?>
            </button>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($activeTemplate . 'layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/user/deposit_history.blade.php ENDPATH**/ ?>