<?php $__env->startSection('content'); ?>
<?php 
    $plan = $invest->plan;
    $totalPeriods = $invest->period > 0 ? $invest->period : 100;
    $progress = ($invest->return_rec_time / $totalPeriods) * 100;
    $progress = $progress > 100 ? 100 : $progress;
?>

<div style="padding: 1.5rem; margin: 0 auto; max-width: 1600px; font-family: 'Inter', system-ui, sans-serif; min-height: 100vh;">
    
    <div style="background: linear-gradient(135deg, #000000 0%, #111827 50%, #1f2937 100%); border-radius: 1.5rem; padding: 2rem; margin-bottom: 2rem; color: #ffffff; position: relative; overflow: hidden; box-shadow: 0 20px 25px -5px rgba(0,0,0,0.1);">
        <div style="position: absolute; inset: 0; opacity: 0.1; pointer-events: none;">
            <div style="position: absolute; top: 0; right: 0; width: 12rem; height: 12rem; background: #ffffff; border-radius: 50%; transform: translate(6rem, -6rem);"></div>
            <div style="position: absolute; bottom: 0; left: 0; width: 6rem; height: 6rem; background: #ffffff; border-radius: 50%; transform: translate(-3rem, 3rem);"></div>
        </div>

        <div style="position: relative; z-index: 10; display: flex; flex-wrap: wrap; justify-content: space-between; align-items: center; gap: 2rem;">
            <div>
                <h1 style="font-size: 1.5rem; font-weight: 300; margin: 0; letter-spacing: -0.01em;"><?php echo app('translator')->get('Investment Terminal'); ?></h1>
                <p style="color: #9ca3af; font-size: 0.875rem; margin-top: 0.25rem;"><?php echo e(__($plan->name)); ?> • <?php echo app('translator')->get('Contract'); ?> #<?php echo e($invest->trx); ?></p>
            </div>

            <div style="background: rgba(255, 255, 255, 0.15); backdrop-filter: blur(20px); -webkit-backdrop-filter: blur(20px); border-radius: 1rem; padding: 1.25rem; border: 1px solid rgba(255, 255, 255, 0.2); box-shadow: 0 10px 15px -3px rgba(0,0,0,0.2); min-width: 260px; flex: 0 1 auto;">
                <div style="display: flex; align-items: center; justify-content: space-between;">
                    <div>
                        <p style="font-size: 0.75rem; color: #d1d5db; margin-bottom: 0.25rem; text-transform: uppercase; letter-spacing: 0.05em;"><?php echo app('translator')->get('Principal Deployed'); ?></p>
                        <p style="font-size: 1.5rem; font-weight: 300; margin: 0;"><?php echo e(showAmount($invest->initial_amount)); ?></p>
                        <p style="font-size: 11px; color: #e5e7eb; margin-top: 0.25rem;">ROI @ <?php echo e(showAmount($plan->interest, false)); ?><?php echo e($plan->interest_type == 1 ? '%' : gs('cur_text')); ?></p>
                    </div>
                    <div style="width: 2.5rem; height: 2.5rem; background: rgba(255,255,255,0.1); border-radius: 0.75rem; display: flex; align-items: center; justify-content: center;">
                        <i data-lucide="bar-chart-3" style="width: 1.25rem; height: 1.25rem; color: #ffffff;"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(min(100%, 350px), 1fr)); gap: 1.5rem; margin-bottom: 3rem;">
        
        <div style="background: #ffffff; border-radius: 1.25rem; padding: 1.5rem; border: 1px solid #e5e7eb; display: flex; flex-direction: column; justify-content: space-between;">
            <div style="display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 1.5rem;">
                <div>
                    <p style="font-size: 0.75rem; color: #6b7280; font-weight: 700; text-transform: uppercase; letter-spacing: 0.05em;"><?php echo app('translator')->get('Net Settlement'); ?></p>
                    <h3 style="font-size: 2rem; font-weight: 300; color: #111827; margin: 0.25rem 0;"><?php echo e(showAmount($invest->paid)); ?></h3>
                </div>
                <div style="padding: 0.5rem; background: #ecfdf5; border-radius: 0.5rem;">
                    <i data-lucide="trending-up" style="width: 1.25rem; height: 1.25rem; color: #10b981;"></i>
                </div>
            </div>
            
            <div style="background: #f9fafb; border-radius: 0.75rem; padding: 1rem; display: flex; justify-content: space-between;">
                <div>
                    <span style="font-size: 10px; color: #9ca3af; text-transform: uppercase;"><?php echo app('translator')->get('Completed'); ?></span>
                    <p style="font-size: 13px; font-weight: 700; color: #374151; margin: 0;"><?php echo e($invest->return_rec_time); ?> / <?php echo e($invest->period > 0 ? $invest->period : '∞'); ?></p>
                </div>
                <div style="text-align: right;">
                    <span style="font-size: 10px; color: #9ca3af; text-transform: uppercase;"><?php echo app('translator')->get('Next Sync'); ?></span>
                    <p style="font-size: 13px; font-weight: 700; color: #3b82f6; margin: 0;"><?php echo e(diffForHumans($invest->next_time)); ?></p>
                </div>
            </div>
        </div>

        <div style="background: #ffffff; border-radius: 1.25rem; padding: 1.5rem; border: 1px solid #e5e7eb;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
                <p style="font-size: 0.75rem; color: #6b7280; font-weight: 700; text-transform: uppercase; letter-spacing: 0.05em;"><?php echo app('translator')->get('Contract Maturity'); ?></p>
                <?php if($invest->eligibleCapitalBack()): ?>
                    <button class="openCapitalModal" style="background: none; border: none; padding: 0; cursor: pointer; color: #111827;">
                        <i data-lucide="settings-2" style="width: 1.25rem; height: 1.25rem;"></i>
                    </button>
                <?php endif; ?>
            </div>

            <div style="margin-bottom: 1.5rem;">
                <div style="display: flex; justify-content: space-between; margin-bottom: 0.5rem;">
                    <span style="font-size: 0.875rem; font-weight: 600; color: #111827;"><?php echo e(round($progress)); ?>%</span>
                    <span style="font-size: 0.875rem; color: #6b7280;"><?php echo e(showDateTime($invest->next_time, 'H:i')); ?></span>
                </div>
                <div style="height: 8px; width: 100%; background: #f3f4f6; border-radius: 4px; overflow: hidden;">
                    <div style="height: 100%; width: <?php echo e($progress); ?>%; background: #000000; border-radius: 4px;"></div>
                </div>
            </div>

            <p style="font-size: 11px; color: #6b7280; line-height: 1.5;"><?php echo app('translator')->get('Current frequency set to'); ?> <strong><?php echo e($invest->time_name); ?></strong>. <?php echo app('translator')->get('Compounding is active for this protocol cycle.'); ?></p>
        </div>
    </div>

    <div style="background: #ffffff; border-radius: 1.25rem; border: 1px solid #e5e7eb; overflow: hidden; box-shadow: 0 1px 3px rgba(0,0,0,0.1);">
        <div style="padding: 1.5rem; border-bottom: 1px solid #f3f4f6;">
            <h3 style="font-size: 0.875rem; font-weight: 700; text-transform: uppercase; letter-spacing: 0.05em; margin: 0;"><?php echo app('translator')->get('Transaction Ledger'); ?></h3>
        </div>
        <div style="overflow-x: auto;">
            <table style="width: 100%; border-collapse: collapse; min-width: 600px;">
                <thead>
                    <tr style="background: #f9fafb; text-align: left;">
                        <th style="padding: 1rem 1.5rem; font-size: 11px; font-weight: 600; color: #6b7280; text-transform: uppercase;"><?php echo app('translator')->get('Ref ID'); ?></th>
                        <th style="padding: 1rem 1.5rem; font-size: 11px; font-weight: 600; color: #6b7280; text-transform: uppercase;"><?php echo app('translator')->get('Execution Date'); ?></th>
                        <th style="padding: 1rem 1.5rem; font-size: 11px; font-weight: 600; color: #6b7280; text-transform: uppercase;"><?php echo app('translator')->get('Yield'); ?></th>
                        <th style="padding: 1rem 1.5rem; font-size: 11px; font-weight: 600; color: #6b7280; text-transform: uppercase; text-align: right;"><?php echo app('translator')->get('Context'); ?></th>
                    </tr>
                </thead>
                <tbody style="font-size: 13px;">
                    <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr style="border-bottom: 1px solid #f3f4f6; transition: background 0.2s;" onmouseover="this.style.background='#fcfcfc'" onmouseout="this.style.background='transparent'">
                            <td style="padding: 1rem 1.5rem; font-family: monospace; color: #6b7280;"><?php echo e($trx->trx); ?></td>
                            <td style="padding: 1rem 1.5rem; font-weight: 500;"><?php echo e(showDateTime($trx->created_at, 'd M, Y H:i')); ?></td>
                            <td style="padding: 1rem 1.5rem;">
                                <span style="font-weight: 700; color: <?php echo e($trx->trx_type == '+' ? '#10b981' : '#ef4444'); ?>;">
                                    <?php echo e($trx->trx_type); ?><?php echo e(showAmount($trx->amount)); ?>

                                </span>
                            </td>
                            <td style="padding: 1rem 1.5rem; text-align: right; color: #6b7280;"><?php echo e(__($trx->details)); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="4" style="padding: 4rem; text-align: center; color: #9ca3af;"><?php echo app('translator')->get('No transaction records found for this terminal.'); ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('Template::layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/AMPPS/www/latesthyiptesla/core/resources/views/templates/bit_gold/user/invest_details.blade.php ENDPATH**/ ?>