<!DOCTYPE html>
<html lang="en" class="h-full bg-white">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> <?php echo e(gs()->siteName(__($pageTitle))); ?></title>
    <?php echo $__env->make('partials.seo', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; }
    </style>
</head>
<body class="h-full">

<div class="flex min-h-full">
    
    <div class="flex flex-1 flex-col justify-center px-4 py-12 sm:px-6 lg:flex-none lg:px-20 xl:px-24">
        <div class="mx-auto w-full max-w-sm lg:w-96">
            
            <div class="mb-10">
                <div class="flex items-center gap-3">
                    <img src="<?php echo e(siteLogo()); ?>" width="100" alt="site-logo">
                </div>
                <h4 class="mt-8 text-2xl font-extrabold tracking-tight text-slate-900">Welcome back</h4>
                <p class="mt-2 text-sm text-slate-500">
                    New to the platform? 
                    <a href="<?php echo e(route('user.register')); ?>" class="font-medium text-emerald-600 hover:text-emerald-500 transition-colors">Start investing today</a>
                </p>
            </div>

            <div class="mt-8">
                <form action="<?php echo e(route('user.login')); ?>" method="POST" class="space-y-6">
                    <?php echo csrf_field(); ?>

                    <?php if($errors->any()): ?>
                    <div class="rounded-lg bg-red-50 p-4 border border-red-100">
                        <div class="flex">
                            <div class="ml-3">
                                <p class="text-sm font-medium text-red-800">Invalid login credentials.</p>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <div>
                        <label for="email" class="block text-sm font-semibold text-slate-700">Email Address</label>
                        <div class="mt-1">
                            <input id="email" name="username" type="email" autocomplete="email" required 
                                class="block w-full rounded-lg border border-slate-200 px-4 py-3 text-slate-900 shadow-sm placeholder:text-slate-400 focus:border-emerald-500 focus:ring-2 focus:ring-emerald-500/20 sm:text-sm transition-all"
                                placeholder="name@example.com">
                        </div>
                    </div>

                    <div>
                        <div class="flex items-center justify-between">
                            <label for="password" class="block text-sm font-semibold text-slate-700">Password</label>
                            <a href="<?php echo e(route('user.password.request')); ?>" class="text-xs font-bold text-emerald-600 hover:text-emerald-500">Forgot?</a>
                        </div>
                        <div class="mt-1">
                            <input id="password" name="password" type="password" required 
                                class="block w-full rounded-lg border border-slate-200 px-4 py-3 text-slate-900 shadow-sm placeholder:text-slate-400 focus:border-emerald-500 focus:ring-2 focus:ring-emerald-500/20 sm:text-sm transition-all"
                                placeholder="••••••••">
                        </div>
                    </div>
                    <?php if (isset($component)) { $__componentOriginalff0a9fdc5428085522b49c68070c11d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff0a9fdc5428085522b49c68070c11d6 = $attributes; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Captcha::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $attributes = $__attributesOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $component = $__componentOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__componentOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>

                    <div class="flex items-center">
                        <input id="remember-me" name="remember" type="checkbox" class="h-4 w-4 rounded border-slate-300 text-emerald-600 focus:ring-emerald-500">
                        <label for="remember-me" class="ml-3 block text-sm text-slate-600">Keep me logged in</label>
                    </div>

                    <button type="submit" class="flex w-full justify-center rounded-lg bg-slate-900 px-4 py-3 text-sm font-bold text-white shadow-sm hover:bg-slate-800 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-slate-900 active:scale-[0.99] transition-all">
                        Sign In
                    </button>
                </form>
            </div>

            <footer class="mt-12">
                <div class="flex items-center gap-4 text-xs text-slate-400 font-medium">
                    <span class="flex items-center gap-1">
                        <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd"></path></svg>
                        End-to-End Encryption
                    </span>
                    <span>&bull;</span>
                    <span>v2.4.0</span>
                </div>
            </footer>
        </div>
    </div>

    <div class="relative hidden w-0 flex-1 lg:block">
        <div class="absolute inset-0 h-full w-full bg-slate-900">
            <svg class="absolute inset-0 h-full w-full" fill="none" viewBox="0 0 400 400" preserveAspectRatio="xMidYMid slice" xmlns="http://www.w3.org/2000/svg">
                <defs>
                    <pattern id="grid" width="40" height="40" patternUnits="userSpaceOnUse">
                        <path d="M0 40L40 0M0 0l40 40" stroke="white" stroke-opacity="0.05" />
                    </pattern>
                </defs>
                <rect width="100%" height="100%" fill="url(#grid)" />
            </svg>
            
            <div class="relative flex h-full flex-col justify-center px-12 text-white">
                <div class="max-w-md">
                    <div class="mb-8 inline-flex items-center rounded-full bg-emerald-500/10 px-3 py-1 text-sm font-medium text-emerald-400 ring-1 ring-inset ring-emerald-500/20">
                        Real-time Market Insights
                    </div>
                    <h2 class="text-4xl font-bold leading-tight">Build your future with institutional-grade tools.</h2>
                    <p class="mt-6 text-lg text-slate-300">Join over 50,000 investors worldwide managing their portfolios with SecureInvest's automated ROI tracking.</p>
                    
                    <div class="mt-10 grid grid-cols-2 gap-8 border-t border-white/10 pt-10">
                        <div>
                            <p class="text-2xl font-bold">$4.2B+</p>
                            <p class="mt-1 text-sm text-slate-400">Assets Managed</p>
                        </div>
                        <div>
                            <p class="text-2xl font-bold">12.4%</p>
                            <p class="mt-1 text-sm text-slate-400">Avg. Annual ROI</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
    <?php echo $__env->make('partials.notify', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

</body>
</html>
<?php /**PATH /Applications/AMPPS/www/latesthyip/core/resources/views/templates/bit_gold/user/auth/login.blade.php ENDPATH**/ ?>